/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.VolumeChooserIT;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VolumeIT
extends ConfigurableMacBase {
    private File volDirBase;
    private Path v1;
    private Path v2;
    private Path v3;
    private List<String> expected = new ArrayList<String>();

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        File baseDir = cfg.getDir();
        this.volDirBase = new File(baseDir, "volumes");
        File v1f = new File(this.volDirBase, "v1");
        File v2f = new File(this.volDirBase, "v2");
        this.v1 = new Path("file://" + v1f.getAbsolutePath());
        this.v2 = new Path("file://" + v2f.getAbsolutePath());
        File v3f = new File(this.volDirBase, "v3");
        this.v3 = new Path("file://" + v3f.getAbsolutePath());
        for (int i = 0; i < 100; ++i) {
            String row = String.format("%06d", i * 100 + 3);
            this.expected.add(row + ":cf1:cq1:1");
        }
        cfg.setProperty(Property.INSTANCE_VOLUMES, this.v1 + "," + this.v2);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.getKey(), "15s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        super.configure(cfg, hadoopCoreSite);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            TreeSet<Text> partitions = new TreeSet<Text>();
            for (String s : "d,m,t".split(",")) {
                partitions.add(new Text(s));
            }
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(partitions);
            client.tableOperations().create(tableName, ntc);
            VolumeChooserIT.writeDataToTable(client, tableName, VolumeChooserIT.alpha_rows);
            client.tableOperations().flush(tableName, null, null, true);
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                int i = 0;
                for (Map.Entry entry : scanner) {
                    Assertions.assertEquals((Object)VolumeChooserIT.alpha_rows[i++], (Object)((Key)entry.getKey()).getRow().toString());
                }
            }
            scanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            try {
                scanner.setRange(new Range((CharSequence)"1", (CharSequence)"1<"));
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                int fileCount = 0;
                for (Map.Entry entry : scanner) {
                    boolean inV1 = ((Key)entry.getKey()).getColumnQualifier().toString().contains(this.v1.toString());
                    boolean inV2 = ((Key)entry.getKey()).getColumnQualifier().toString().contains(this.v2.toString());
                    Assertions.assertTrue((inV1 || inV2 ? 1 : 0) != 0);
                    ++fileCount;
                }
                Assertions.assertEquals((int)4, (int)fileCount);
                List diskUsage = client.tableOperations().getDiskUsage(Collections.singleton(tableName));
                Assertions.assertEquals((int)1, (int)diskUsage.size());
                long usage = ((DiskUsage)diskUsage.get(0)).getUsage();
                log.debug("usage {}", (Object)usage);
                Assertions.assertTrue((usage > 700L && usage < 900L ? 1 : 0) != 0);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }

    private void verifyData(List<String> expected, Scanner createScanner) {
        ArrayList<CallSite> actual = new ArrayList<CallSite>();
        for (Map.Entry entry : createScanner) {
            Key k = (Key)entry.getKey();
            actual.add((CallSite)((Object)(k.getRow() + ":" + k.getColumnFamily() + ":" + k.getColumnQualifier() + ":" + entry.getValue())));
        }
        Collections.sort(expected);
        Collections.sort(actual);
        createScanner.close();
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testAddVolumes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.getUniqueNames(2);
            InstanceId uuid = this.verifyAndShutdownCluster(client, tableNames[0]);
            this.updateConfig(config -> config.setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)(this.v1 + "," + this.v2 + "," + this.v3)));
            Assertions.assertEquals((int)0, (int)this.cluster.exec(Initialize.class, new String[]{"--add-volumes"}).getProcess().waitFor());
            this.checkVolumesInitialized(Arrays.asList(this.v1, this.v2, this.v3), uuid);
            this.cluster.start();
            this.verifyVolumesUsed(client, tableNames[1], false, this.v1, this.v2, this.v3);
        }
    }

    private InstanceId verifyAndShutdownCluster(AccumuloClient c, String tableName) throws Exception {
        InstanceId uuid = c.instanceOperations().getInstanceId();
        this.verifyVolumesUsed(c, tableName, false, this.v1, this.v2);
        Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        this.cluster.stop();
        return uuid;
    }

    @Test
    public void testNonConfiguredVolumes() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            InstanceId uuid = this.verifyAndShutdownCluster(client, tableNames[0]);
            this.updateConfig(config -> config.setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)(this.v2 + "," + this.v3)));
            Assertions.assertEquals((int)0, (int)this.cluster.exec(Initialize.class, new String[]{"--add-volumes"}).getProcess().waitFor());
            this.checkVolumesInitialized(Arrays.asList(this.v1, this.v2, this.v3), uuid);
            this.cluster.start();
            this.verifyData(this.expected, client.createScanner(tableNames[0], Authorizations.EMPTY));
            this.verifyVolumesUsed(client, tableNames[1], false, this.v2, this.v3);
        }
    }

    private void checkVolumesInitialized(List<Path> volumes, InstanceId uuid) throws Exception {
        for (Path volumePath : volumes) {
            FileSystem fs = volumePath.getFileSystem(this.cluster.getServerContext().getHadoopConf());
            Path vp = new Path(volumePath, "instance_id");
            FileStatus[] iids = fs.listStatus(vp);
            Assertions.assertEquals((int)1, (int)iids.length);
            Assertions.assertEquals((Object)uuid.canonical(), (Object)iids[0].getPath().getName());
        }
    }

    private void writeData(String tableName, AccumuloClient client) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 100; ++i) {
            splits.add(new Text(String.format("%06d", i * 100)));
        }
        NewTableConfiguration ntc = new NewTableConfiguration().withSplits(splits);
        client.tableOperations().create(tableName, ntc);
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            for (int i = 0; i < 100; ++i) {
                String row = String.format("%06d", i * 100 + 3);
                Mutation m = new Mutation((CharSequence)row);
                m.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"1");
                bw.addMutation(m);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyVolumesUsed(AccumuloClient client, String tableName, boolean shouldExist, Path ... paths) throws Exception {
        if (!client.tableOperations().exists(tableName)) {
            Assertions.assertFalse((boolean)shouldExist);
            this.writeData(tableName, client);
            this.verifyData(this.expected, client.createScanner(tableName, Authorizations.EMPTY));
            client.tableOperations().flush(tableName, null, null, true);
        }
        this.verifyData(this.expected, client.createScanner(tableName, Authorizations.EMPTY));
        TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
        try (Scanner metaScanner = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            metaScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            metaScanner.setRange(new KeyExtent(tableId, null, null).toMetaRange());
            int[] counts = new int[paths.length];
            block7: for (Object entry : metaScanner) {
                String string = ((Key)entry.getKey()).getColumnQualifier().toString();
                for (int i = 0; i < paths.length; ++i) {
                    if (!string.startsWith(paths[i].toString())) continue;
                    int n = i;
                    counts[n] = counts[n] + 1;
                    continue block7;
                }
                Assertions.fail((String)("Unexpected volume " + string));
            }
            block9: while (true) {
                WalStateManager wals = new WalStateManager(this.getServerContext());
                try {
                    block10: for (Map.Entry entry : wals.getAllState().entrySet()) {
                        for (Path path : paths) {
                            if (((Path)entry.getKey()).toString().startsWith(path.toString())) continue block10;
                        }
                        log.warn("Unexpected volume " + entry.getKey() + " (" + entry.getValue() + ")");
                        continue block9;
                    }
                }
                catch (WalStateManager.WalMarkerException e) {
                    Throwable throwable = e.getCause();
                    if (!(throwable instanceof KeeperException.NoNodeException)) throw e;
                    continue;
                }
                break;
            }
            int sum = 0;
            for (int count : counts) {
                Assertions.assertTrue((count > 0 ? 1 : 0) != 0);
                sum += count;
            }
            Assertions.assertEquals((int)100, (int)sum);
            return;
        }
    }

    @Test
    public void testRemoveVolumes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.getUniqueNames(2);
            this.verifyVolumesUsed(client, tableNames[0], false, this.v1, this.v2);
            Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
            this.cluster.stop();
            this.updateConfig(config -> config.setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)this.v2.toString()));
            this.cluster.start();
            client.tableOperations().compact(tableNames[0], null, null, true, true);
            this.verifyVolumesUsed(client, tableNames[0], true, this.v2);
            client.tableOperations().compact(RootTable.NAME, new CompactionConfig().setWait(true));
            int count = 0;
            for (StoredTabletFile file : ((ClientContext)client).getAmple().readTablet(RootTable.EXTENT, new TabletMetadata.ColumnType[0]).getFiles()) {
                Assertions.assertTrue((boolean)file.getMetaUpdateDelete().startsWith(this.v2.toString()));
                ++count;
            }
            Assertions.assertTrue((count > 0 ? 1 : 0) != 0);
            client.tableOperations().clone(tableNames[0], tableNames[1], true, new HashMap(), new HashSet());
            client.tableOperations().flush(MetadataTable.NAME, null, null, true);
            client.tableOperations().flush(RootTable.NAME, null, null, true);
            this.verifyVolumesUsed(client, tableNames[0], true, this.v2);
            this.verifyVolumesUsed(client, tableNames[1], true, this.v2);
        }
    }

    private void testReplaceVolume(AccumuloClient client, boolean cleanShutdown) throws Exception {
        String[] tableNames = this.getUniqueNames(3);
        this.verifyVolumesUsed(client, tableNames[0], false, this.v1, this.v2);
        try (AccumuloClient c2 = this.cluster.createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));){
            this.writeData(tableNames[1], c2);
        }
        if (cleanShutdown) {
            Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        }
        this.cluster.stop();
        File v1f = new File(this.v1.toUri());
        File v8f = new File(new File(this.v1.getParent().toUri()), "v8");
        Assertions.assertTrue((boolean)v1f.renameTo(v8f), (String)("Failed to rename " + v1f + " to " + v8f));
        Path v8 = new Path(v8f.toURI());
        File v2f = new File(this.v2.toUri());
        File v9f = new File(new File(this.v2.getParent().toUri()), "v9");
        Assertions.assertTrue((boolean)v2f.renameTo(v9f), (String)("Failed to rename " + v2f + " to " + v9f));
        Path v9 = new Path(v9f.toURI());
        this.updateConfig(config -> {
            config.setProperty(Property.INSTANCE_VOLUMES.getKey(), (Object)(v8 + "," + v9));
            config.setProperty(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey(), (Object)(this.v1 + " " + v8 + "," + this.v2 + " " + v9));
        });
        this.cluster.start();
        this.verifyVolumesUsed(client, tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(client, tableNames[1], true, v8, v9);
        client.tableOperations().compact(tableNames[0], null, null, true, true);
        client.tableOperations().compact(tableNames[1], null, null, true, true);
        this.verifyVolumesUsed(client, tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(client, tableNames[1], true, v8, v9);
        client.tableOperations().compact(RootTable.NAME, new CompactionConfig().setWait(true));
        int count = 0;
        for (StoredTabletFile file : ((ClientContext)client).getAmple().readTablet(RootTable.EXTENT, new TabletMetadata.ColumnType[0]).getFiles()) {
            Assertions.assertTrue((file.getMetaUpdateDelete().startsWith(v8.toString()) || file.getMetaUpdateDelete().startsWith(v9.toString()) ? 1 : 0) != 0);
            ++count;
        }
        Assertions.assertTrue((count > 0 ? 1 : 0) != 0);
        client.tableOperations().clone(tableNames[1], tableNames[2], true, new HashMap(), new HashSet());
        client.tableOperations().flush(MetadataTable.NAME, null, null, true);
        client.tableOperations().flush(RootTable.NAME, null, null, true);
        this.verifyVolumesUsed(client, tableNames[0], true, v8, v9);
        this.verifyVolumesUsed(client, tableNames[1], true, v8, v9);
        this.verifyVolumesUsed(client, tableNames[2], true, v8, v9);
    }

    @Test
    public void testCleanReplaceVolumes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.testReplaceVolume(client, true);
        }
    }

    @Test
    public void testDirtyReplaceVolumes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.testReplaceVolume(client, false);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="paths provided by test")
    private void updateConfig(Consumer<PropertiesConfiguration> updater) throws Exception {
        File file = new File(this.cluster.getAccumuloPropertiesPath());
        PropertiesConfiguration config = new PropertiesConfiguration();
        try (Closeable out = new FileReader(file, StandardCharsets.UTF_8);){
            config.read((Reader)out);
        }
        updater.accept(config);
        out = new FileWriter(file, StandardCharsets.UTF_8);
        try {
            config.write((Writer)out);
        }
        finally {
            ((OutputStreamWriter)out).close();
        }
    }
}

