/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VolumeManagerIT
extends ConfigurableMacBase {
    private String vol1;
    private String vol2;

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.useMiniDFS(true);
        cfg.setPreStartConfigProcessor(config -> {
            this.vol1 = (String)config.getSiteConfig().get(Property.INSTANCE_VOLUMES.getKey());
            Assertions.assertTrue((boolean)this.vol1.contains("localhost"));
            this.vol2 = this.vol1.replace("localhost", "127.0.0.1");
            config.setProperty(Property.INSTANCE_VOLUMES.getKey(), String.join((CharSequence)",", this.vol2, this.vol1));
            config.setProperty("general.volume.chooser", "org.apache.accumulo.core.spi.fs.PreferredVolumeChooser");
            config.setProperty("general.custom.volume.preferred.default", this.vol1);
            config.setProperty("general.custom.volume.preferred.logger", this.vol2);
            String vol1FileOutput = this.vol1.replaceAll(":", "\\\\:");
            String vol2FileOutput = this.vol2.replaceAll(":", "\\\\:");
            config.setProperty(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + vol1FileOutput + ".dfs.blocksize", "10485760");
            config.setProperty(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + vol2FileOutput + ".dfs.blocksize", "51200000");
            config.setProperty(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + vol1FileOutput + ".dfs.client.use.datanode.hostname", "true");
            config.setProperty(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + vol2FileOutput + ".dfs.client.use.datanode.hostname", "false");
            config.setProperty(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + vol1FileOutput + ".dfs.client.hedged.read.threadpool.size", "0");
            config.setProperty(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + vol2FileOutput + ".dfs.client.hedged.read.threadpool.size", "1");
        });
    }

    @Test
    public void testHdfsConfigOverrides() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Map siteConfig = c.instanceOperations().getSiteConfiguration();
            Assertions.assertEquals((Object)"10485760", siteConfig.get(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + this.vol1 + ".dfs.blocksize"));
            Assertions.assertEquals((Object)"51200000", siteConfig.get(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + this.vol2 + ".dfs.blocksize"));
            Assertions.assertEquals((Object)"true", siteConfig.get(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + this.vol1 + ".dfs.client.use.datanode.hostname"));
            Assertions.assertEquals((Object)"false", siteConfig.get(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + this.vol2 + ".dfs.client.use.datanode.hostname"));
            Assertions.assertEquals((Object)"0", siteConfig.get(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + this.vol1 + ".dfs.client.hedged.read.threadpool.size"));
            Assertions.assertEquals((Object)"1", siteConfig.get(Property.INSTANCE_VOLUME_CONFIG_PREFIX.getKey() + this.vol2 + ".dfs.client.hedged.read.threadpool.size"));
            String[] names = this.getUniqueNames(2);
            String t1 = names[0];
            String t2 = names[1];
            NewTableConfiguration ntc1 = new NewTableConfiguration();
            ntc1.setProperties(Map.of("table.custom.volume.preferred", this.vol1));
            c.tableOperations().create(t1, ntc1);
            ReadWriteIT.ingest(c, 10, 10, 100, 0, t1);
            c.tableOperations().flush(t1, null, null, true);
            NewTableConfiguration ntc2 = new NewTableConfiguration();
            ntc2.setProperties(Map.of("table.custom.volume.preferred", this.vol2));
            c.tableOperations().create(t2, ntc2);
            ReadWriteIT.ingest(c, 10, 10, 100, 0, t2);
            c.tableOperations().flush(t2, null, null, true);
            String tid1 = (String)c.tableOperations().tableIdMap().get(t1);
            String tid2 = (String)c.tableOperations().tableIdMap().get(t2);
            Assertions.assertNotNull((Object)tid1);
            Assertions.assertNotNull((Object)tid2);
            DistributedFileSystem fs = this.cluster.getMiniDfs().getFileSystem();
            RemoteIterator iter1 = fs.listFiles(new Path("/accumulo/tables/" + tid1), true);
            while (iter1.hasNext()) {
                LocatedFileStatus stat = (LocatedFileStatus)iter1.next();
                if (!stat.isFile()) continue;
                Assertions.assertEquals((long)0xA00000L, (long)stat.getBlockSize());
            }
            RemoteIterator iter2 = fs.listFiles(new Path("/accumulo/tables/" + tid2), true);
            while (iter2.hasNext()) {
                LocatedFileStatus stat = (LocatedFileStatus)iter2.next();
                if (!stat.isFile()) continue;
                Assertions.assertEquals((long)51200000L, (long)stat.getBlockSize());
            }
        }
    }
}

