/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WaitForBalanceIT
extends ConfigurableMacBase {
    private static final int NUM_SPLITS = 50;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                scanner.forEach((k, v) -> {});
            }
            c.instanceOperations().waitForBalance();
            Assertions.assertTrue((boolean)this.isBalanced(c));
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.instanceOperations().waitForBalance();
            TreeSet<Text> partitionKeys = new TreeSet<Text>();
            for (int i = 0; i < 50; ++i) {
                partitionKeys.add(new Text("" + i));
            }
            c.tableOperations().addSplits(tableName, partitionKeys);
            Assertions.assertFalse((boolean)this.isBalanced(c));
            c.instanceOperations().waitForBalance();
            Assertions.assertTrue((boolean)this.isBalanced(c));
        }
    }

    private boolean isBalanced(AccumuloClient c) throws Exception {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        int offline = 0;
        for (String tableName : new String[]{MetadataTable.NAME, RootTable.NAME}) {
            try (Scanner s = c.createScanner(tableName, Authorizations.EMPTY);){
                s.setRange(MetadataSchema.TabletsSection.getRange());
                s.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)s);
                String location = null;
                for (Map.Entry entry : s) {
                    Key key = (Key)entry.getKey();
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                        location = key.getColumnQualifier().toString();
                        continue;
                    }
                    if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) continue;
                    if (location == null) {
                        ++offline;
                    } else {
                        Integer count = (Integer)counts.get(location);
                        if (count == null) {
                            count = 0;
                        }
                        count = count + 1;
                        counts.put(location, count);
                    }
                    location = null;
                }
            }
        }
        if (offline > 1) {
            System.out.println("Offline tablets " + offline);
            return false;
        }
        int average = 0;
        for (Integer i : counts.values()) {
            average += i.intValue();
        }
        average /= counts.size();
        System.out.println(counts);
        int tablesCount = c.tableOperations().list().size();
        for (Map.Entry hostCount : counts.entrySet()) {
            if (Math.abs(average - (Integer)hostCount.getValue()) <= tablesCount) continue;
            System.out.println("Average " + average + " count " + (String)hostCount.getKey() + ": " + hostCount.getValue());
            return false;
        }
        return true;
    }
}

