/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.constraints.Constraint;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class WriteAfterCloseIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.MANAGER_RECOVERY_DELAY, "1s");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "10s");
        cfg.setProperty(Property.TSERV_MINTHREADS, "256");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @CsvSource(value={"time,   kill,  timeout, conditional", "MILLIS,  false, 0,       false", "LOGICAL, false, 0,       false", "MILLIS,  true,  0,       false", "MILLIS,  false, 2000,    false", "MILLIS,  false, 0,       true", "LOGICAL, false, 0,       true", "MILLIS,  true,  0,       true", "MILLIS,  false, 2000,    true"}, useHeadersInDisplayName=true)
    public void testWriteAfterClose(TimeType timeType, boolean killTservers, long timeout, boolean useConditionalWriter) throws Exception {
        block22: {
            String table = this.getUniqueNames(1)[0];
            Properties props = new Properties();
            props.putAll((Map<?, ?>)WriteAfterCloseIT.getClientProps());
            props.setProperty(Property.GENERAL_RPC_TIMEOUT.getKey(), "1s");
            NewTableConfiguration ntc = new NewTableConfiguration().setTimeType(timeType);
            ntc.setProperties(Map.of(Property.TABLE_CONSTRAINT_PREFIX.getKey() + "1", SleepyConstraint.class.getName()));
            ExecutorService executor = Executors.newCachedThreadPool();
            try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(props).build();){
                boolean expectErrors;
                c.tableOperations().create(table, ntc);
                ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
                for (int i = 0; i < 100; ++i) {
                    futures.add(executor.submit(WriteAfterCloseIT.createWriteTask(i * 1000, c, table, timeout, useConditionalWriter)));
                }
                if (killTservers) {
                    Thread.sleep(250L);
                    WriteAfterCloseIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                    Thread.sleep(11000L);
                    WriteAfterCloseIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
                }
                int errorCount = 0;
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        Throwable cause;
                        for (cause = e.getCause(); cause != null && !(cause instanceof TimedOutException); cause = cause.getCause()) {
                        }
                        Assertions.assertNotNull((Object)cause);
                        ++errorCount;
                    }
                }
                boolean bl = expectErrors = timeout > 0L;
                if (expectErrors) {
                    Assertions.assertTrue((errorCount > 0 ? 1 : 0) != 0);
                    break block22;
                }
                Assertions.assertEquals((int)0, (int)errorCount);
                Thread.sleep(4000L);
                try (Scanner scanner = c.createScanner(table);){
                    Assertions.assertEquals((long)0L, (long)scanner.stream().count());
                }
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    private static Callable<Void> createWriteTask(int row, AccumuloClient c, String table, long timeout, boolean useConditionalWriter) {
        return () -> {
            Mutation m;
            ConditionalWriter writer;
            if (useConditionalWriter) {
                ConditionalWriterConfig cwc = new ConditionalWriterConfig().setTimeout(timeout, TimeUnit.MILLISECONDS);
                writer = c.createConditionalWriter(table, cwc);
                try {
                    m = new ConditionalMutation((CharSequence)("r" + row), new Condition[0]);
                    m.addCondition(new Condition((CharSequence)"f1", (CharSequence)"q1"));
                    m.put((CharSequence)"f1", (CharSequence)"q1", new Value((CharSequence)"v1"));
                    ConditionalWriter.Result result = writer.write((ConditionalMutation)m);
                    ConditionalWriter.Status status = result.getStatus();
                    Assertions.assertTrue((status == ConditionalWriter.Status.ACCEPTED || status == ConditionalWriter.Status.UNKNOWN ? 1 : 0) != 0);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            BatchWriterConfig bwc = new BatchWriterConfig().setTimeout(timeout, TimeUnit.MILLISECONDS);
            writer = c.createBatchWriter(table, bwc);
            try {
                m = new Mutation((CharSequence)("r" + row));
                m.put((CharSequence)"f1", (CharSequence)"q1", new Value((CharSequence)"v1"));
                writer.addMutation(m);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            try (BatchWriter writer2 = c.createBatchWriter(table);){
                Mutation m2 = new Mutation((CharSequence)("r" + row));
                m2.putDelete((CharSequence)"f1", (CharSequence)"q1");
                writer2.addMutation(m2);
            }
            return null;
        };
    }

    public static class SleepyConstraint
    implements Constraint {
        private static final SecureRandom rand = new SecureRandom();
        private static final long SLEEP_TIME = 4000L;

        public String getViolationDescription(short violationCode) {
            return "No such violation";
        }

        public List<Short> check(Constraint.Environment env, Mutation mutation) {
            if (mutation.getUpdates().stream().anyMatch(ColumnUpdate::isDeleted)) {
                return null;
            }
            if (rand.nextBoolean()) {
                UtilWaitThread.sleep((long)4000L);
            }
            return null;
        }
    }
}

