/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.YieldingIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YieldScannersIT
extends AccumuloClusterHarness {
    Logger log = LoggerFactory.getLogger(YieldScannersIT.class);
    private static final char START_ROW = 'a';

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    @Test
    public void testScan() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(YieldScannersIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            BatchWriter writer = client.createBatchWriter(tableName);
            for (int i = 0; i < 10; ++i) {
                byte[] row = new byte[]{(byte)(97 + i)};
                Mutation m = new Mutation(new Text(row));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                writer.addMutation(m);
            }
            writer.flush();
            writer.close();
            this.log.info("Creating scanner");
            try (Scanner scanner = client.createScanner(tableName, Authorizations.EMPTY);){
                IteratorSetting cfg = new IteratorSetting(100, YieldingIterator.class);
                scanner.addScanIterator(cfg);
                this.log.info("iterating");
                Iterator it = scanner.iterator();
                int keyCount = 0;
                int yieldNextCount = 0;
                int yieldSeekCount = 0;
                while (it.hasNext()) {
                    Map.Entry next = (Map.Entry)it.next();
                    this.log.info(keyCount + ": Got key " + next.getKey() + " with value " + next.getValue());
                    char expected = (char)(97 + keyCount);
                    Assertions.assertEquals((Object)Character.toString(expected), (Object)((Key)next.getKey()).getRow().toString(), (String)"Unexpected row");
                    if ((keyCount & 1) != 0) {
                        ++yieldNextCount;
                        ++yieldSeekCount;
                    }
                    String[] value = ((Value)next.getValue()).toString().split(",");
                    Assertions.assertEquals((Object)Integer.toString(yieldNextCount), (Object)value[0], (String)"Unexpected yield next count");
                    Assertions.assertEquals((Object)Integer.toString(yieldSeekCount), (Object)value[1], (String)"Unexpected yield seek count");
                    Assertions.assertEquals((Object)Integer.toString(yieldNextCount + yieldSeekCount), (Object)value[2], (String)"Unexpected rebuild count");
                    ++keyCount;
                }
                Assertions.assertEquals((int)10, (int)keyCount, (String)"Did not get the expected number of results");
            }
        }
    }

    @Test
    public void testBatchScan() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(YieldScannersIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            BatchWriter writer = client.createBatchWriter(tableName);
            for (int i = 0; i < 10; ++i) {
                byte[] row = new byte[]{(byte)(97 + i)};
                Mutation m = new Mutation(new Text(row));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                writer.addMutation(m);
            }
            writer.flush();
            writer.close();
            this.log.info("Creating batch scanner");
            try (BatchScanner scanner = client.createBatchScanner(tableName);){
                IteratorSetting cfg = new IteratorSetting(100, YieldingIterator.class);
                scanner.addScanIterator(cfg);
                scanner.setRanges(Collections.singleton(new Range()));
                this.log.info("iterating");
                Iterator it = scanner.iterator();
                int keyCount = 0;
                int yieldNextCount = 0;
                int yieldSeekCount = 0;
                while (it.hasNext()) {
                    Map.Entry next = (Map.Entry)it.next();
                    this.log.info(keyCount + ": Got key " + next.getKey() + " with value " + next.getValue());
                    char expected = (char)(97 + keyCount);
                    Assertions.assertEquals((Object)Character.toString(expected), (Object)((Key)next.getKey()).getRow().toString(), (String)"Unexpected row");
                    if ((keyCount & 1) != 0) {
                        ++yieldNextCount;
                        ++yieldSeekCount;
                    }
                    String[] value = ((Value)next.getValue()).toString().split(",");
                    Assertions.assertEquals((Object)Integer.toString(yieldNextCount), (Object)value[0], (String)"Unexpected yield next count");
                    Assertions.assertEquals((Object)Integer.toString(yieldSeekCount), (Object)value[1], (String)"Unexpected yield seek count");
                    Assertions.assertEquals((Object)Integer.toString(yieldNextCount + yieldSeekCount), (Object)value[2], (String)"Unexpected rebuild count");
                    ++keyCount;
                }
                Assertions.assertEquals((int)10, (int)keyCount, (String)"Did not get the expected number of results");
            }
        }
    }

    @Test
    public void testBatchScanWithSplits() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        TreeSet<Text> splits = new TreeSet<Text>();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(YieldScannersIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            ArrayList<Range> ranges = new ArrayList<Range>();
            int alphabetLength = 26;
            try (BatchWriter writer = client.createBatchWriter(tableName, new BatchWriterConfig());){
                for (int i = 0; i < 26; ++i) {
                    byte[] row = new byte[]{(byte)(97 + i)};
                    Text beginRow = new Text(row);
                    Mutation m = new Mutation(beginRow);
                    m.put(new Text(), new Text(), new Value());
                    writer.addMutation(m);
                    Text endRow = new Text(row);
                    endRow.append("\u0000".getBytes(StandardCharsets.UTF_8), 0, 1);
                    ranges.add(new Range(new Text(row), endRow));
                    if (i % 4 != 0) continue;
                    splits.add(beginRow);
                }
                client.tableOperations().addSplits(tableName, splits);
                writer.flush();
            }
            this.log.info("Creating batch scanner");
            try (BatchScanner scanner = client.createBatchScanner(tableName, Authorizations.EMPTY, 1);){
                IteratorSetting cfg = new IteratorSetting(100, YieldingIterator.class);
                scanner.addScanIterator(cfg);
                scanner.setRanges(ranges);
                AtomicInteger keyCount = new AtomicInteger();
                scanner.stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                    this.log.info("{}: Got key '{}' with value '{}'", new Object[]{keyCount, entry.getKey(), entry.getValue()});
                    char expected = (char)(97 + keyCount.get());
                    Assertions.assertEquals((Object)Character.toString(expected), (Object)((Key)entry.getKey()).getRow().toString(), (String)"Unexpected row");
                    keyCount.getAndIncrement();
                });
                Assertions.assertEquals((int)26, (int)keyCount.get(), (String)"Did not get the expected number of results");
            }
        }
    }
}

