/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.util.PropUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ZooKeeperPropertiesIT
extends AccumuloClusterHarness {
    @Test
    public void testNoFiles() {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ZooKeeperPropertiesIT.getClientProps()).build();){
            Assertions.assertThrows(AccumuloException.class, () -> client.instanceOperations().setProperty(Property.GENERAL_RPC_TIMEOUT.getKey(), "60s"));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testTablePropUtils() throws AccumuloException, TableExistsException, AccumuloSecurityException, TableNotFoundException {
        ServerContext context = ZooKeeperPropertiesIT.getServerContext();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ZooKeeperPropertiesIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            Map idMap = client.tableOperations().tableIdMap();
            String tid = (String)idMap.get(tableName);
            Map properties = client.tableOperations().getConfiguration(tableName);
            Assertions.assertEquals((Object)"false", properties.get(Property.TABLE_BLOOM_ENABLED.getKey()));
            TablePropKey tablePropKey = TablePropKey.of((ServerContext)context, (TableId)TableId.of((String)tid));
            PropUtil.setProperties((ServerContext)context, (PropStoreKey)tablePropKey, Map.of(Property.TABLE_BLOOM_ENABLED.getKey(), "true"));
            properties = client.tableOperations().getConfiguration(tableName);
            while (((String)properties.get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("false")) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)"Thread interrupted while waiting for tablePropUtil update");
                }
                properties = client.tableOperations().getConfiguration(tableName);
            }
            PropUtil.removeProperties((ServerContext)context, (PropStoreKey)tablePropKey, List.of(Property.TABLE_BLOOM_ENABLED.getKey()));
            properties = client.tableOperations().getConfiguration(tableName);
            while (((String)properties.get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("true")) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)"Thread interrupted while waiting for tablePropUtil update");
                }
                properties = client.tableOperations().getConfiguration(tableName);
            }
            Assertions.assertThrows(IllegalArgumentException.class, () -> PropUtil.setProperties((ServerContext)context, (PropStoreKey)tablePropKey, Map.of("NOT_A_PROPERTY", "not_a_value")), (String)"Expected IllegalArgumentException to be thrown.");
        }
    }

    @Test
    @Timeout(value=30L)
    public void testNamespacePropUtils() throws AccumuloException, AccumuloSecurityException, NamespaceExistsException, NamespaceNotFoundException {
        ServerContext context = ZooKeeperPropertiesIT.getServerContext();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ZooKeeperPropertiesIT.getClientProps()).build();){
            String namespace = this.getUniqueNames(1)[0];
            client.namespaceOperations().create(namespace);
            Map nsMap = client.namespaceOperations().namespaceIdMap();
            String nid = (String)nsMap.get(namespace);
            Map properties = client.namespaceOperations().getConfiguration(namespace);
            Assertions.assertEquals((Object)"15", properties.get(Property.TABLE_FILE_MAX.getKey()));
            NamespaceId namespaceId = NamespaceId.of((String)nid);
            NamespacePropKey namespacePropKey = NamespacePropKey.of((ServerContext)context, (NamespaceId)namespaceId);
            PropUtil.setProperties((ServerContext)context, (PropStoreKey)namespacePropKey, Map.of(Property.TABLE_FILE_MAX.getKey(), "31"));
            properties = client.namespaceOperations().getConfiguration(namespace);
            while (!((String)properties.get(Property.TABLE_FILE_MAX.getKey())).equals("31")) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)"Thread interrupted while waiting for namespacePropUtil update");
                }
                properties = client.namespaceOperations().getConfiguration(namespace);
            }
            PropUtil.removeProperties((ServerContext)context, (PropStoreKey)namespacePropKey, List.of(Property.TABLE_FILE_MAX.getKey()));
            properties = client.namespaceOperations().getConfiguration(namespace);
            while (!((String)properties.get(Property.TABLE_FILE_MAX.getKey())).equals("15")) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)"Thread interrupted while waiting for namespacePropUtil update");
                }
                properties = client.namespaceOperations().getConfiguration(namespace);
            }
            Assertions.assertThrows(IllegalArgumentException.class, () -> PropUtil.setProperties((ServerContext)context, (PropStoreKey)namespacePropKey, Map.of("NOT_A_PROPERTY", "not_a_value")), (String)"Expected IllegalArgumentException to be thrown.");
        }
    }
}

