/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import com.google.common.collect.MoreCollectors;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.spi.compaction.DefaultCompactionPlanner;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BadCompactionServiceConfigIT
extends AccumuloClusterHarness {
    private static final String CSP = Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey();
    private ExecutorService executorService;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        HashMap<CallSite, String> siteCfg = new HashMap<CallSite, String>();
        siteCfg.put((CallSite)((Object)(CSP + "cs1.planner")), DefaultCompactionPlanner.class.getName());
        siteCfg.put((CallSite)((Object)(CSP + "cs1.planner.opts.executors")), "{{'name]");
        cfg.setSiteConfig(siteCfg);
    }

    @BeforeEach
    public void setup() {
        this.executorService = Executors.newCachedThreadPool();
    }

    @AfterEach
    public void teardown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testUsingMisconfiguredService() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BadCompactionServiceConfigIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration().setProperties(Map.of(Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service", "cs1"));
            client.tableOperations().create(table, ntc);
            try (BatchWriter writer = client.createBatchWriter(table);){
                writer.addMutation(new Mutation((CharSequence)"0").at().family((CharSequence)"f").qualifier((CharSequence)"q").put((CharSequence)"v"));
            }
            client.tableOperations().flush(table, null, null, true);
            try (Scanner scanner = client.createScanner(table);){
                Assertions.assertEquals((Object)"0", scanner.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).collect(MoreCollectors.onlyElement()));
            }
            Future<?> fixerFuture = this.executorService.submit(() -> {
                try {
                    Thread.sleep(2000L);
                    try (Scanner scanner = client.createScanner(table);){
                        Assertions.assertEquals((Object)"0", scanner.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).collect(MoreCollectors.onlyElement()));
                    }
                    String value = "[{'name':'small', 'type': 'internal', 'numThreads':1}]".replaceAll("'", "\"");
                    client.instanceOperations().setProperty(CSP + "cs1.planner.opts.executors", value);
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            });
            List<IteratorSetting> iterators = Collections.singletonList(new IteratorSetting(100, EverythingFilter.class));
            client.tableOperations().compact(table, new CompactionConfig().setIterators(iterators).setWait(true));
            try (Scanner scanner = client.createScanner(table);){
                Assertions.assertEquals((long)0L, (long)scanner.stream().count());
            }
            fixerFuture.get();
            client.instanceOperations().setProperty(CSP + "cs1.planner.opts.executors", "]o.o[");
            try (BatchWriter writer = client.createBatchWriter(table);){
                writer.addMutation(new Mutation((CharSequence)"0").at().family((CharSequence)"f").qualifier((CharSequence)"q").put((CharSequence)"v"));
            }
            client.tableOperations().flush(table, null, null, true);
            scanner = client.createScanner(table);
            try {
                Assertions.assertEquals((Object)"0", scanner.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).collect(MoreCollectors.onlyElement()));
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
            fixerFuture = this.executorService.submit(() -> {
                try {
                    Thread.sleep(2000L);
                    String value = "[{'name':'small', 'type': 'internal', 'numThreads':1}]".replaceAll("'", "\"");
                    client.instanceOperations().setProperty(CSP + "cs1.planner.opts.executors", value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            client.tableOperations().compact(table, new CompactionConfig().setIterators(iterators).setWait(true));
            scanner = client.createScanner(table);
            try {
                Assertions.assertEquals((long)0L, (long)scanner.stream().count());
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
            fixerFuture.get();
        }
    }

    @Test
    public void testUsingNonExistentService() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BadCompactionServiceConfigIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration().setProperties(Map.of(Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service", "cs5"));
            client.tableOperations().create(table, ntc);
            TreeSet splits = IntStream.range(1, 10).mapToObj(i -> new Text("" + i)).collect(Collectors.toCollection(TreeSet::new));
            client.tableOperations().addSplits(table, (SortedSet)splits);
            try (BatchWriter writer = client.createBatchWriter(table);){
                writer.addMutation(new Mutation((CharSequence)"0").at().family((CharSequence)"f").qualifier((CharSequence)"q").put((CharSequence)"v"));
            }
            client.tableOperations().flush(table, null, null, true);
            try (Scanner scanner = client.createScanner(table);){
                Assertions.assertEquals((Object)"0", scanner.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).collect(MoreCollectors.onlyElement()));
            }
            Future<?> fixerFuture = this.executorService.submit(() -> {
                try {
                    Thread.sleep(2000L);
                    try (Scanner scanner = client.createScanner(table);){
                        Assertions.assertEquals((Object)"0", scanner.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).collect(MoreCollectors.onlyElement()));
                    }
                    client.tableOperations().setProperty(table, Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service", "default");
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            });
            List<IteratorSetting> iterators = Collections.singletonList(new IteratorSetting(100, EverythingFilter.class));
            client.tableOperations().compact(table, new CompactionConfig().setIterators(iterators).setWait(true));
            try (Scanner scanner = client.createScanner(table);){
                Assertions.assertEquals((long)0L, (long)scanner.stream().count());
            }
            fixerFuture.get();
        }
    }

    public static class EverythingFilter
    extends Filter {
        public boolean accept(Key k, Value v) {
            return false;
        }
    }
}

