/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.util.List;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.spi.compaction.DefaultCompactionPlanner;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.compaction.ExternalCompactionTestUtils;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.accumulo.test.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompactionConfigChangeIT
extends AccumuloClusterHarness {
    public static long countFiles(AccumuloClient client, String table, String fileNamePrefix) throws Exception {
        ClientContext ctx = (ClientContext)client;
        TableId tableId = ctx.getTableId(table);
        try (TabletsMetadata tablets = ctx.getAmple().readTablets().forTable(tableId).build();){
            long l = tablets.stream().flatMap(tm -> tm.getFiles().stream()).filter(stf -> stf.getFileName().startsWith(fileNamePrefix)).count();
            return l;
        }
    }

    @Test
    public void testRemovingCompactionExecutor() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionConfigChangeIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "cs1.planner", DefaultCompactionPlanner.class.getName());
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "cs1.planner.opts.executors", "[{'name':'small','type':'internal','maxSize':'2M','numThreads':2},{'name':'medium','type':'internal','maxSize':'128M','numThreads':2},{'name':'large','type':'internal','numThreads':2}]".replaceAll("'", "\""));
            ExternalCompactionTestUtils.createTable(client, table, "cs1", 100);
            ExternalCompactionTestUtils.writeData(client, table, 1000);
            client.tableOperations().flush(table, null, null, true);
            Assertions.assertEquals((long)100L, (long)CompactionConfigChangeIT.countFiles(client, table, "F"));
            CompactionConfig compactionConfig = new CompactionConfig();
            IteratorSetting iteratorSetting = new IteratorSetting(100, SlowIterator.class);
            SlowIterator.setSleepTime(iteratorSetting, 100L);
            compactionConfig.setIterators(List.of(iteratorSetting));
            compactionConfig.setWait(false);
            client.tableOperations().compact(table, compactionConfig);
            Wait.waitFor(() -> CompactionConfigChangeIT.countFiles(client, table, "F") < 95L);
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "cs1.planner.opts.executors", "[{'name':'little','type':'internal','maxSize':'128M','numThreads':8},{'name':'big','type':'internal','numThreads':2}]".replaceAll("'", "\""));
            Wait.waitFor(() -> CompactionConfigChangeIT.countFiles(client, table, "F") == 0L, 60000L);
            ExternalCompactionTestUtils.verify(client, table, 1);
        }
    }
}

