/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.PluginConfig;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.client.admin.compaction.CompressionConfigurer;
import org.apache.accumulo.core.client.admin.compaction.TooManyDeletesSelector;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.summarizers.DeletesSummarizer;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.spi.compaction.CompactionPlan;
import org.apache.accumulo.core.spi.compaction.CompactionPlanner;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CompactionExecutorIT
extends SharedMiniClusterBase {
    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig((miniCfg, coreSite) -> {
            HashMap<CallSite, String> siteCfg = new HashMap<CallSite, String>();
            String csp = Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey();
            siteCfg.put((CallSite)((Object)(csp + "cs1.planner")), TestPlanner.class.getName());
            siteCfg.put((CallSite)((Object)(csp + "cs1.planner.opts.executors")), "3");
            siteCfg.put((CallSite)((Object)(csp + "cs1.planner.opts.filesPerCompaction")), "5");
            siteCfg.put((CallSite)((Object)(csp + "cs1.planner.opts.process")), "SYSTEM");
            siteCfg.put((CallSite)((Object)(csp + "cs2.planner")), TestPlanner.class.getName());
            siteCfg.put((CallSite)((Object)(csp + "cs2.planner.opts.executors")), "2");
            siteCfg.put((CallSite)((Object)(csp + "cs2.planner.opts.filesPerCompaction")), "7");
            siteCfg.put((CallSite)((Object)(csp + "cs2.planner.opts.process")), "SYSTEM");
            siteCfg.put((CallSite)((Object)(csp + "cs3.planner")), TestPlanner.class.getName());
            siteCfg.put((CallSite)((Object)(csp + "cs3.planner.opts.executors")), "1");
            siteCfg.put((CallSite)((Object)(csp + "cs3.planner.opts.filesPerCompaction")), "3");
            siteCfg.put((CallSite)((Object)(csp + "cs3.planner.opts.process")), "USER");
            siteCfg.put((CallSite)((Object)(csp + "cs4.planner")), TestPlanner.class.getName());
            siteCfg.put((CallSite)((Object)(csp + "cs4.planner.opts.executors")), "2");
            siteCfg.put((CallSite)((Object)(csp + "cs4.planner.opts.filesPerCompaction")), "11");
            siteCfg.put((CallSite)((Object)(csp + "cs4.planner.opts.process")), "USER");
            siteCfg.put((CallSite)((Object)(csp + "recfg.planner")), TestPlanner.class.getName());
            siteCfg.put((CallSite)((Object)(csp + "recfg.planner.opts.executors")), "2");
            siteCfg.put((CallSite)((Object)(csp + "recfg.planner.opts.filesPerCompaction")), "11");
            siteCfg.put((CallSite)((Object)(csp + "recfg.planner.opts.process")), "SYSTEM");
            miniCfg.setSiteConfig(siteCfg);
        });
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @AfterEach
    public void cleanup() {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            client.tableOperations().list().stream().filter(tableName -> !tableName.startsWith("accumulo.")).forEach(tableName -> {
                try {
                    client.tableOperations().delete(tableName);
                }
                catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Test
    public void testReconfigureCompactionService() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            this.createTable(client, "rctt", "recfg");
            this.addFiles(client, "rctt", 22);
            while (this.getFiles(client, "rctt").size() > 2) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "rctt").size());
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "recfg.planner.opts.filesPerCompaction", "5");
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "recfg.planner.opts.executors", "1");
            this.addFiles(client, "rctt", 10);
            while (this.getFiles(client, "rctt").size() > 4) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)4, (int)this.getFiles(client, "rctt").size());
        }
    }

    @Test
    public void testAddCompactionService() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "newcs.planner.opts.filesPerCompaction", "7");
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "newcs.planner.opts.process", "SYSTEM");
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "newcs.planner.opts.executors", "3");
            client.instanceOperations().setProperty(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey() + "newcs.planner", TestPlanner.class.getName());
            this.createTable(client, "acst", "newcs");
            this.addFiles(client, "acst", 42);
            while (this.getFiles(client, "acst").size() > 6) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)6, (int)this.getFiles(client, "acst").size());
        }
    }

    @Test
    public void testDispatchSystem() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            this.createTable(client, "dst1", "cs1");
            this.createTable(client, "dst2", "cs2");
            this.addFiles(client, "dst1", 14);
            this.addFiles(client, "dst2", 13);
            Assertions.assertTrue((this.getFiles(client, "dst1").size() >= 6 ? 1 : 0) != 0);
            Assertions.assertTrue((this.getFiles(client, "dst2").size() >= 7 ? 1 : 0) != 0);
            this.addFiles(client, "dst1", 1);
            this.addFiles(client, "dst2", 1);
            while (this.getFiles(client, "dst1").size() > 3 || this.getFiles(client, "dst2").size() > 2) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)3, (int)this.getFiles(client, "dst1").size());
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "dst2").size());
        }
    }

    @Test
    public void testDispatchUser() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            this.createTable(client, "dut1", "cs3");
            this.createTable(client, "dut2", "cs3", "special", "cs4");
            this.addFiles(client, "dut1", 6);
            this.addFiles(client, "dut2", 33);
            Assertions.assertEquals((int)6, (int)this.getFiles(client, "dut1").size());
            Assertions.assertEquals((int)33, (int)this.getFiles(client, "dut2").size());
            client.tableOperations().compact("dut1", new CompactionConfig().setWait(false));
            client.tableOperations().compact("dut2", new CompactionConfig().setWait(false).setExecutionHints(Map.of("compaction_type", "special")));
            while (this.getFiles(client, "dut1").size() > 2 || this.getFiles(client, "dut2").size() > 3) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "dut1").size());
            Assertions.assertEquals((int)3, (int)this.getFiles(client, "dut2").size());
            client.tableOperations().cancelCompaction("dut1");
            client.tableOperations().cancelCompaction("dut2");
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "dut1").size());
            Assertions.assertEquals((int)3, (int)this.getFiles(client, "dut2").size());
            client.tableOperations().compact("dut1", new CompactionConfig().setWait(true).setExecutionHints(Map.of("compact_all", "true")));
            client.tableOperations().compact("dut2", new CompactionConfig().setWait(true).setExecutionHints(Map.of("compact_all", "true")));
            Assertions.assertEquals((int)1, (int)this.getFiles(client, "dut1").size());
            Assertions.assertEquals((int)1, (int)this.getFiles(client, "dut2").size());
        }
    }

    @Test
    public void testTooManyDeletes() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            Map<CallSite, String> props = Map.of(Property.TABLE_COMPACTION_SELECTOR.getKey(), TooManyDeletesSelector.class.getName(), Property.TABLE_COMPACTION_SELECTOR_OPTS.getKey() + "threshold", ".4");
            SummarizerConfiguration deleteSummarizerCfg = SummarizerConfiguration.builder((String)DeletesSummarizer.class.getName()).build();
            client.tableOperations().create("tmd_selector", new NewTableConfiguration().setProperties(props).enableSummarization(new SummarizerConfiguration[]{deleteSummarizerCfg}));
            client.tableOperations().create("tmd_control1", new NewTableConfiguration().enableSummarization(new SummarizerConfiguration[]{deleteSummarizerCfg}));
            client.tableOperations().create("tmd_control2", new NewTableConfiguration().enableSummarization(new SummarizerConfiguration[]{deleteSummarizerCfg}));
            client.tableOperations().create("tmd_control3", new NewTableConfiguration().enableSummarization(new SummarizerConfiguration[]{deleteSummarizerCfg}));
            this.addFile(client, "tmd_selector", 1, 1000, false);
            this.addFile(client, "tmd_selector", 1, 1000, true);
            this.addFile(client, "tmd_control1", 1, 1000, false);
            this.addFile(client, "tmd_control1", 1, 1000, true);
            this.addFile(client, "tmd_control2", 1, 1000, false);
            this.addFile(client, "tmd_control2", 1000, 2000, false);
            this.addFile(client, "tmd_control3", 1, 2000, false);
            this.addFile(client, "tmd_control3", 1, 1000, true);
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control1").size());
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control2").size());
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control3").size());
            while (this.getFiles(client, "tmd_selector").size() != 0) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control1").size());
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control2").size());
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control3").size());
            CompactionConfig cc1 = new CompactionConfig().setSelector(new PluginConfig(TooManyDeletesSelector.class.getName(), Map.of("threshold", ".99"))).setWait(true);
            client.tableOperations().compact("tmd_control1", cc1);
            client.tableOperations().compact("tmd_control2", cc1);
            client.tableOperations().compact("tmd_control3", cc1);
            Assertions.assertEquals((int)0, (int)this.getFiles(client, "tmd_control1").size());
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control2").size());
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control3").size());
            CompactionConfig cc2 = new CompactionConfig().setSelector(new PluginConfig(TooManyDeletesSelector.class.getName(), Map.of("threshold", ".40"))).setWait(true);
            client.tableOperations().compact("tmd_control1", cc2);
            client.tableOperations().compact("tmd_control2", cc2);
            client.tableOperations().compact("tmd_control3", cc2);
            Assertions.assertEquals((int)0, (int)this.getFiles(client, "tmd_control1").size());
            Assertions.assertEquals((int)2, (int)this.getFiles(client, "tmd_control2").size());
            Assertions.assertEquals((int)1, (int)this.getFiles(client, "tmd_control3").size());
            client.tableOperations().compact("tmd_control2", new CompactionConfig().setWait(true));
            Assertions.assertEquals((int)1, (int)this.getFiles(client, "tmd_control2").size());
        }
    }

    @Test
    public void testIteratorsWithRange() throws Exception {
        String tableName = "tiwr";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            TreeSet<Text> splits = new TreeSet<Text>();
            for (String s : List.of("f", "m", "r", "t")) {
                splits.add(new Text(s));
            }
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(splits);
            client.tableOperations().create(tableName, ntc);
            TreeMap<CallSite, CallSite> expected = new TreeMap<CallSite, CallSite>();
            try (BatchWriter writer = client.createBatchWriter(tableName);){
                int v = 0;
                for (String row : List.of("a", "h", "o", "s", "x")) {
                    Mutation m = new Mutation((CharSequence)row);
                    for (int q = 0; q < 10; ++q) {
                        String qual = String.format("%03d", q);
                        String val = "v" + v++;
                        m.at().family((CharSequence)"f").qualifier((CharSequence)qual).put((CharSequence)val);
                        expected.put((CallSite)((Object)(row + ":f:" + qual)), (CallSite)((Object)val));
                    }
                    writer.addMutation(m);
                }
            }
            IteratorSetting iterSetting = new IteratorSetting(20, "rf", RegExFilter.class.getName());
            RegExFilter.setRegexs((IteratorSetting)iterSetting, null, null, (String)"004|007", null, (boolean)false);
            RegExFilter.setNegate((IteratorSetting)iterSetting, (boolean)true);
            client.tableOperations().compact(tableName, new CompactionConfig().setStartRow(new Text("b")).setEndRow(new Text("m")).setIterators(List.of(iterSetting)).setWait(true).setFlush(true));
            for (String string : List.of("a", "h")) {
                Assertions.assertNotNull(expected.remove(string + ":f:004"));
                Assertions.assertNotNull(expected.remove(string + ":f:007"));
            }
            Map<String, String> actual = this.scanTable(client, tableName);
            Assertions.assertEquals(expected, actual);
            iterSetting = new IteratorSetting(20, "rf", RegExFilter.class.getName());
            RegExFilter.setRegexs((IteratorSetting)iterSetting, null, null, (String)"002|005|009", null, (boolean)false);
            RegExFilter.setNegate((IteratorSetting)iterSetting, (boolean)true);
            client.tableOperations().compact(tableName, new CompactionConfig().setStartRow(new Text("m")).setEndRow(new Text("u")).setIterators(List.of(iterSetting)).setWait(true));
            for (String row : List.of("o", "s", "x")) {
                Assertions.assertNotNull(expected.remove(row + ":f:002"));
                Assertions.assertNotNull(expected.remove(row + ":f:005"));
                Assertions.assertNotNull(expected.remove(row + ":f:009"));
            }
            actual = this.scanTable(client, tableName);
            Assertions.assertEquals(expected, actual);
            iterSetting = new IteratorSetting(20, "rf", RegExFilter.class.getName());
            RegExFilter.setRegexs((IteratorSetting)iterSetting, null, null, (String)"00[18]", null, (boolean)false);
            RegExFilter.setNegate((IteratorSetting)iterSetting, (boolean)true);
            client.tableOperations().compact(tableName, new CompactionConfig().setIterators(List.of(iterSetting)).setWait(true));
            for (String row : List.of("a", "h", "o", "s", "x")) {
                Assertions.assertNotNull(expected.remove(row + ":f:001"));
                Assertions.assertNotNull(expected.remove(row + ":f:008"));
            }
            actual = this.scanTable(client, tableName);
            Assertions.assertEquals(expected, actual);
            try (BatchWriter batchWriter = client.createBatchWriter(tableName);){
                int v = 1000;
                for (String row : List.of("a", "h", "o", "s", "x")) {
                    Mutation m = new Mutation((CharSequence)row);
                    for (int q = 0; q < 10; ++q) {
                        String qual = String.format("%03d", q);
                        String val = "v" + v++;
                        m.at().family((CharSequence)"f").qualifier((CharSequence)qual).put((CharSequence)val);
                        expected.put((CallSite)((Object)(row + ":f:" + qual)), (CallSite)((Object)val));
                    }
                    batchWriter.addMutation(m);
                }
            }
            client.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setFlush(true));
            actual = this.scanTable(client, tableName);
            Assertions.assertEquals(expected, actual);
        }
    }

    @Test
    public void testConfigurer() throws Exception {
        String tableName = "tcc";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration().setProperties(Map.of(Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none"));
            client.tableOperations().create(tableName, ntc);
            byte[] data = new byte[100000];
            Arrays.fill(data, (byte)65);
            try (BatchWriter writer = client.createBatchWriter(tableName);){
                for (int row = 0; row < 10; ++row) {
                    Mutation m = new Mutation((CharSequence)("" + row));
                    m.at().family((CharSequence)"big").qualifier((CharSequence)"stuff").put(data);
                    writer.addMutation(m);
                }
            }
            client.tableOperations().flush(tableName, null, null, true);
            long sizes = CompactionExecutorIT.getFileSizes(client, tableName);
            Assertions.assertTrue((sizes > (long)(data.length * 10) && sizes < (long)(data.length * 11) ? 1 : 0) != 0, (String)("Unexpected files sizes : " + sizes));
            client.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setConfigurer(new PluginConfig(CompressionConfigurer.class.getName(), Map.of("large.compress.type", "gz", "large.compress.threshold", "" + data.length))));
            sizes = CompactionExecutorIT.getFileSizes(client, tableName);
            Assertions.assertTrue((sizes < (long)data.length ? 1 : 0) != 0, (String)("Unexpected files sizes : " + sizes));
            client.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            sizes = CompactionExecutorIT.getFileSizes(client, tableName);
            Assertions.assertTrue((sizes > (long)(data.length * 10) && sizes < (long)(data.length * 11) ? 1 : 0) != 0, (String)("Unexpected files sizes : " + sizes));
        }
    }

    public static long getFileSizes(AccumuloClient client, String tableName) {
        TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(tableName)));
        try (TabletsMetadata tabletsMeta = TabletsMetadata.builder((AccumuloClient)client).forTable(tableId).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES}).build();){
            long l = tabletsMeta.stream().flatMap(tm -> tm.getFiles().stream()).mapToLong(stf -> {
                try {
                    return FileSystem.getLocal((Configuration)new Configuration()).getFileStatus(stf.getPath()).getLen();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).sum();
            return l;
        }
    }

    @Test
    public void testIncorrectSelectorType() throws Exception {
        String tableName = "tist";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            this.addFiles(client, tableName, 5);
            AccumuloException e = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> client.tableOperations().compact(tableName, new CompactionConfig().setSelector(new PluginConfig(CompressionConfigurer.class.getName())).setWait(true)));
            String msg = e.getMessage();
            Assertions.assertTrue((boolean)msg.contains("TabletServer could not load CompactionSelector"), (String)("Unexpected message : " + msg));
        }
    }

    @Test
    public void testIncorrectConfigurerType() throws Exception {
        String tableName = "tict";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CompactionExecutorIT.getClientProps()).build();){
            client.tableOperations().create(tableName);
            this.addFiles(client, tableName, 5);
            AccumuloException e = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> client.tableOperations().compact(tableName, new CompactionConfig().setConfigurer(new PluginConfig(TooManyDeletesSelector.class.getName())).setWait(true)));
            String msg = e.getMessage();
            Assertions.assertTrue((boolean)msg.contains("TabletServer could not load CompactionConfigurer"), (String)("Unexpected message : " + msg));
        }
    }

    private Map<String, String> scanTable(AccumuloClient client, String tableName) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        TreeMap<String, String> actual = new TreeMap<String, String>();
        try (Scanner scanner = client.createScanner(tableName);){
            for (Map.Entry e : scanner) {
                Key k = (Key)e.getKey();
                actual.put(k.getRowData() + ":" + k.getColumnFamilyData() + ":" + k.getColumnQualifierData(), ((Value)e.getValue()).toString());
            }
        }
        return actual;
    }

    private Set<String> getFiles(AccumuloClient client, String name) {
        TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(name)));
        try (TabletsMetadata tabletsMeta = TabletsMetadata.builder((AccumuloClient)client).forTable(tableId).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES}).build();){
            Set<String> set = tabletsMeta.stream().flatMap(tm -> tm.getFiles().stream()).map(TabletFile::getFileName).collect(Collectors.toSet());
            return set;
        }
    }

    private void addFile(AccumuloClient client, String table, int startRow, int endRow, boolean delete) throws Exception {
        try (BatchWriter writer = client.createBatchWriter(table);){
            for (int i = startRow; i < endRow; ++i) {
                Mutation mut = new Mutation((CharSequence)String.format("%09d", i));
                if (delete) {
                    mut.putDelete((CharSequence)"f1", (CharSequence)"q1");
                } else {
                    mut.put((CharSequence)"f1", (CharSequence)"q1", (CharSequence)("v" + i));
                }
                writer.addMutation(mut);
            }
        }
        client.tableOperations().flush(table, null, null, true);
    }

    private void addFiles(AccumuloClient client, String table, int num) throws Exception {
        try (BatchWriter writer = client.createBatchWriter(table);){
            for (int i = 0; i < num; ++i) {
                Mutation mut = new Mutation((CharSequence)("r" + i));
                mut.put((CharSequence)"f1", (CharSequence)"q1", (CharSequence)("v" + i));
                writer.addMutation(mut);
                writer.flush();
                client.tableOperations().flush(table, null, null, true);
            }
        }
    }

    private void createTable(AccumuloClient client, String name, String compactionService) throws Exception {
        NewTableConfiguration ntc = new NewTableConfiguration().setProperties(Map.of(Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service", compactionService));
        client.tableOperations().create(name, ntc);
    }

    private void createTable(AccumuloClient client, String name, String compactionService, String userType, String userService) throws Exception {
        String tcdo = Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey();
        NewTableConfiguration ntc = new NewTableConfiguration().setProperties(Map.of(tcdo + "service", compactionService, tcdo + "service.user." + userType, userService, Property.TABLE_MAJC_RATIO.getKey(), "100"));
        client.tableOperations().create(name, ntc);
    }

    public static class TestPlanner
    implements CompactionPlanner {
        private int filesPerCompaction;
        private List<CompactionExecutorId> executorIds;
        private EnumSet<CompactionKind> kindsToProcess = EnumSet.noneOf(CompactionKind.class);

        public void init(CompactionPlanner.InitParameters params) {
            int executors = Integer.parseInt((String)params.getOptions().get("executors"));
            this.filesPerCompaction = Integer.parseInt((String)params.getOptions().get("filesPerCompaction"));
            this.executorIds = new ArrayList<CompactionExecutorId>();
            for (String kind : ((String)params.getOptions().get("process")).split(",")) {
                this.kindsToProcess.add(CompactionKind.valueOf((String)kind.toUpperCase()));
            }
            for (int i = 0; i < executors; ++i) {
                CompactionExecutorId ceid = params.getExecutorManager().createExecutor("e" + i, 2);
                this.executorIds.add(ceid);
            }
        }

        static String getFirstChar(CompactableFile cf) {
            return cf.getFileName().substring(0, 1);
        }

        public CompactionPlan makePlan(CompactionPlanner.PlanningParameters params) {
            if (Boolean.parseBoolean(params.getExecutionHints().getOrDefault("compact_all", "false"))) {
                return params.createPlanBuilder().addJob((short)1, this.executorIds.get(AccumuloITBase.random.nextInt(this.executorIds.size())), params.getCandidates()).build();
            }
            if (this.kindsToProcess.contains(params.getKind())) {
                CompactionPlan.Builder planBuilder = params.createPlanBuilder();
                params.getCandidates().stream().collect(Collectors.groupingBy(TestPlanner::getFirstChar)).values().forEach(files -> {
                    for (int i = this.filesPerCompaction; i <= files.size(); i += this.filesPerCompaction) {
                        planBuilder.addJob((short)1, this.executorIds.get(AccumuloITBase.random.nextInt(this.executorIds.size())), files.subList(i - this.filesPerCompaction, i));
                    }
                });
                return planBuilder.build();
            }
            return params.createPlanBuilder().build();
        }
    }
}

