/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.util.Map;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.spi.compaction.DefaultCompactionPlanner;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompactionRateLimitingIT
extends ConfigurableMacBase {
    public static final long BYTES_TO_WRITE = 0xA00000L;
    public static final long RATE = 0x100000L;

    protected Property getThroughputProp() {
        return Property.TSERV_COMPACTION_SERVICE_DEFAULT_RATE_LIMIT;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration fsConf) {
        cfg.setProperty(this.getThroughputProp(), "1048576B");
        cfg.setProperty(Property.TABLE_MAJC_RATIO, "20");
        cfg.setProperty(Property.TABLE_FILE_COMPRESSION_TYPE, "none");
        cfg.setProperty("tserver.compaction.major.service.test.rate.limit", "1048576B");
        cfg.setProperty("tserver.compaction.major.service.test.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.test.planner.opts.executors", "[{'name':'all','numThreads':2}]".replaceAll("'", "\""));
    }

    @Test
    public void majorCompactionsAreRateLimited() throws Exception {
        long bytesWritten = 0L;
        String[] tableNames = this.getUniqueNames(1);
        try (AccumuloClient client = this.getCluster().createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));){
            for (int i = 0; i < tableNames.length; ++i) {
                String tableName = tableNames[i];
                NewTableConfiguration ntc = new NewTableConfiguration();
                if (i == 1) {
                    ntc.setProperties(Map.of("table.compaction.dispatcher.opts.service", "test"));
                }
                client.tableOperations().create(tableName, ntc);
                try (BatchWriter bw = client.createBatchWriter(tableName);){
                    while (bytesWritten < 0xA00000L) {
                        byte[] rowKey = new byte[32];
                        random.nextBytes(rowKey);
                        byte[] qual = new byte[32];
                        random.nextBytes(qual);
                        byte[] value = new byte[1024];
                        random.nextBytes(value);
                        Mutation m = new Mutation(rowKey);
                        m.put(new byte[0], qual, value);
                        bw.addMutation(m);
                        bytesWritten += (long)(rowKey.length + qual.length + value.length);
                    }
                }
                client.tableOperations().flush(tableName, null, null, true);
                long compactionStart = System.currentTimeMillis();
                client.tableOperations().compact(tableName, null, null, false, true);
                long duration = System.currentTimeMillis() - compactionStart;
                String message = String.format("Expected a compaction rate of no more than %,d bytes/sec, but saw a rate of %,f bytes/sec", 838860, 1000.0 * (double)bytesWritten / (double)duration);
                Assertions.assertTrue(((double)duration > 8000.0 ? 1 : 0) != 0, (String)message);
            }
        }
    }
}

