/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.compaction.WriteParameters;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurableMajorCompactionIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(30L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        HashMap<String, String> siteConfig = new HashMap<String, String>();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "1s");
        cfg.setSiteConfig(siteConfig);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            client.tableOperations().setProperty(tableName, Property.TABLE_COMPACTION_STRATEGY.getKey(), TestCompactionStrategy.class.getName());
            this.writeFile(client, tableName);
            this.writeFile(client, tableName);
            this.writeFile(client, tableName);
            this.writeFile(client, tableName);
            UtilWaitThread.sleep((long)2000L);
            Assertions.assertEquals((int)4, (int)this.countFiles(client));
            this.writeFile(client, tableName);
            int count = this.countFiles(client);
            Assertions.assertTrue((count == 1 || count == 5 ? 1 : 0) != 0);
            while (count != 1) {
                UtilWaitThread.sleep((long)250L);
                count = this.countFiles(client);
            }
        }
    }

    private int countFiles(AccumuloClient client) throws Exception {
        try (Scanner s = client.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            s.setRange(MetadataSchema.TabletsSection.getRange());
            s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            int n = Iterators.size((Iterator)s.iterator());
            return n;
        }
    }

    private void writeFile(AccumuloClient client, String tableName) throws Exception {
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            Mutation m = new Mutation((CharSequence)"row");
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
            bw.addMutation(m);
        }
        client.tableOperations().flush(tableName, null, null, true);
    }

    public static class TestCompactionStrategy
    extends CompactionStrategy {
        public boolean shouldCompact(MajorCompactionRequest request) {
            return request.getFiles().size() == 5;
        }

        public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
            CompactionPlan plan = new CompactionPlan();
            plan.inputFiles.addAll(request.getFiles().keySet());
            plan.writeParameters = new WriteParameters();
            plan.writeParameters.setBlockSize(0x100000L);
            plan.writeParameters.setCompressType("none");
            plan.writeParameters.setHdfsBlockSize(0x100000L);
            plan.writeParameters.setIndexBlockSize(10L);
            plan.writeParameters.setReplication(7);
            return plan;
        }
    }
}

