/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.util.EnumSet;
import java.util.NoSuchElementException;
import org.apache.accumulo.compactor.Compactor;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.user.AgeOffFilter;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.compaction.ExternalCompactionTestUtils;
import org.apache.accumulo.test.functional.ErrorThrowingIterator;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExternalCompaction4_IT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        ExternalCompactionTestUtils.configureMiniCluster(cfg, coreSite);
        cfg.setNumCompactors(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorDuringCompactionNoOutput() throws Exception {
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction4_IT.getClientProps()).build();){
            ExternalCompaction4_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            ExternalCompaction4_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ1");
            ExternalCompactionTestUtils.createTable(client, table1, "cs1");
            client.tableOperations().setProperty(table1, Property.TABLE_FILE_MAX.getKey(), "51");
            client.tableOperations().setProperty(table1, Property.TABLE_MAJC_RATIO.getKey(), "51");
            TableId tid = TableId.of((String)((String)client.tableOperations().tableIdMap().get(table1)));
            ReadWriteIT.ingest(client, 50, 1, 1, 0, "colf", table1, 1);
            ReadWriteIT.verify(client, 50, 1, 1, 0, table1);
            Ample ample = ((ClientContext)client).getAmple();
            try (TabletsMetadata tms = ample.readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES}).build();){
                TabletMetadata tm = (TabletMetadata)tms.iterator().next();
                Assertions.assertEquals((int)50, (int)tm.getFiles().size());
            }
            IteratorSetting setting = new IteratorSetting(50, "ageoff", AgeOffFilter.class);
            setting.addOption("ttl", "0");
            setting.addOption("currentTime", Long.toString(System.currentTimeMillis() + 86400L));
            client.tableOperations().attachIterator(table1, setting, EnumSet.of(IteratorUtil.IteratorScope.majc));
            IteratorSetting setting2 = new IteratorSetting(51, "error", ErrorThrowingIterator.class);
            setting2.addOption("error.throwing.iterator.times", "3");
            client.tableOperations().attachIterator(table1, setting2, EnumSet.of(IteratorUtil.IteratorScope.majc));
            client.tableOperations().compact(table1, new CompactionConfig().setWait(true));
            try (TabletsMetadata tm = ample.readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES}).build();){
                Assertions.assertThrows(NoSuchElementException.class, () -> tm.iterator().next());
            }
            Assertions.assertEquals((long)0L, (long)client.createScanner(table1).stream().count());
        }
        finally {
            ExternalCompaction4_IT.getCluster().getClusterControl().stopAllServers(ServerType.COMPACTOR);
            ExternalCompaction4_IT.getCluster().getClusterControl().stopAllServers(ServerType.COMPACTION_COORDINATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorDuringUserCompaction() throws Exception {
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction4_IT.getClientProps()).build();){
            ExternalCompaction4_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            ExternalCompaction4_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ1");
            ExternalCompactionTestUtils.createTable(client, table1, "cs1");
            client.tableOperations().setProperty(table1, Property.TABLE_FILE_MAX.getKey(), "1001");
            client.tableOperations().setProperty(table1, Property.TABLE_MAJC_RATIO.getKey(), "1001");
            TableId tid = TableId.of((String)((String)client.tableOperations().tableIdMap().get(table1)));
            ReadWriteIT.ingest(client, 1000, 1, 1, 0, "colf", table1, 1);
            Ample ample = ((ClientContext)client).getAmple();
            try (TabletsMetadata tms = ample.readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES}).build();){
                TabletMetadata tm = (TabletMetadata)tms.iterator().next();
                Assertions.assertEquals((int)1000, (int)tm.getFiles().size());
            }
            IteratorSetting setting = new IteratorSetting(50, "error", ErrorThrowingIterator.class);
            setting.addOption("error.throwing.iterator.times", "3");
            client.tableOperations().attachIterator(table1, setting, EnumSet.of(IteratorUtil.IteratorScope.majc));
            client.tableOperations().compact(table1, new CompactionConfig().setWait(true));
            try (TabletsMetadata tms = ample.readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES}).build();){
                TabletMetadata tm = (TabletMetadata)tms.iterator().next();
                Assertions.assertEquals((int)1, (int)tm.getFiles().size());
            }
            ReadWriteIT.verify(client, 1000, 1, 1, 0, table1);
        }
        finally {
            ExternalCompaction4_IT.getCluster().getClusterControl().stopAllServers(ServerType.COMPACTOR);
            ExternalCompaction4_IT.getCluster().getClusterControl().stopAllServers(ServerType.COMPACTION_COORDINATOR);
        }
    }
}

