/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.compactor.Compactor;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.compaction.ExternalCompactionTestUtils;
import org.apache.accumulo.test.metrics.TestStatsDRegistryFactory;
import org.apache.accumulo.test.metrics.TestStatsDSink;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ExternalCompactionMetricsIT
extends SharedMiniClusterBase {
    private static TestStatsDSink sink;

    @BeforeAll
    public static void before() throws Exception {
        sink = new TestStatsDSink();
        ExternalCompactionMetricsIT.startMiniClusterWithConfig(new ExternalCompactionMetricsITConfig());
        ExternalCompactionMetricsIT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
    }

    @AfterAll
    public static void after() throws Exception {
        ExternalCompactionMetricsIT.stopMiniCluster();
        if (sink != null) {
            sink.close();
        }
    }

    @Test
    public void testMetrics() throws Exception {
        Collection tservers = (Collection)ExternalCompactionMetricsIT.getCluster().getProcesses().get(ServerType.TABLET_SERVER);
        Assertions.assertEquals((int)1, (int)tservers.size());
        String[] names = this.getUniqueNames(2);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompactionMetricsIT.getCluster().getClientProperties()).build();){
            long count;
            TestStatsDSink.Metric qm;
            TestStatsDSink.Metric qm2;
            String table1 = names[0];
            ExternalCompactionTestUtils.createTable(client, table1, "cs1", 5);
            String table2 = names[1];
            ExternalCompactionTestUtils.createTable(client, table2, "cs2", 10);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table2);
            LinkedBlockingQueue queueMetrics = new LinkedBlockingQueue();
            AtomicBoolean shutdownTailer = new AtomicBoolean(false);
            Thread thread = Threads.createThread((String)"metric-tailer", () -> {
                block0: while (!shutdownTailer.get()) {
                    List<String> statsDMetrics = sink.getLines();
                    for (String s : statsDMetrics) {
                        if (shutdownTailer.get()) continue block0;
                        if (!s.startsWith("accumulo.tserver.compactions.majc.queued")) continue;
                        queueMetrics.add(TestStatsDSink.parseStatsDMetric(s));
                    }
                }
            });
            thread.start();
            ExternalCompactionTestUtils.compact(client, table1, 7, "DCQ1", false);
            ExternalCompactionTestUtils.compact(client, table2, 13, "DCQ2", false);
            boolean sawDCQ1_5 = false;
            for (boolean sawDCQ2_10 = false; !sawDCQ1_5 || !sawDCQ2_10; sawDCQ1_5 |= ExternalCompactionMetricsIT.match(qm2, "DCQ1", "5"), sawDCQ2_10 |= ExternalCompactionMetricsIT.match(qm2, "DCQ2", "10")) {
                qm2 = (TestStatsDSink.Metric)queueMetrics.take();
            }
            ExternalCompactionMetricsIT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ1");
            ExternalCompactionMetricsIT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ2");
            boolean sawDCQ1_0 = false;
            for (boolean sawDCQ2_0 = false; !sawDCQ1_0 || !sawDCQ2_0; sawDCQ1_0 |= ExternalCompactionMetricsIT.match(qm, "DCQ1", "0"), sawDCQ2_0 |= ExternalCompactionMetricsIT.match(qm, "DCQ2", "0")) {
                qm = (TestStatsDSink.Metric)queueMetrics.take();
            }
            shutdownTailer.set(true);
            thread.join();
            do {
                UtilWaitThread.sleep((long)100L);
                try (TabletsMetadata tm = ExternalCompactionMetricsIT.getCluster().getServerContext().getAmple().readTablets().forLevel(Ample.DataLevel.USER).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP}).build();){
                    count = tm.stream().mapToLong(t -> t.getExternalCompactions().keySet().size()).sum();
                }
            } while (count > 0L);
            ExternalCompactionTestUtils.verify(client, table1, 7);
            ExternalCompactionTestUtils.verify(client, table2, 13);
        }
    }

    private static boolean match(TestStatsDSink.Metric input, String queue, String value) {
        String id;
        return input.getTags() != null && (id = input.getTags().get("id")) != null && id.equals("e." + queue) && input.getValue().equals(value);
    }

    public static class ExternalCompactionMetricsITConfig
    implements MiniClusterConfigurationCallback {
        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            ExternalCompactionTestUtils.configureMiniCluster(cfg, coreSite);
            cfg.setNumCompactors(2);
            cfg.setNumTservers(1);
            cfg.setProperty(Property.GENERAL_MICROMETER_ENABLED, "true");
            cfg.setProperty(Property.GENERAL_MICROMETER_FACTORY, TestStatsDRegistryFactory.class.getName());
            Map<String, String> sysProps = Map.of("test.meter.registry.host", "127.0.0.1", "test.meter.registry.port", Integer.toString(sink.getPort()));
            cfg.setSystemProperties(sysProps);
        }
    }
}

