/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import com.beust.jcommander.internal.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.compaction.thrift.TCompactionState;
import org.apache.accumulo.core.compaction.thrift.TCompactionStatusUpdate;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionFinalState;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.spi.compaction.DefaultCompactionPlanner;
import org.apache.accumulo.core.spi.compaction.SimpleCompactionDispatcher;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.compaction.ExternalCompactionUtil;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.compaction.ExternalCompaction_1_IT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.junit.jupiter.api.Assertions;

public class ExternalCompactionTestUtils {
    public static final int MAX_DATA = 1000;
    public static final String QUEUE1 = "DCQ1";
    public static final String QUEUE2 = "DCQ2";
    public static final String QUEUE3 = "DCQ3";
    public static final String QUEUE4 = "DCQ4";
    public static final String QUEUE5 = "DCQ5";
    public static final String QUEUE6 = "DCQ6";
    public static final String QUEUE7 = "DCQ7";
    public static final String QUEUE8 = "DCQ8";

    public static String row(int r) {
        return String.format("r:%04d", r);
    }

    public static Stream<ExternalCompactionFinalState> getFinalStatesForTable(AccumuloCluster cluster, TableId tid) {
        return cluster.getServerContext().getAmple().getExternalCompactionFinalStates().filter(state -> state.getExtent().tableId().equals((Object)tid));
    }

    public static void compact(AccumuloClient client, String table1, int modulus, String expectedQueue, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        IteratorSetting iterSetting = new IteratorSetting(100, ExternalCompaction_1_IT.TestFilter.class);
        iterSetting.addOption("expectedQ", expectedQueue);
        iterSetting.addOption("modulus", "" + modulus);
        CompactionConfig config = new CompactionConfig().setIterators(List.of(iterSetting)).setWait(wait);
        client.tableOperations().compact(table1, config);
    }

    public static void createTable(AccumuloClient client, String tableName, String service) throws Exception {
        Map<String, String> props = Map.of("table.compaction.dispatcher", SimpleCompactionDispatcher.class.getName(), "table.compaction.dispatcher.opts.service", service);
        NewTableConfiguration ntc = new NewTableConfiguration().setProperties(props);
        client.tableOperations().create(tableName, ntc);
    }

    public static void createTable(AccumuloClient client, String tableName, String service, int numTablets) throws Exception {
        int jump;
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int r = jump = 1000 / numTablets; r < 1000; r += jump) {
            splits.add(new Text(ExternalCompactionTestUtils.row(r)));
        }
        ExternalCompactionTestUtils.createTable(client, tableName, service, splits);
    }

    public static void createTable(AccumuloClient client, String tableName, String service, SortedSet<Text> splits) throws Exception {
        Map<String, String> props = Map.of("table.compaction.dispatcher", SimpleCompactionDispatcher.class.getName(), "table.compaction.dispatcher.opts.service", service);
        NewTableConfiguration ntc = new NewTableConfiguration().setProperties(props).withSplits(splits);
        client.tableOperations().create(tableName, ntc);
    }

    public static void writeData(AccumuloClient client, String table1, int rows) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        try (BatchWriter bw = client.createBatchWriter(table1);){
            for (int i = 0; i < rows; ++i) {
                Mutation m = new Mutation((CharSequence)ExternalCompactionTestUtils.row(i));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)("" + i));
                bw.addMutation(m);
            }
        }
        client.tableOperations().flush(table1);
    }

    public static void writeData(AccumuloClient client, String table1) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        ExternalCompactionTestUtils.writeData(client, table1, 1000);
    }

    public static void verify(AccumuloClient client, String table1, int modulus) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        ExternalCompactionTestUtils.verify(client, table1, modulus, 1000);
    }

    public static void verify(AccumuloClient client, String table1, int modulus, int rows) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        try (Scanner scanner = client.createScanner(table1);){
            int count = 0;
            for (Map.Entry entry : scanner) {
                Assertions.assertEquals((int)0, (int)(Integer.parseInt(((Value)entry.getValue()).toString()) % modulus), (String)String.format("%s %s %d != 0", entry.getValue(), "%", modulus));
                ++count;
            }
            int expectedCount = 0;
            for (int i = 0; i < rows; ++i) {
                if (i % modulus != 0) continue;
                ++expectedCount;
            }
            Assertions.assertEquals((int)expectedCount, (int)count);
        }
    }

    public static void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        Map clProps = Maps.newHashMap();
        clProps.put(ClientProperty.BATCH_WRITER_LATENCY_MAX.getKey(), "2s");
        cfg.setClientProps(clProps);
        cfg.setProperty("tserver.compaction.major.service.cs1.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.cs1.planner.opts.executors", "[{'name':'all', 'type': 'external', 'queue': 'DCQ1'}]");
        cfg.setProperty("tserver.compaction.major.service.cs2.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.cs2.planner.opts.executors", "[{'name':'all', 'type': 'external','queue': 'DCQ2'}]");
        cfg.setProperty("tserver.compaction.major.service.cs3.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.cs3.planner.opts.executors", "[{'name':'all', 'type': 'external','queue': 'DCQ3'}]");
        cfg.setProperty("tserver.compaction.major.service.cs4.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.cs4.planner.opts.executors", "[{'name':'all', 'type': 'external','queue': 'DCQ4'}]");
        cfg.setProperty("tserver.compaction.major.service.cs5.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.cs5.planner.opts.executors", "[{'name':'all', 'type': 'external','queue': 'DCQ5'}]");
        cfg.setProperty("tserver.compaction.major.service.cs6.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.cs6.planner.opts.executors", "[{'name':'all', 'type': 'external','queue': 'DCQ6'}]");
        cfg.setProperty("tserver.compaction.major.service.cs7.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.cs7.planner.opts.executors", "[{'name':'all', 'type': 'external','queue': 'DCQ7'}]");
        cfg.setProperty("tserver.compaction.major.service.cs8.planner", DefaultCompactionPlanner.class.getName());
        cfg.setProperty("tserver.compaction.major.service.cs8.planner.opts.executors", "[{'name':'all', 'type': 'external','queue': 'DCQ8'}]");
        cfg.setProperty(Property.COMPACTION_COORDINATOR_FINALIZER_COMPLETION_CHECK_INTERVAL, "5s");
        cfg.setProperty(Property.COMPACTION_COORDINATOR_DEAD_COMPACTOR_CHECK_INTERVAL, "5s");
        cfg.setProperty(Property.COMPACTION_COORDINATOR_TSERVER_COMPACTION_CHECK_INTERVAL, "3s");
        cfg.setProperty(Property.COMPACTION_COORDINATOR_THRIFTCLIENT_PORTSEARCH, "true");
        cfg.setProperty(Property.COMPACTOR_PORTSEARCH, "true");
        cfg.setProperty(Property.GENERAL_THREADPOOL_SIZE, "10");
        cfg.setProperty(Property.MANAGER_FATE_THREADPOOL_SIZE, "10");
        coreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TExternalCompactionList getRunningCompactions(ClientContext context) throws TException {
        Optional coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)context);
        if (coordinatorHost.isEmpty()) {
            throw new TTransportException("Unable to get CompactionCoordinator address from ZooKeeper");
        }
        CompactionCoordinatorService.Client client = (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)((HostAndPort)coordinatorHost.orElseThrow()), (ClientContext)context);
        try {
            TExternalCompactionList running;
            TExternalCompactionList tExternalCompactionList = running = client.getRunningCompactions(TraceUtil.traceInfo(), context.rpcCreds());
            return tExternalCompactionList;
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TExternalCompactionList getCompletedCompactions(ClientContext context) throws Exception {
        Optional coordinatorHost = ExternalCompactionUtil.findCompactionCoordinator((ClientContext)context);
        if (coordinatorHost.isEmpty()) {
            throw new TTransportException("Unable to get CompactionCoordinator address from ZooKeeper");
        }
        CompactionCoordinatorService.Client client = (CompactionCoordinatorService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.COORDINATOR, (HostAndPort)((HostAndPort)coordinatorHost.orElseThrow()), (ClientContext)context);
        try {
            TExternalCompactionList completed;
            TExternalCompactionList tExternalCompactionList = completed = client.getCompletedCompactions(TraceUtil.traceInfo(), context.rpcCreds());
            return tExternalCompactionList;
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
        }
    }

    public static TCompactionState getLastState(TExternalCompaction status) {
        ArrayList timestamps = new ArrayList(status.getUpdates().size());
        status.getUpdates().keySet().forEach(k -> timestamps.add(k));
        Collections.sort(timestamps);
        return ((TCompactionStatusUpdate)status.getUpdates().get(timestamps.get(timestamps.size() - 1))).getState();
    }

    public static Set<ExternalCompactionId> waitForCompactionStartAndReturnEcids(ServerContext ctx, TableId tid) {
        HashSet<ExternalCompactionId> ecids = new HashSet<ExternalCompactionId>();
        do {
            try (TabletsMetadata tm = ctx.getAmple().readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP}).build();){
                tm.stream().flatMap(t -> t.getExternalCompactions().keySet().stream()).forEach(ecids::add);
            }
            if (!ecids.isEmpty()) continue;
            UtilWaitThread.sleep((long)50L);
        } while (ecids.isEmpty());
        return ecids;
    }

    public static int confirmCompactionRunning(ServerContext ctx, Set<ExternalCompactionId> ecids) throws Exception {
        int matches = 0;
        while (matches == 0) {
            TExternalCompactionList running = ExternalCompactionTestUtils.getRunningCompactions((ClientContext)ctx);
            if (running.getCompactions() != null) {
                for (ExternalCompactionId ecid : ecids) {
                    TExternalCompaction tec = (TExternalCompaction)running.getCompactions().get(ecid.canonical());
                    if (tec == null || tec.getUpdates() == null || tec.getUpdates().isEmpty()) continue;
                    ++matches;
                    Assertions.assertEquals((Object)TCompactionState.STARTED, (Object)ExternalCompactionTestUtils.getLastState(tec));
                }
            }
            if (matches != 0) continue;
            UtilWaitThread.sleep((long)50L);
        }
        return matches;
    }

    public static void confirmCompactionCompleted(ServerContext ctx, Set<ExternalCompactionId> ecids, TCompactionState expectedState) throws Exception {
        TExternalCompactionList running = ExternalCompactionTestUtils.getRunningCompactions((ClientContext)ctx);
        while (running.getCompactions() != null) {
            running = ExternalCompactionTestUtils.getRunningCompactions((ClientContext)ctx);
            if (running.getCompactions() != null) continue;
            UtilWaitThread.sleep((long)250L);
        }
        TExternalCompactionList completed = ExternalCompactionTestUtils.getCompletedCompactions((ClientContext)ctx);
        while (completed.getCompactions() == null) {
            completed = ExternalCompactionTestUtils.getCompletedCompactions((ClientContext)ctx);
            if (completed.getCompactions() != null) continue;
            UtilWaitThread.sleep((long)50L);
        }
        for (ExternalCompactionId e : ecids) {
            TExternalCompaction tec = (TExternalCompaction)completed.getCompactions().get(e.canonical());
            Assertions.assertNotNull((Object)tec);
            Assertions.assertEquals((Object)expectedState, (Object)ExternalCompactionTestUtils.getLastState(tec));
        }
    }
}

