/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.compactor.Compactor;
import org.apache.accumulo.compactor.ExtCEnv;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.PluginConfig;
import org.apache.accumulo.core.client.admin.compaction.CompactionSelector;
import org.apache.accumulo.core.client.admin.compaction.CompressionConfigurer;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.DevNull;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionFinalState;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.spi.compaction.SimpleCompactionDispatcher;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.compaction.CompactionExecutorIT;
import org.apache.accumulo.test.compaction.ExternalCompactionTServer;
import org.apache.accumulo.test.compaction.ExternalCompactionTestUtils;
import org.apache.accumulo.test.compaction.ExternalDoNothingCompactor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalCompaction_1_IT
extends SharedMiniClusterBase {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalCompaction_1_IT.class);

    @BeforeAll
    public static void beforeTests() throws Exception {
        ExternalCompaction_1_IT.startMiniClusterWithConfig(new ExternalCompaction1Config());
    }

    @AfterEach
    public void tearDown() throws Exception {
        ExternalCompaction_1_IT.getCluster().getClusterControl().stop(ServerType.COMPACTOR);
    }

    @Test
    public void testExternalCompaction() throws Exception {
        String[] names = this.getUniqueNames(2);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_1_IT.getCluster().getClientProperties()).build();){
            String table1 = names[0];
            ExternalCompactionTestUtils.createTable(client, table1, "cs1");
            String table2 = names[1];
            ExternalCompactionTestUtils.createTable(client, table2, "cs2");
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table2);
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ1");
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ2");
            ExternalCompactionTestUtils.compact(client, table1, 2, "DCQ1", true);
            ExternalCompactionTestUtils.verify(client, table1, 2);
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text(ExternalCompactionTestUtils.row(500)));
            client.tableOperations().addSplits(table2, splits);
            ExternalCompactionTestUtils.compact(client, table2, 3, "DCQ2", true);
            ExternalCompactionTestUtils.verify(client, table2, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompactionAndCompactorDies() throws Exception {
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_1_IT.getCluster().getClientProperties()).build();){
            ((Collection)ExternalCompaction_1_IT.getCluster().getProcesses().get(ServerType.TABLET_SERVER)).forEach(p -> {
                try {
                    ExternalCompaction_1_IT.getCluster().killProcess(ServerType.TABLET_SERVER, p);
                }
                catch (Exception e) {
                    Assertions.fail((String)"Failed to shutdown tablet server");
                }
            });
            MiniAccumuloClusterImpl.ProcessInfo tserverProcess = ExternalCompaction_1_IT.getCluster().exec(ExternalCompactionTServer.class, new String[0]);
            ExternalCompactionTestUtils.createTable(client, table1, "cs3", 2);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCompactors(ExternalDoNothingCompactor.class, 1, "DCQ3");
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            ExternalCompactionTestUtils.compact(client, table1, 2, "DCQ3", false);
            TableId tid = ExternalCompaction_1_IT.getCluster().getServerContext().getTableId(table1);
            ExternalCompactionTestUtils.waitForCompactionStartAndReturnEcids(ExternalCompaction_1_IT.getCluster().getServerContext(), tid);
            ExternalCompaction_1_IT.getCluster().getClusterControl().stop(ServerType.COMPACTOR);
            long count = 0L;
            while (count == 0L) {
                count = ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_1_IT.getCluster(), tid).filter(state -> state.getFinalState().equals((Object)ExternalCompactionFinalState.FinalState.FAILED)).count();
                UtilWaitThread.sleep((long)250L);
            }
            client.tableOperations().cancelCompaction(table1);
            ExternalCompaction_1_IT.getCluster().stopProcessWithTimeout(tserverProcess.getProcess(), 30L, TimeUnit.SECONDS);
            ExternalCompaction_1_IT.getCluster().getClusterControl().stop(ServerType.TABLET_SERVER);
        }
        finally {
            ExternalCompaction_1_IT.getCluster().getClusterControl().start(ServerType.TABLET_SERVER);
        }
    }

    @Test
    public void testManytablets() throws Exception {
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_1_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table1, "cs4", 200);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 2, "DCQ4");
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            ExternalCompactionTestUtils.compact(client, table1, 3, "DCQ4", true);
            ExternalCompactionTestUtils.verify(client, table1, 3);
        }
    }

    @Test
    public void testConfigurer() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        ExternalCompaction_1_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ5");
        ExternalCompaction_1_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_1_IT.getCluster().getClientProperties()).build();){
            Map<String, String> props = Map.of("table.compaction.dispatcher", SimpleCompactionDispatcher.class.getName(), "table.compaction.dispatcher.opts.service", "cs5", Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none");
            NewTableConfiguration ntc = new NewTableConfiguration().setProperties(props);
            client.tableOperations().create(tableName, ntc);
            byte[] data = new byte[100000];
            Arrays.fill(data, (byte)65);
            try (BatchWriter writer = client.createBatchWriter(tableName);){
                for (int row = 0; row < 10; ++row) {
                    Mutation m = new Mutation((CharSequence)("" + row));
                    m.at().family((CharSequence)"big").qualifier((CharSequence)"stuff").put(data);
                    writer.addMutation(m);
                }
            }
            client.tableOperations().flush(tableName, null, null, true);
            long sizes = CompactionExecutorIT.getFileSizes(client, tableName);
            Assertions.assertTrue((sizes > (long)(data.length * 10) && sizes < (long)(data.length * 11) ? 1 : 0) != 0, (String)("Unexpected files sizes : " + sizes));
            client.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setConfigurer(new PluginConfig(CompressionConfigurer.class.getName(), Map.of("large.compress.type", "gz", "large.compress.threshold", "" + data.length))));
            sizes = CompactionExecutorIT.getFileSizes(client, tableName);
            Assertions.assertTrue((sizes < (long)data.length ? 1 : 0) != 0, (String)("Unexpected files sizes: data: " + data.length + ", file:" + sizes));
            client.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            sizes = CompactionExecutorIT.getFileSizes(client, tableName);
            Assertions.assertTrue((sizes > (long)(data.length * 10) && sizes < (long)(data.length * 11) ? 1 : 0) != 0, (String)("Unexpected files sizes : " + sizes));
            client.tableOperations().cancelCompaction(tableName);
        }
    }

    @Test
    public void testExternalCompactionWithTableIterator() throws Exception {
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_1_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table1, "cs6");
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ6");
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            ExternalCompactionTestUtils.compact(client, table1, 2, "DCQ6", true);
            ExternalCompactionTestUtils.verify(client, table1, 2);
            IteratorSetting setting = new IteratorSetting(50, "delete", ExtDevNull.class);
            client.tableOperations().attachIterator(table1, setting, EnumSet.of(IteratorUtil.IteratorScope.majc));
            client.tableOperations().compact(table1, new CompactionConfig().setWait(true));
            try (Scanner s = client.createScanner(table1);){
                Assertions.assertFalse((boolean)s.iterator().hasNext());
            }
            client.tableOperations().cancelCompaction(table1);
        }
    }

    @Test
    public void testExternalCompactionDeadTServer() throws Exception {
        ((Collection)ExternalCompaction_1_IT.getCluster().getProcesses().get(ServerType.TABLET_SERVER)).forEach(p -> {
            try {
                ExternalCompaction_1_IT.getCluster().killProcess(ServerType.TABLET_SERVER, p);
            }
            catch (Exception e) {
                Assertions.fail((String)"Failed to shutdown tablet server");
            }
        });
        MiniAccumuloClusterImpl.ProcessInfo tserverProcess = ExternalCompaction_1_IT.getCluster().exec(ExternalCompactionTServer.class, new String[0]);
        String table3 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_1_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table3, "cs7");
            ExternalCompactionTestUtils.writeData(client, table3);
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ7");
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            ExternalCompactionTestUtils.compact(client, table3, 2, "DCQ7", false);
            LOG.info("Waiting for external compaction to complete.");
            TableId tid = ExternalCompaction_1_IT.getCluster().getServerContext().getTableId(table3);
            Stream<ExternalCompactionFinalState> fs = ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_1_IT.getCluster(), tid);
            while (fs.findAny().isEmpty()) {
                LOG.info("Waiting for compaction completed marker to appear");
                UtilWaitThread.sleep((long)250L);
                fs = ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_1_IT.getCluster(), tid);
            }
            LOG.info("Validating metadata table contents.");
            TabletsMetadata tm = ExternalCompaction_1_IT.getCluster().getServerContext().getAmple().readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP}).build();
            ArrayList md = new ArrayList();
            tm.forEach(t -> md.add(t));
            Assertions.assertEquals((int)1, (int)md.size());
            TabletMetadata m = (TabletMetadata)md.get(0);
            Map em = m.getExternalCompactions();
            Assertions.assertEquals((int)1, (int)em.size());
            ArrayList finished = new ArrayList();
            ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_1_IT.getCluster(), tid).forEach(f -> finished.add(f));
            Assertions.assertEquals((int)1, (int)finished.size());
            Assertions.assertEquals(em.entrySet().iterator().next().getKey(), (Object)((ExternalCompactionFinalState)finished.get(0)).getExternalCompactionId());
            tm.close();
            client.tableOperations().flush("accumulo.metadata");
            LOG.info("Stopping our tablet server");
            ExternalCompaction_1_IT.getCluster().stopProcessWithTimeout(tserverProcess.getProcess(), 30L, TimeUnit.SECONDS);
            ExternalCompaction_1_IT.getCluster().getClusterControl().stop(ServerType.TABLET_SERVER);
            LOG.info("Starting normal tablet server");
            ExternalCompaction_1_IT.getCluster().getClusterControl().start(ServerType.TABLET_SERVER);
            LOG.info("Waiting for compaction completed marker to disappear");
            Stream<ExternalCompactionFinalState> fs2 = ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_1_IT.getCluster(), tid);
            while (fs2.findAny().isPresent()) {
                LOG.info("Waiting for compaction completed marker to disappear");
                UtilWaitThread.sleep((long)500L);
                fs2 = ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_1_IT.getCluster(), tid);
            }
            ExternalCompactionTestUtils.verify(client, table3, 2);
            client.tableOperations().cancelCompaction(table3);
        }
    }

    @Test
    public void testPartialCompaction() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_1_IT.getCluster().getClientProperties()).build();){
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ8");
            ExternalCompaction_1_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            ExternalCompactionTestUtils.createTable(client, tableName, "cs8");
            ExternalCompactionTestUtils.writeData(client, tableName);
            ExternalCompactionTestUtils.compact(client, tableName, 17, "DCQ8", true);
            ExternalCompactionTestUtils.verify(client, tableName, 17);
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                for (int i = 1000; i < 2000; ++i) {
                    Mutation m = new Mutation((CharSequence)ExternalCompactionTestUtils.row(i));
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)("" + i));
                    bw.addMutation(m);
                }
            }
            client.tableOperations().flush(tableName);
            IteratorSetting iterSetting = new IteratorSetting(100, TestFilter.class);
            iterSetting.addOption("expectedQ", "DCQ8");
            iterSetting.addOption("pmodulus", "19");
            CompactionConfig config = new CompactionConfig().setIterators(List.of(iterSetting)).setWait(true).setSelector(new PluginConfig(FSelector.class.getName()));
            client.tableOperations().compact(tableName, config);
            try (Scanner scanner = client.createScanner(tableName);){
                int count = 0;
                for (Map.Entry entry : scanner) {
                    int v = Integer.parseInt(((Value)entry.getValue()).toString());
                    int modulus = v < 1000 ? 17 : 19;
                    Assertions.assertEquals((int)0, (int)(Integer.parseInt(((Value)entry.getValue()).toString()) % modulus), (String)String.format("%s %s %d != 0", entry.getValue(), "%", modulus));
                    ++count;
                }
                int expectedCount = 0;
                for (int i = 0; i < 2000; ++i) {
                    int modulus;
                    int n = modulus = i < 1000 ? 17 : 19;
                    if (i % modulus != 0) continue;
                    ++expectedCount;
                }
                Assertions.assertEquals((int)expectedCount, (int)count);
            }
            client.tableOperations().cancelCompaction(tableName);
        }
    }

    public static class ExternalCompaction1Config
    implements MiniClusterConfigurationCallback {
        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            ExternalCompactionTestUtils.configureMiniCluster(cfg, coreSite);
            cfg.setNumCompactors(2);
        }
    }

    public static class ExtDevNull
    extends DevNull {
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            ExtCEnv.CompactorIterEnv cienv = (ExtCEnv.CompactorIterEnv)env;
            Preconditions.checkArgument((!cienv.getQueueName().isEmpty() ? 1 : 0) != 0);
        }
    }

    public static class TestFilter
    extends Filter {
        int modulus = 1;

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            ExtCEnv.CompactorIterEnv cienv = (ExtCEnv.CompactorIterEnv)env;
            Preconditions.checkArgument((!cienv.getQueueName().isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)options.getOrDefault("expectedQ", "").equals(cienv.getQueueName()));
            Preconditions.checkArgument((boolean)cienv.isUserCompaction());
            Preconditions.checkArgument((cienv.getIteratorScope() == IteratorUtil.IteratorScope.majc ? 1 : 0) != 0);
            Preconditions.checkArgument((!cienv.isSamplingEnabled() ? 1 : 0) != 0);
            if (options.containsKey("modulus")) {
                Preconditions.checkArgument((!options.containsKey("pmodulus") ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)cienv.isFullMajorCompaction());
                this.modulus = Integer.parseInt(options.get("modulus"));
            }
            if (options.containsKey("pmodulus")) {
                Preconditions.checkArgument((!options.containsKey("modulus") ? 1 : 0) != 0);
                Preconditions.checkArgument((!cienv.isFullMajorCompaction() ? 1 : 0) != 0);
                this.modulus = Integer.parseInt(options.get("pmodulus"));
            }
        }

        public boolean accept(Key k, Value v) {
            return Integer.parseInt(v.toString()) % this.modulus == 0;
        }
    }

    public static class FSelector
    implements CompactionSelector {
        public void init(CompactionSelector.InitParameters iparams) {
        }

        public CompactionSelector.Selection select(CompactionSelector.SelectionParameters sparams) {
            List toCompact = sparams.getAvailableFiles().stream().filter(cf -> cf.getFileName().startsWith("F")).collect(Collectors.toList());
            return new CompactionSelector.Selection(toCompact);
        }
    }
}

