/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.compactor.Compactor;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.compaction.thrift.TCompactionState;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.compaction.ExternalCompactionTestUtils;
import org.apache.accumulo.test.compaction.ExternalDoNothingCompactor;
import org.apache.accumulo.test.compaction.TestCompactionCoordinatorForOfflineTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalCompaction_2_IT
extends SharedMiniClusterBase {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalCompaction_2_IT.class);

    @BeforeAll
    public static void beforeTests() throws Exception {
        ExternalCompaction_2_IT.startMiniClusterWithConfig(new ExternalCompaction2Config());
    }

    @AfterEach
    public void tearDown() throws Exception {
        ExternalCompaction_2_IT.getCluster().getClusterControl().stop(ServerType.COMPACTOR);
    }

    @Test
    public void testSplitCancelsExternalCompaction() throws Exception {
        ExternalCompaction_2_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
        ExternalCompaction_2_IT.getCluster().getClusterControl().startCompactors(ExternalDoNothingCompactor.class, 1, "DCQ1");
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_2_IT.getCluster().getClientProperties()).build();){
            int jump;
            ExternalCompactionTestUtils.createTable(client, table1, "cs1");
            TableId tid = ExternalCompaction_2_IT.getCluster().getServerContext().getTableId(table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.compact(client, table1, 2, "DCQ1", false);
            Set<ExternalCompactionId> ecids = ExternalCompactionTestUtils.waitForCompactionStartAndReturnEcids(ExternalCompaction_2_IT.getCluster().getServerContext(), tid);
            int matches = ExternalCompactionTestUtils.confirmCompactionRunning(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids);
            Assertions.assertTrue((matches > 0 ? 1 : 0) != 0);
            TreeSet<Text> splits = new TreeSet<Text>();
            for (int r = jump = 200; r < 1000; r += jump) {
                splits.add(new Text(ExternalCompactionTestUtils.row(r)));
            }
            client.tableOperations().addSplits(table1, splits);
            ExternalCompactionTestUtils.confirmCompactionCompleted(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids, TCompactionState.CANCELLED);
            try (TabletsMetadata tm = ExternalCompaction_2_IT.getCluster().getServerContext().getAmple().readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP}).build();){
                Set ecids2 = tm.stream().flatMap(t -> t.getExternalCompactions().keySet().stream()).collect(Collectors.toSet());
                Assertions.assertTrue((boolean)Collections.disjoint(ecids, ecids2));
            }
            client.tableOperations().cancelCompaction(table1);
        }
    }

    @Test
    public void testExternalCompactionsSucceedsRunWithTableOffline() throws Exception {
        ExternalCompaction_2_IT.getCluster().getClusterControl().stop(ServerType.COMPACTION_COORDINATOR);
        ExternalCompaction_2_IT.getCluster().getClusterControl().stop(ServerType.COMPACTOR);
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_2_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table1, "cs2");
            client.tableOperations().setProperty(table1, Property.TABLE_MAJC_RATIO.toString(), "1.0");
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompaction_2_IT.getCluster().getClusterControl().startCoordinator(TestCompactionCoordinatorForOfflineTable.class);
            TableId tid = ExternalCompaction_2_IT.getCluster().getServerContext().getTableId(table1);
            Assertions.assertEquals((long)0L, (long)ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_2_IT.getCluster(), tid).count());
            AtomicBoolean succeededInTakingOffline = new AtomicBoolean(false);
            Thread t = new Thread(() -> {
                try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_2_IT.getCluster().getClientProperties()).build();){
                    TExternalCompactionList metrics2 = ExternalCompactionTestUtils.getRunningCompactions((ClientContext)ExternalCompaction_2_IT.getCluster().getServerContext());
                    while (metrics2.getCompactions() == null) {
                        metrics2 = ExternalCompactionTestUtils.getRunningCompactions((ClientContext)ExternalCompaction_2_IT.getCluster().getServerContext());
                        if (metrics2.getCompactions() != null) continue;
                        UtilWaitThread.sleep((long)50L);
                    }
                    LOG.info("Taking table offline");
                    client2.tableOperations().offline(table1, false);
                    succeededInTakingOffline.set(true);
                }
                catch (Exception e) {
                    LOG.error("Error: ", (Throwable)e);
                }
            });
            t.start();
            ExternalCompaction_2_IT.getCluster().getClusterControl().startCompactors(Compactor.class, 1, "DCQ2");
            Set<ExternalCompactionId> ecids = ExternalCompactionTestUtils.waitForCompactionStartAndReturnEcids(ExternalCompaction_2_IT.getCluster().getServerContext(), tid);
            int matches = ExternalCompactionTestUtils.confirmCompactionRunning(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids);
            Assertions.assertTrue((matches > 0 ? 1 : 0) != 0);
            t.join();
            if (!succeededInTakingOffline.get()) {
                Assertions.fail((String)"Failed to offline table");
            }
            ExternalCompactionTestUtils.confirmCompactionCompleted(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids, TCompactionState.SUCCEEDED);
            Assertions.assertEquals((long)1L, (long)ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_2_IT.getCluster(), tid).count());
            client.tableOperations().online(table1);
            long finalStateCount = ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_2_IT.getCluster(), tid).count();
            while (finalStateCount > 0L) {
                finalStateCount = ExternalCompactionTestUtils.getFinalStatesForTable((AccumuloCluster)ExternalCompaction_2_IT.getCluster(), tid).count();
                if (finalStateCount <= 0L) continue;
                UtilWaitThread.sleep((long)50L);
            }
            client.tableOperations().delete(table1);
            ExternalCompaction_2_IT.getCluster().getClusterControl().stop(ServerType.COMPACTION_COORDINATOR);
            ExternalCompaction_2_IT.getCluster().getClusterControl().stop(ServerType.COMPACTOR);
        }
    }

    @Test
    public void testUserCompactionCancellation() throws Exception {
        ExternalCompaction_2_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
        ExternalCompaction_2_IT.getCluster().getClusterControl().startCompactors(ExternalDoNothingCompactor.class, 1, "DCQ3");
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_2_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table1, "cs3");
            TableId tid = ExternalCompaction_2_IT.getCluster().getServerContext().getTableId(table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.compact(client, table1, 2, "DCQ3", false);
            Set<ExternalCompactionId> ecids = ExternalCompactionTestUtils.waitForCompactionStartAndReturnEcids(ExternalCompaction_2_IT.getCluster().getServerContext(), tid);
            int matches = ExternalCompactionTestUtils.confirmCompactionRunning(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids);
            Assertions.assertTrue((matches > 0 ? 1 : 0) != 0);
            client.tableOperations().cancelCompaction(table1);
            ExternalCompactionTestUtils.confirmCompactionCompleted(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids, TCompactionState.CANCELLED);
            client.tableOperations().cancelCompaction(table1);
        }
    }

    @Test
    public void testDeleteTableCancelsUserExternalCompaction() throws Exception {
        ExternalCompaction_2_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
        ExternalCompaction_2_IT.getCluster().getClusterControl().startCompactors(ExternalDoNothingCompactor.class, 1, "DCQ4");
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_2_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table1, "cs4");
            TableId tid = ExternalCompaction_2_IT.getCluster().getServerContext().getTableId(table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.compact(client, table1, 2, "DCQ4", false);
            Set<ExternalCompactionId> ecids = ExternalCompactionTestUtils.waitForCompactionStartAndReturnEcids(ExternalCompaction_2_IT.getCluster().getServerContext(), tid);
            int matches = ExternalCompactionTestUtils.confirmCompactionRunning(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids);
            Assertions.assertTrue((matches > 0 ? 1 : 0) != 0);
            client.tableOperations().delete(table1);
            ExternalCompactionTestUtils.confirmCompactionCompleted(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids, TCompactionState.CANCELLED);
        }
    }

    @Test
    public void testDeleteTableCancelsExternalCompaction() throws Exception {
        ExternalCompaction_2_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
        ExternalCompaction_2_IT.getCluster().getClusterControl().startCompactors(ExternalDoNothingCompactor.class, 1, "DCQ5");
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_2_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table1, "cs5");
            client.tableOperations().setProperty(table1, Property.TABLE_MAJC_RATIO.toString(), "1.0");
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            TableId tid = ExternalCompaction_2_IT.getCluster().getServerContext().getTableId(table1);
            Set<ExternalCompactionId> ecids = ExternalCompactionTestUtils.waitForCompactionStartAndReturnEcids(ExternalCompaction_2_IT.getCluster().getServerContext(), tid);
            int matches = ExternalCompactionTestUtils.confirmCompactionRunning(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids);
            Assertions.assertTrue((matches > 0 ? 1 : 0) != 0);
            client.tableOperations().delete(table1);
            ExternalCompactionTestUtils.confirmCompactionCompleted(ExternalCompaction_2_IT.getCluster().getServerContext(), ecids, TCompactionState.CANCELLED);
            TabletsMetadata tm = ExternalCompaction_2_IT.getCluster().getServerContext().getAmple().readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP}).build();
            Assertions.assertEquals((long)0L, (long)tm.stream().count());
            tm.close();
        }
    }

    public static class ExternalCompaction2Config
    implements MiniClusterConfigurationCallback {
        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            ExternalCompactionTestUtils.configureMiniCluster(cfg, coreSite);
        }
    }
}

