/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.compaction.thrift.TCompactionState;
import org.apache.accumulo.core.compaction.thrift.TExternalCompaction;
import org.apache.accumulo.core.compaction.thrift.TExternalCompactionList;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.compaction.ExternalCompactionTestUtils;
import org.apache.accumulo.test.compaction.ExternalDoNothingCompactor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ExternalCompaction_3_IT
extends SharedMiniClusterBase {
    @BeforeAll
    public static void beforeTests() throws Exception {
        ExternalCompaction_3_IT.startMiniClusterWithConfig(new ExternalCompaction3Config());
    }

    @AfterEach
    public void tearDown() throws Exception {
        ExternalCompaction_3_IT.getCluster().getClusterControl().stop(ServerType.COMPACTOR);
    }

    @Test
    public void testMergeCancelsExternalCompaction() throws Exception {
        ExternalCompaction_3_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
        ExternalCompaction_3_IT.getCluster().getClusterControl().startCompactors(ExternalDoNothingCompactor.class, 1, "DCQ1");
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_3_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table1, "cs1", 2);
            client.tableOperations().setProperty(table1, Property.TABLE_MAJC_RATIO.toString(), "1.0");
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.writeData(client, table1);
            TableId tid = ExternalCompaction_3_IT.getCluster().getServerContext().getTableId(table1);
            Set<ExternalCompactionId> ecids = ExternalCompactionTestUtils.waitForCompactionStartAndReturnEcids(ExternalCompaction_3_IT.getCluster().getServerContext(), tid);
            ArrayList md = new ArrayList();
            try (TabletsMetadata tm = ExternalCompaction_3_IT.getCluster().getServerContext().getAmple().readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.PREV_ROW}).build();){
                tm.forEach(t -> md.add(t));
                Assertions.assertEquals((int)2, (int)md.size());
            }
            Text start = ((TabletMetadata)md.get(0)).getPrevEndRow();
            Text end = ((TabletMetadata)md.get(1)).getEndRow();
            client.tableOperations().merge(table1, start, end);
            ExternalCompactionTestUtils.confirmCompactionCompleted(ExternalCompaction_3_IT.getCluster().getServerContext(), ecids, TCompactionState.CANCELLED);
            try (TabletsMetadata tm = ExternalCompaction_3_IT.getCluster().getServerContext().getAmple().readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.ECOMP}).build();){
                Set ecids2 = tm.stream().flatMap(t -> t.getExternalCompactions().keySet().stream()).collect(Collectors.toSet());
                while (!Collections.disjoint(ecids, ecids2)) {
                    UtilWaitThread.sleep((long)25L);
                    ecids2 = tm.stream().flatMap(t -> t.getExternalCompactions().keySet().stream()).collect(Collectors.toSet());
                }
            }
            client.tableOperations().delete(table1);
        }
    }

    @Test
    public void testCoordinatorRestartsDuringCompaction() throws Exception {
        ExternalCompaction_3_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
        ExternalCompaction_3_IT.getCluster().getClusterControl().startCompactors(ExternalDoNothingCompactor.class, 1, "DCQ2");
        String table1 = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ExternalCompaction_3_IT.getCluster().getClientProperties()).build();){
            ExternalCompactionTestUtils.createTable(client, table1, "cs2", 2);
            ExternalCompactionTestUtils.writeData(client, table1);
            ExternalCompactionTestUtils.compact(client, table1, 2, "DCQ2", false);
            TableId tid = ExternalCompaction_3_IT.getCluster().getServerContext().getTableId(table1);
            Set<ExternalCompactionId> ecids = ExternalCompactionTestUtils.waitForCompactionStartAndReturnEcids(ExternalCompaction_3_IT.getCluster().getServerContext(), tid);
            ExternalCompaction_3_IT.getCluster().getClusterControl().stop(ServerType.COMPACTION_COORDINATOR);
            ExternalCompaction_3_IT.getCluster().getClusterControl().startCoordinator(CompactionCoordinator.class);
            int matches = 0;
            while (matches == 0) {
                TExternalCompactionList running = ExternalCompactionTestUtils.getRunningCompactions((ClientContext)ExternalCompaction_3_IT.getCluster().getServerContext());
                if (running.getCompactions() != null) {
                    for (ExternalCompactionId ecid : ecids) {
                        TExternalCompaction tec = (TExternalCompaction)running.getCompactions().get(ecid.canonical());
                        if (tec == null || tec.getUpdates() == null || tec.getUpdates().isEmpty()) continue;
                        ++matches;
                        Assertions.assertEquals((Object)TCompactionState.IN_PROGRESS, (Object)ExternalCompactionTestUtils.getLastState(tec));
                    }
                }
                UtilWaitThread.sleep((long)250L);
            }
            Assertions.assertTrue((matches > 0 ? 1 : 0) != 0);
            client.tableOperations().cancelCompaction(table1);
        }
    }

    public static class ExternalCompaction3Config
    implements MiniClusterConfigurationCallback {
        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            ExternalCompactionTestUtils.configureMiniCluster(cfg, coreSite);
        }
    }
}

