/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.apache.accumulo.compactor.Compactor;
import org.apache.accumulo.core.compaction.thrift.CompactorService;
import org.apache.accumulo.core.compaction.thrift.TCompactionState;
import org.apache.accumulo.core.compaction.thrift.TCompactionStatusUpdate;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.compaction.RetryableThriftCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalDoNothingCompactor
extends Compactor
implements CompactorService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalDoNothingCompactor.class);

    ExternalDoNothingCompactor(Compactor.CompactorServerOpts opts, String[] args) {
        super(opts, args);
    }

    protected void startCancelChecker(ScheduledThreadPoolExecutor schedExecutor, long timeBetweenChecks) {
        ScheduledFuture<?> future = schedExecutor.scheduleWithFixedDelay(() -> this.checkIfCanceled(), 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    protected Compactor.FileCompactorRunnable createCompactionJob(final TExternalCompactionJob job, LongAdder totalInputEntries, LongAdder totalInputBytes, final CountDownLatch started, final CountDownLatch stopped, final AtomicReference<Throwable> err) {
        this.shutdown = true;
        return new Compactor.FileCompactorRunnable(){
            final AtomicReference<FileCompactor> ref = new AtomicReference();

            public AtomicReference<FileCompactor> getFileCompactor() {
                return this.ref;
            }

            public Duration getCompactionAge() {
                return Duration.ZERO;
            }

            public void run() {
                try {
                    try {
                        LOG.info("Starting up compaction runnable for job: {}", (Object)job);
                        TCompactionStatusUpdate update = new TCompactionStatusUpdate();
                        update.setState(TCompactionState.STARTED);
                        update.setMessage("Compaction started");
                        ExternalDoNothingCompactor.this.updateCompactionState(job, update);
                        LOG.info("Starting compactor");
                        started.countDown();
                        while (!JOB_HOLDER.isCancelled()) {
                            LOG.info("Sleeping while job is not cancelled");
                            UtilWaitThread.sleep((long)1000L);
                        }
                        throw new FileCompactor.CompactionCanceledException();
                    }
                    catch (Exception e) {
                        KeyExtent fromThriftExtent = KeyExtent.fromThrift((TKeyExtent)job.getExtent());
                        LOG.error("Compaction failed: id: {}, extent: {}", new Object[]{job.getExternalCompactionId(), fromThriftExtent, e});
                        err.set(e);
                        stopped.countDown();
                    }
                }
                catch (Throwable throwable) {
                    stopped.countDown();
                    throw throwable;
                }
            }

            public void initialize() throws RetryableThriftCall.RetriesExceededException {
                this.ref.set(new FileCompactor(ExternalDoNothingCompactor.this.getContext(), KeyExtent.fromThrift((TKeyExtent)job.getExtent()), null, null, false, null, null, null, null));
            }
        };
    }

    public static void main(String[] args) throws Exception {
        try (ExternalDoNothingCompactor compactor = new ExternalDoNothingCompactor(new Compactor.CompactorServerOpts(), args);){
            compactor.runServer();
        }
    }
}

