/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.accumulo.coordinator.CompactionCoordinator;
import org.apache.accumulo.coordinator.CompactionFinalizer;
import org.apache.accumulo.core.compaction.thrift.CompactionCoordinatorService;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionFinalState;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCompactionCoordinatorForOfflineTable
extends CompactionCoordinator
implements CompactionCoordinatorService.Iface {
    protected TestCompactionCoordinatorForOfflineTable(ServerOpts opts, String[] args) {
        super(opts, args);
    }

    protected CompactionFinalizer createCompactionFinalizer(ScheduledThreadPoolExecutor stpe) {
        return new NonNotifyingCompactionFinalizer(this.getContext(), stpe);
    }

    public static void main(String[] args) throws Exception {
        try (TestCompactionCoordinatorForOfflineTable coordinator = new TestCompactionCoordinatorForOfflineTable(new ServerOpts(), args);){
            coordinator.runServer();
        }
    }

    public static class NonNotifyingCompactionFinalizer
    extends CompactionFinalizer {
        private static final Logger LOG = LoggerFactory.getLogger(NonNotifyingCompactionFinalizer.class);

        NonNotifyingCompactionFinalizer(ServerContext context, ScheduledThreadPoolExecutor stpe) {
            super(context, stpe);
        }

        public void commitCompaction(ExternalCompactionId ecid, KeyExtent extent, long fileSize, long fileEntries) {
            ExternalCompactionFinalState ecfs = new ExternalCompactionFinalState(ecid, extent, ExternalCompactionFinalState.FinalState.FINISHED, fileSize, fileEntries);
            LOG.info("Writing completed external compaction to metadata table: {}", (Object)ecfs);
            this.context.getAmple().putExternalCompactionFinalStates(List.of(ecfs));
            LOG.info("Skipping tserver notification for completed external compaction: {}", (Object)ecfs);
        }
    }
}

