/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.util.Map;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;

public class TestCompactionStrategy
extends CompactionStrategy {
    private String inputPrefix = "Z";
    private String dropPrefix = "Z";
    private boolean shouldCompact = false;

    public void init(Map<String, String> options) {
        if (options.containsKey("inputPrefix")) {
            this.inputPrefix = options.get("inputPrefix");
        }
        if (options.containsKey("dropPrefix")) {
            this.dropPrefix = options.get("dropPrefix");
        }
        if (options.containsKey("shouldCompact")) {
            this.shouldCompact = Boolean.parseBoolean(options.get("shouldCompact"));
        }
    }

    public boolean shouldCompact(MajorCompactionRequest request) {
        if (this.shouldCompact) {
            return true;
        }
        for (TabletFile file : request.getFiles().keySet()) {
            if (file.getFileName().startsWith(this.inputPrefix)) {
                return true;
            }
            if (!file.getFileName().startsWith(this.dropPrefix)) continue;
            return true;
        }
        return false;
    }

    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
        CompactionPlan plan = new CompactionPlan();
        for (StoredTabletFile file : request.getFiles().keySet()) {
            if (file.getFileName().startsWith(this.dropPrefix)) {
                plan.deleteFiles.add(file);
                continue;
            }
            if (!file.getFileName().startsWith(this.inputPrefix)) continue;
            plan.inputFiles.add(file);
        }
        return plan;
    }
}

