/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.compaction;

import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.compaction.SizeCompactionStrategy;
import org.apache.accumulo.test.compaction.TestCompactionStrategy;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class UserCompactionStrategyIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(3L);
    }

    @AfterEach
    public void checkForDanglingFateLocks() {
        if (UserCompactionStrategyIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI) {
            FunctionalTestUtils.assertNoDanglingFateLocks(UserCompactionStrategyIT.getCluster());
        }
    }

    @Test
    public void testDropA() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeFlush(c, tableName, "a");
            this.writeFlush(c, tableName, "b");
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            this.writeFlush(c, tableName, "c");
            this.writeFlush(c, tableName, "d");
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig(TestCompactionStrategy.class.getName());
            csConfig.setOptions(Map.of("dropPrefix", "A", "inputPrefix", "F"));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assertions.assertEquals(Set.of("c", "d"), this.getRows(c, tableName));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assertions.assertEquals(Set.of("c", "d"), this.getRows(c, tableName));
        }
    }

    private void testDropNone(Map<String, String> options) throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeFlush(c, tableName, "a");
            this.writeFlush(c, tableName, "b");
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig(TestCompactionStrategy.class.getName());
            csConfig.setOptions(options);
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assertions.assertEquals(Set.of("a", "b"), this.getRows(c, tableName));
        }
    }

    @Test
    public void testDropNone() throws Exception {
        this.testDropNone(Map.of("inputPrefix", "Z"));
    }

    @Test
    public void testDropNone2() throws Exception {
        this.testDropNone(Map.of("inputPrefix", "Z", "shouldCompact", "true"));
    }

    @Test
    public void testPerTableClasspath() throws Exception {
        Assumptions.assumeTrue((UserCompactionStrategyIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            File target = new File(System.getProperty("user.dir"), "target");
            Assertions.assertTrue((target.mkdirs() || target.isDirectory() ? 1 : 0) != 0);
            File destFile = this.initJar("/org/apache/accumulo/test/TestCompactionStrat.jar", "TestCompactionStrat", target.getAbsolutePath());
            c.instanceOperations().setProperty(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + "context1", destFile.toString());
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_CLASSLOADER_CONTEXT.getKey(), "context1");
            TreeSet<Text> splits = new TreeSet<Text>(Arrays.asList(new Text("efg")));
            NewTableConfiguration ntc = new NewTableConfiguration().setProperties(props).withSplits(splits);
            c.tableOperations().create(tableName, ntc);
            this.writeFlush(c, tableName, "a");
            this.writeFlush(c, tableName, "b");
            this.writeFlush(c, tableName, "h");
            this.writeFlush(c, tableName, "i");
            Assertions.assertEquals((int)4, (int)FunctionalTestUtils.countRFiles(c, tableName));
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig("org.apache.accumulo.test.EfgCompactionStrat");
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assertions.assertEquals((int)3, (int)FunctionalTestUtils.countRFiles(c, tableName));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assertions.assertEquals((int)2, (int)FunctionalTestUtils.countRFiles(c, tableName));
        }
    }

    @Test
    public void testIterators() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeFlush(c, tableName, "a");
            this.writeFlush(c, tableName, "b");
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            this.writeFlush(c, tableName, "c");
            this.writeFlush(c, tableName, "d");
            Assertions.assertEquals((int)3, (int)FunctionalTestUtils.countRFiles(c, tableName));
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig(TestCompactionStrategy.class.getName());
            csConfig.setOptions(Map.of("inputPrefix", "F"));
            IteratorSetting iterConf = new IteratorSetting(21, "myregex", RegExFilter.class);
            RegExFilter.setRegexs((IteratorSetting)iterConf, (String)"a|c", null, null, null, (boolean)false);
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig).setIterators(Arrays.asList(iterConf)));
            Assertions.assertEquals(Set.of("a", "b", "c"), this.getRows(c, tableName));
            Assertions.assertEquals((int)2, (int)FunctionalTestUtils.countRFiles(c, tableName));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assertions.assertEquals(Set.of("a", "b", "c"), this.getRows(c, tableName));
            Assertions.assertEquals((int)1, (int)FunctionalTestUtils.countRFiles(c, tableName));
        }
    }

    @Test
    public void testFileSize() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeRandomValue(c, tableName, 65536);
            this.writeRandomValue(c, tableName, 65536);
            this.writeRandomValue(c, tableName, 512);
            this.writeRandomValue(c, tableName, 128);
            this.writeRandomValue(c, tableName, 64);
            Assertions.assertEquals((int)5, (int)FunctionalTestUtils.countRFiles(c, tableName));
            CompactionStrategyConfig csConfig = new CompactionStrategyConfig(SizeCompactionStrategy.class.getName());
            csConfig.setOptions(Map.of("size", "32768"));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assertions.assertEquals((int)3, (int)FunctionalTestUtils.countRFiles(c, tableName));
            csConfig = new CompactionStrategyConfig(SizeCompactionStrategy.class.getName());
            csConfig.setOptions(Map.of("size", "131072"));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setCompactionStrategy(csConfig));
            Assertions.assertEquals((int)1, (int)FunctionalTestUtils.countRFiles(c, tableName));
        }
    }

    @Test
    public void testConcurrent() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(UserCompactionStrategyIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            this.writeRandomValue(c, tableName, 65536);
            this.writeRandomValue(c, tableName, 65536);
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(false));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assertions.assertEquals((int)1, (int)FunctionalTestUtils.countRFiles(c, tableName));
            this.writeRandomValue(c, tableName, 65536);
            IteratorSetting iterConfig = new IteratorSetting(30, SlowIterator.class);
            SlowIterator.setSleepTime(iterConfig, 1000L);
            long t1 = System.currentTimeMillis();
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(false).setIterators(Arrays.asList(iterConfig)));
            try {
                c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
                if (System.currentTimeMillis() - t1 < 2000L) {
                    Assertions.fail((String)"Expected compaction to fail because another concurrent compaction set iterators");
                }
            }
            catch (AccumuloException accumuloException) {
                // empty catch block
            }
        }
    }

    void writeRandomValue(AccumuloClient c, String tableName, int size) throws Exception {
        byte[] data1 = new byte[size];
        random.nextBytes(data1);
        try (BatchWriter bw = c.createBatchWriter(tableName);){
            Mutation m1 = new Mutation((CharSequence)("r" + random.nextInt(909090)));
            m1.put((CharSequence)"data", (CharSequence)"bl0b", new Value(data1));
            bw.addMutation(m1);
        }
        c.tableOperations().flush(tableName, null, null, true);
    }

    private Set<String> getRows(AccumuloClient c, String tableName) throws TableNotFoundException {
        HashSet<String> rows = new HashSet<String>();
        try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
            for (Map.Entry entry : scanner) {
                rows.add(((Key)entry.getKey()).getRowData().toString());
            }
        }
        return rows;
    }

    private void writeFlush(AccumuloClient client, String tablename, String row) throws Exception {
        try (BatchWriter bw = client.createBatchWriter(tablename);){
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
        }
        client.tableOperations().flush(tablename, null, null, true);
    }
}

