/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.conf;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.TVersionedProperties;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.test.util.Wait;
import org.apache.zookeeper.data.ACL;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={@Tag(value="MiniClusterOnly"), @Tag(value="SunnyDay")})
public class PropStoreConfigIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(PropStoreConfigIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @BeforeEach
    public void clear() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            client.instanceOperations().modifyProperties(Map::clear);
            Wait.waitFor(() -> this.getStoredConfiguration().size() == 0, 5000L, 500L);
        }
    }

    @Test
    public void setTablePropTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            client.tableOperations().create(table);
            log.debug("Tables: {}", (Object)client.tableOperations().list());
            client.instanceOperations().setProperty(Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            client.tableOperations().setProperty(table, Property.TABLE_BLOOM_ENABLED.getKey(), "false");
            Wait.waitFor(() -> ((String)client.instanceOperations().getSystemConfiguration().get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("true"), 5000L, 500L);
            Wait.waitFor(() -> ((String)client.tableOperations().getConfiguration(table).get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("false"), 5000L, 500L);
            client.instanceOperations().removeProperty(Property.TABLE_BLOOM_ENABLED.getKey());
            client.tableOperations().setProperty(table, Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            Wait.waitFor(() -> ((String)client.instanceOperations().getSystemConfiguration().get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("false"), 5000L, 500L);
            Wait.waitFor(() -> ((String)client.tableOperations().getConfiguration(table).get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("true"), 5000L, 500L);
        }
    }

    @Test
    public void deletePropsTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        String namespace = names[0];
        String table = namespace + "." + names[1];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            client.namespaceOperations().create(namespace);
            client.tableOperations().create(table);
            log.info("Tables: {}", (Object)client.tableOperations().list());
            client.instanceOperations().setProperty(Property.TABLE_BLOOM_SIZE.getKey(), "12345");
            Wait.waitFor(() -> ((String)client.instanceOperations().getSystemConfiguration().get(Property.TABLE_BLOOM_SIZE.getKey())).equals("12345"), 5000L, 500L);
            Assertions.assertEquals((Object)"12345", client.tableOperations().getConfiguration(table).get(Property.TABLE_BLOOM_SIZE.getKey()));
            client.namespaceOperations().setProperty(namespace, Property.TABLE_BLOOM_SIZE.getKey(), "23456");
            Wait.waitFor(() -> ((String)client.namespaceOperations().getConfiguration(namespace).get(Property.TABLE_BLOOM_SIZE.getKey())).equals("23456"), 5000L, 500L);
            Assertions.assertEquals((Object)"23456", client.tableOperations().getConfiguration(table).get(Property.TABLE_BLOOM_SIZE.getKey()));
            client.tableOperations().setProperty(table, Property.TABLE_BLOOM_SIZE.getKey(), "34567");
            Wait.waitFor(() -> ((String)client.tableOperations().getConfiguration(table).get(Property.TABLE_BLOOM_SIZE.getKey())).equals("34567"), 5000L, 500L);
            Assertions.assertEquals((Object)"12345", client.instanceOperations().getSystemConfiguration().get(Property.TABLE_BLOOM_SIZE.getKey()));
            Assertions.assertEquals((Object)"23456", client.namespaceOperations().getConfiguration(namespace).get(Property.TABLE_BLOOM_SIZE.getKey()));
            Map tableIdMap = client.tableOperations().tableIdMap();
            Map nsIdMap = client.namespaceOperations().namespaceIdMap();
            ServerContext context = PropStoreConfigIT.getCluster().getServerContext();
            NamespaceId nid = NamespaceId.of((String)((String)nsIdMap.get(namespace)));
            TableId tid = TableId.of((String)((String)tableIdMap.get(table)));
            Assertions.assertTrue((boolean)context.getPropStore().exists((PropStoreKey)NamespacePropKey.of((ServerContext)context, (NamespaceId)nid)));
            Assertions.assertTrue((boolean)context.getPropStore().exists((PropStoreKey)TablePropKey.of((ServerContext)context, (TableId)tid)));
            Assertions.assertNotNull((Object)context.getNamespaceConfiguration(nid));
            Assertions.assertNotNull((Object)context.getTableConfiguration(tid));
            client.tableOperations().delete(table);
            client.namespaceOperations().delete(namespace);
            Thread.sleep(100L);
            Assertions.assertFalse((boolean)context.getPropStore().exists((PropStoreKey)NamespacePropKey.of((ServerContext)context, (NamespaceId)nid)));
            Assertions.assertFalse((boolean)context.getPropStore().exists((PropStoreKey)TablePropKey.of((ServerContext)context, (TableId)tid)));
            Assertions.assertNull((Object)context.getTableConfiguration(tid));
        }
    }

    @Test
    public void setInvalidPropertiesTest() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            Map config = client.instanceOperations().getSystemConfiguration();
            Map<String, String> properties = this.getStoredConfiguration();
            String maxOpenFiles = (String)config.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey());
            client.instanceOperations().modifyProperties(Map::clear);
            Wait.waitFor(() -> this.getStoredConfiguration().size() == 0, 5000L, 500L);
            int numProps = properties.size();
            client.instanceOperations().modifyProperties(original -> original.put(Property.TSERV_SCAN_MAX_OPENFILES.getKey(), maxOpenFiles));
            Wait.waitFor(() -> this.getStoredConfiguration().size() > numProps, 5000L, 500L);
            properties = this.getStoredConfiguration();
            Assertions.assertEquals((Object)maxOpenFiles, (Object)properties.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey()));
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertEquals((Object)maxOpenFiles, config.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey()));
            Assertions.assertThrows(AccumuloException.class, () -> client.instanceOperations().modifyProperties(original -> original.put(Property.TSERV_SCAN_MAX_OPENFILES.getKey(), "foo")));
            Assertions.assertEquals((Object)maxOpenFiles, (Object)properties.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey()));
        }
    }

    @Test
    public void permissionsTest() throws Exception {
        String[] names = this.getUniqueNames(3);
        String namespace = names[0];
        String table1 = namespace + "." + names[1];
        String table2 = names[2];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            client.namespaceOperations().create(namespace);
            client.tableOperations().create(table1);
            client.tableOperations().create(table2);
            Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
            ServerContext serverContext = PropStoreConfigIT.getCluster().getServerContext();
            ZooReaderWriter zrw = serverContext.getZooReaderWriter();
            List noAcl = zrw.getACL(ZooUtil.getRoot((InstanceId)serverContext.getInstanceID()));
            Assertions.assertTrue((noAcl.size() > 1 ? 1 : 0) != 0);
            Assertions.assertTrue((((ACL)noAcl.get(0)).toString().contains("world") || ((ACL)noAcl.get(1)).toString().contains("world") ? 1 : 0) != 0);
            List sysAcl = zrw.getACL(SystemPropKey.of((ServerContext)serverContext).getPath());
            Assertions.assertEquals((int)1, (int)sysAcl.size());
            Assertions.assertFalse((boolean)((ACL)sysAcl.get(0)).toString().contains("world"));
            for (Map.Entry nsEntry : client.namespaceOperations().namespaceIdMap().entrySet()) {
                log.debug("Check acl on namespace name: {}, id: {}", nsEntry.getKey(), nsEntry.getValue());
                List namespaceAcl = zrw.getACL(NamespacePropKey.of((ServerContext)serverContext, (NamespaceId)NamespaceId.of((String)((String)nsEntry.getValue()))).getPath());
                log.debug("namespace permissions: {}", (Object)namespaceAcl);
                Assertions.assertEquals((int)1, (int)namespaceAcl.size());
                Assertions.assertFalse((boolean)((ACL)namespaceAcl.get(0)).toString().contains("world"));
            }
            for (Map.Entry tEntry : client.tableOperations().tableIdMap().entrySet()) {
                log.debug("Check acl on table name: {}, id: {}", tEntry.getKey(), tEntry.getValue());
                List tableAcl = zrw.getACL(TablePropKey.of((ServerContext)serverContext, (TableId)TableId.of((String)((String)tEntry.getValue()))).getPath());
                log.debug("Received ACLs of: {}", (Object)tableAcl);
                Assertions.assertEquals((int)1, (int)tableAcl.size());
                Assertions.assertFalse((boolean)((ACL)tableAcl.get(0)).toString().contains("world"));
            }
        }
    }

    @Test
    public void modifyInstancePropertiesTest() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            Map config = client.instanceOperations().getSystemConfiguration();
            Map<String, String> properties = this.getStoredConfiguration();
            String origMaxOpenFiles = (String)config.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey());
            String origMaxMem = (String)config.get(Property.TSERV_MAXMEM.getKey());
            client.instanceOperations().modifyProperties(Map::clear);
            Wait.waitFor(() -> this.getStoredConfiguration().size() == 0, 5000L, 500L);
            int numProps = properties.size();
            String expectedMaxOpenFiles = "" + (Integer.parseInt(origMaxOpenFiles) + 1);
            String expectMaxMem = ConfigurationTypeHelper.getMemoryAsBytes((String)origMaxMem) + 1024L + "M";
            client.instanceOperations().modifyProperties(original -> {
                original.put(Property.TSERV_SCAN_MAX_OPENFILES.getKey(), expectedMaxOpenFiles);
                original.put(Property.TSERV_MAXMEM.getKey(), expectMaxMem);
            });
            Wait.waitFor(() -> this.getStoredConfiguration().size() > numProps, 5000L, 500L);
            properties = this.getStoredConfiguration();
            Assertions.assertEquals((Object)expectedMaxOpenFiles, (Object)properties.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey()));
            Assertions.assertEquals((Object)expectMaxMem, (Object)properties.get(Property.TSERV_MAXMEM.getKey()));
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertEquals((Object)expectedMaxOpenFiles, config.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey()));
            Assertions.assertEquals((Object)expectMaxMem, config.get(Property.TSERV_MAXMEM.getKey()));
            client.instanceOperations().modifyProperties(Map::clear);
            Wait.waitFor(() -> this.getStoredConfiguration().size() == 0, 5000L, 500L);
            config = client.instanceOperations().getSystemConfiguration();
            Assertions.assertEquals((Object)origMaxOpenFiles, config.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey()));
            Assertions.assertEquals((Object)origMaxMem, config.get(Property.TSERV_MAXMEM.getKey()));
        }
    }

    @Test
    public void modifyTablePropTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            client.tableOperations().create(table);
            log.info("Tables: {}", (Object)client.tableOperations().list());
            this.testModifyProperties(() -> {
                try {
                    return client.tableOperations().getConfiguration(table);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }, () -> {
                try {
                    return client.tableOperations().getTableProperties(table);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }, mapMutator -> {
                try {
                    client.tableOperations().modifyProperties(table, mapMutator);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }

    @Test
    public void modifyNamespacePropTest() throws Exception {
        String namespace = "modifyNamespacePropTest";
        String table = namespace + "testtable";
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            client.namespaceOperations().create(namespace);
            client.tableOperations().create(table);
            log.info("Tables: {}", (Object)client.tableOperations().list());
            this.testModifyProperties(() -> {
                try {
                    return client.namespaceOperations().getConfiguration(namespace);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }, () -> {
                try {
                    return client.namespaceOperations().getNamespaceProperties(namespace);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }, mapMutator -> {
                try {
                    client.namespaceOperations().modifyProperties(namespace, mapMutator);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }

    private void testModifyProperties(Supplier<Map<String, String>> fullConfig, Supplier<Map<String, String>> props, Consumer<Consumer<Map<String, String>>> modifyProperties) throws Exception {
        Map<String, String> config = fullConfig.get();
        String originalBloomEnabled = config.get(Property.TABLE_BLOOM_ENABLED.getKey());
        String originalBloomSize = config.get(Property.TABLE_BLOOM_SIZE.getKey());
        Map<String, String> properties = props.get();
        int propsSize = properties.size();
        modifyProperties.accept(original -> {
            original.put(Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            original.put(Property.TABLE_BLOOM_SIZE.getKey(), "1000");
        });
        Wait.waitFor(() -> ((Map)props.get()).size() > propsSize, 5000L, 500L);
        properties = props.get();
        Assertions.assertEquals((Object)"true", (Object)properties.get(Property.TABLE_BLOOM_ENABLED.getKey()));
        Assertions.assertEquals((Object)"1000", (Object)properties.get(Property.TABLE_BLOOM_SIZE.getKey()));
        config = fullConfig.get();
        Assertions.assertEquals((Object)"true", (Object)config.get(Property.TABLE_BLOOM_ENABLED.getKey()));
        Assertions.assertEquals((Object)"1000", (Object)config.get(Property.TABLE_BLOOM_SIZE.getKey()));
        modifyProperties.accept(original -> {
            original.remove(Property.TABLE_BLOOM_ENABLED.getKey());
            original.remove(Property.TABLE_BLOOM_SIZE.getKey());
        });
        Wait.waitFor(() -> ((Map)props.get()).size() == propsSize, 5000L, 500L);
        config = fullConfig.get();
        Assertions.assertEquals((Object)originalBloomEnabled, (Object)config.get(Property.TABLE_BLOOM_ENABLED.getKey()));
        Assertions.assertEquals((Object)originalBloomSize, (Object)config.get(Property.TABLE_BLOOM_SIZE.getKey()));
    }

    private Map<String, String> getStoredConfiguration() throws Exception {
        ServerContext ctx = PropStoreConfigIT.getCluster().getServerContext();
        return ((TVersionedProperties)ThriftClientTypes.CLIENT.execute((ClientContext)ctx, client -> client.getVersionedSystemProperties(TraceUtil.traceInfo(), ctx.rpcCreds()))).getProperties();
    }

    @Test
    public void concurrentTablePropsModificationTest() throws Exception {
        final String table = this.getUniqueNames(1)[0];
        try (final AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            client.tableOperations().create(table);
            PropertyShim propShim = new PropertyShim(){

                @Override
                public Map<String, String> modifyProperties(Consumer<Map<String, String>> modifier) throws Exception {
                    return client.tableOperations().modifyProperties(table, modifier);
                }

                @Override
                public Map<String, String> getProperties() throws Exception {
                    return client.tableOperations().getTableProperties(table);
                }
            };
            PropStoreConfigIT.runConcurrentPropsModificationTest(propShim);
        }
    }

    @Test
    public void concurrentNamespacePropsModificationTest() throws Exception {
        final String namespace = this.getUniqueNames(1)[0];
        try (final AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            client.namespaceOperations().create(namespace);
            PropertyShim propShim = new PropertyShim(){

                @Override
                public Map<String, String> modifyProperties(Consumer<Map<String, String>> modifier) throws Exception {
                    return client.namespaceOperations().modifyProperties(namespace, modifier);
                }

                @Override
                public Map<String, String> getProperties() throws Exception {
                    return client.namespaceOperations().getNamespaceProperties(namespace);
                }
            };
            PropStoreConfigIT.runConcurrentPropsModificationTest(propShim);
        }
    }

    @Test
    public void concurrentInstancePropsModificationTest() throws Exception {
        try (final AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(PropStoreConfigIT.getClientProps()).build();){
            PropertyShim propShim = new PropertyShim(){

                @Override
                public Map<String, String> modifyProperties(Consumer<Map<String, String>> modifier) throws Exception {
                    return client.instanceOperations().modifyProperties(modifier);
                }

                @Override
                public Map<String, String> getProperties() throws Exception {
                    return client.instanceOperations().getSystemConfiguration();
                }
            };
            PropStoreConfigIT.runConcurrentPropsModificationTest(propShim);
        }
    }

    private static void runConcurrentPropsModificationTest(PropertyShim propShim) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        int iterations = 151;
        Callable<Void> task1 = () -> {
            for (int i = 0; i < 151; ++i) {
                Map<String, String> prevProps = null;
                if (i % 10 == 0) {
                    prevProps = propShim.getProperties();
                }
                Map<String, String> acceptedProps = propShim.modifyProperties(tableProps -> {
                    int A = Integer.parseInt(tableProps.getOrDefault("table.custom.A", "0"));
                    int B = Integer.parseInt(tableProps.getOrDefault("table.custom.B", "0"));
                    int C = Integer.parseInt(tableProps.getOrDefault("table.custom.C", "0"));
                    int D = Integer.parseInt(tableProps.getOrDefault("table.custom.D", "0"));
                    tableProps.put("table.custom.A", "" + (A + 2));
                    tableProps.put("table.custom.B", "" + (B + 3));
                    tableProps.put("table.custom.C", "" + (C + 5));
                    tableProps.put("table.custom.D", "" + (D + 7));
                });
                if (prevProps == null) continue;
                int beforeA = Integer.parseInt(prevProps.getOrDefault("table.custom.A", "0"));
                int beforeB = Integer.parseInt(prevProps.getOrDefault("table.custom.B", "0"));
                int beforeC = Integer.parseInt(prevProps.getOrDefault("table.custom.C", "0"));
                int beforeD = Integer.parseInt(prevProps.getOrDefault("table.custom.D", "0"));
                int afterA = Integer.parseInt(acceptedProps.get("table.custom.A"));
                int afterB = Integer.parseInt(acceptedProps.get("table.custom.B"));
                int afterC = Integer.parseInt(acceptedProps.get("table.custom.C"));
                int afterD = Integer.parseInt(acceptedProps.get("table.custom.D"));
                Assertions.assertTrue((afterA >= beforeA + 2 ? 1 : 0) != 0);
                Assertions.assertTrue((afterB >= beforeB + 3 ? 1 : 0) != 0);
                Assertions.assertTrue((afterC >= beforeC + 5 ? 1 : 0) != 0);
                Assertions.assertTrue((afterD >= beforeD + 7 ? 1 : 0) != 0);
            }
            return null;
        };
        Callable<Void> task2 = () -> {
            for (int i = 0; i < 151; ++i) {
                propShim.modifyProperties(tableProps -> {
                    int B = Integer.parseInt(tableProps.getOrDefault("table.custom.B", "0"));
                    int C = Integer.parseInt(tableProps.getOrDefault("table.custom.C", "0"));
                    tableProps.put("table.custom.B", "" + (B + 11));
                    tableProps.put("table.custom.C", "" + (C + 13));
                });
            }
            return null;
        };
        Callable<Void> task3 = () -> {
            for (int i = 0; i < 151; ++i) {
                propShim.modifyProperties(tableProps -> {
                    int B = Integer.parseInt(tableProps.getOrDefault("table.custom.B", "0"));
                    tableProps.put("table.custom.B", "" + (B + 17));
                });
            }
            return null;
        };
        Callable<Void> task4 = () -> {
            for (int i = 0; i < 151; ++i) {
                propShim.modifyProperties(tableProps -> {
                    int E = Integer.parseInt(tableProps.getOrDefault("table.custom.E", "0"));
                    tableProps.put("table.custom.E", "" + (E + 19));
                });
            }
            return null;
        };
        for (Future<Void> future : executor.invokeAll(List.of(task1, task2, task3, task4))) {
            future.get();
        }
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("table.custom.A", "302");
        expected.put("table.custom.B", "4681");
        expected.put("table.custom.C", "2718");
        expected.put("table.custom.D", "1057");
        expected.put("table.custom.E", "2869");
        Predicate<String> IS_NOT_CUSTOM_TABLE_PROP = Pattern.compile("table[.]custom[.][ABCDEF]").asMatchPredicate().negate();
        Wait.waitFor(() -> {
            HashMap<String, String> tableProps = new HashMap<String, String>(propShim.getProperties());
            tableProps.keySet().removeIf(IS_NOT_CUSTOM_TABLE_PROP);
            boolean equal = expected.equals(tableProps);
            if (!equal) {
                log.info("Waiting for properties to converge. Actual:" + tableProps + " Expected:" + expected);
            }
            return equal;
        });
        Map<String, String> acceptedProps = propShim.modifyProperties(tableProps -> {
            int A = Integer.parseInt(tableProps.getOrDefault("table.custom.A", "0"));
            int B = Integer.parseInt(tableProps.getOrDefault("table.custom.B", "0"));
            int C = Integer.parseInt(tableProps.getOrDefault("table.custom.C", "0"));
            int D = Integer.parseInt(tableProps.getOrDefault("table.custom.D", "0"));
            tableProps.put("table.custom.A", "" + (A + 2));
            tableProps.put("table.custom.B", "" + (B + 3));
            tableProps.put("table.custom.C", "" + (C + 5));
            tableProps.put("table.custom.D", "" + (D + 7));
        });
        int afterA = Integer.parseInt(acceptedProps.get("table.custom.A"));
        int afterB = Integer.parseInt(acceptedProps.get("table.custom.B"));
        int afterC = Integer.parseInt(acceptedProps.get("table.custom.C"));
        int afterD = Integer.parseInt(acceptedProps.get("table.custom.D"));
        int afterE = Integer.parseInt(acceptedProps.get("table.custom.E"));
        Assertions.assertEquals((int)304, (int)afterA);
        Assertions.assertEquals((int)4684, (int)afterB);
        Assertions.assertEquals((int)2723, (int)afterC);
        Assertions.assertEquals((int)1064, (int)afterD);
        Assertions.assertEquals((int)2869, (int)afterE);
        executor.shutdown();
    }

    static interface PropertyShim {
        public Map<String, String> modifyProperties(Consumer<Map<String, String>> var1) throws Exception;

        public Map<String, String> getProperties() throws Exception;
    }
}

