/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.conf.store;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.codec.VersionedPropCodec;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.conf.store.impl.PropCacheCaffeineImpl;
import org.apache.accumulo.server.conf.store.impl.PropStoreWatcher;
import org.apache.accumulo.server.conf.store.impl.ReadyMonitor;
import org.apache.accumulo.server.conf.store.impl.ZooPropLoader;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="ZooKeeperTestingServer")
public class PropCacheCaffeineImplZkIT {
    private static final Logger log = LoggerFactory.getLogger(PropCacheCaffeineImplZkIT.class);
    private static final InstanceId INSTANCE_ID = InstanceId.of((UUID)UUID.randomUUID());
    private static ZooKeeperTestingServer testZk = null;
    private static ZooReaderWriter zrw;
    private static ZooKeeper zooKeeper;
    private final TableId tIdA = TableId.of((String)"A");
    private final TableId tIdB = TableId.of((String)"B");
    private static ServerContext context;
    @TempDir
    private static File tempDir;

    @BeforeAll
    public static void setupZk() {
        testZk = new ZooKeeperTestingServer(tempDir);
        zooKeeper = testZk.getZooKeeper();
        zrw = testZk.getZooReaderWriter();
        context = (ServerContext)EasyMock.createNiceMock(ServerContext.class);
        EasyMock.expect((Object)context.getInstanceID()).andReturn((Object)INSTANCE_ID).anyTimes();
        EasyMock.expect((Object)context.getZooReaderWriter()).andReturn((Object)zrw).anyTimes();
        EasyMock.replay((Object[])new Object[]{context});
    }

    @AfterAll
    public static void shutdownZK() throws Exception {
        EasyMock.verify((Object[])new Object[]{context});
        testZk.close();
    }

    @BeforeEach
    public void setupZnodes() {
        testZk.initPaths(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/config");
        try {
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/tables", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/tables/" + this.tIdA.canonical(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/tables/" + this.tIdA.canonical() + "/conf", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/tables/" + this.tIdB.canonical(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/tables/" + this.tIdB.canonical() + "/conf", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException ex) {
            log.trace("Issue during zk initialization, skipping", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted during zookeeper path initialization", ex);
        }
    }

    @AfterEach
    public void cleanupZnodes() {
        try {
            ZKUtil.deleteRecursive((ZooKeeper)zooKeeper, (String)"/accumulo");
        }
        catch (InterruptedException | KeeperException ex) {
            throw new IllegalStateException("Failed to clean-up test zooKeeper nodes.", ex);
        }
    }

    @Test
    public void init() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(Property.TSERV_CLIENTPORT.getKey(), "1234");
        props.put(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "false");
        props.put(Property.TSERV_SCAN_MAX_OPENFILES.getKey(), "2345");
        props.put(Property.MANAGER_CLIENTPORT.getKey(), "3456");
        props.put(Property.GC_PORT.getKey(), "4567");
        VersionedProperties vProps = new VersionedProperties(props);
        TablePropKey propStoreKey = TablePropKey.of((InstanceId)INSTANCE_ID, (TableId)this.tIdA);
        boolean created = zrw.putPersistentData(propStoreKey.getPath(), VersionedPropCodec.getDefault().toBytes(vProps), ZooUtil.NodeExistsPolicy.FAIL);
        Assertions.assertTrue((boolean)created, (String)"expected properties to be created");
        ReadyMonitor readyMonitor = new ReadyMonitor("test", (long)zooKeeper.getSessionTimeout());
        PropStoreWatcher propStoreWatcher = new PropStoreWatcher(readyMonitor);
        ZooPropLoader propLoader = new ZooPropLoader(zrw, VersionedPropCodec.getDefault(), propStoreWatcher);
        PropCacheCaffeineImpl cache = new PropCacheCaffeineImpl.Builder(propLoader).build();
        VersionedProperties readProps = cache.get((PropStoreKey)propStoreKey);
        if (readProps == null) {
            Assertions.fail((String)"Received null for versioned properties");
        } else {
            log.debug("Props read from cache: {}", (Object)readProps.print(true));
        }
    }
}

