/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.conf.store;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.codec.VersionedPropCodec;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.PropChangeListener;
import org.apache.accumulo.server.conf.store.PropStore;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.conf.store.impl.ZooPropStore;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="ZooKeeperTestingServer")
public class PropStoreZooKeeperIT {
    private static final Logger log = LoggerFactory.getLogger(PropStoreZooKeeperIT.class);
    private static final VersionedPropCodec propCodec = VersionedPropCodec.getDefault();
    private static ZooKeeperTestingServer testZk = null;
    private static ZooKeeper zooKeeper;
    private ServerContext context;
    private InstanceId instanceId = null;
    private PropStore propStore = null;
    private final TableId tIdA = TableId.of((String)"A");
    private final TableId tIdB = TableId.of((String)"B");
    @TempDir
    private static File tempDir;

    @BeforeAll
    public static void setupZk() {
        testZk = new ZooKeeperTestingServer(tempDir);
        zooKeeper = testZk.getZooKeeper();
        ZooUtil.digestAuth((ZooKeeper)zooKeeper, (String)"secret");
    }

    @AfterAll
    public static void shutdownZK() throws Exception {
        testZk.close();
    }

    @BeforeEach
    public void setupZnodes() {
        this.instanceId = InstanceId.of((UUID)UUID.randomUUID());
        this.context = (ServerContext)EasyMock.createNiceMock(ServerContext.class);
        EasyMock.expect((Object)this.context.getInstanceID()).andReturn((Object)this.instanceId).anyTimes();
        EasyMock.expect((Object)this.context.getZooReaderWriter()).andReturn((Object)testZk.getZooReaderWriter()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.context});
        testZk.initPaths(ZooUtil.getRoot((InstanceId)this.instanceId) + "/config");
        try {
            zooKeeper.create(ZooUtil.getRoot((InstanceId)this.instanceId) + "/tables", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)this.instanceId) + "/tables/" + this.tIdA.canonical(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)this.instanceId) + "/tables/" + this.tIdA.canonical() + "/conf", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)this.instanceId) + "/tables/" + this.tIdB.canonical(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)this.instanceId) + "/tables/" + this.tIdB.canonical() + "/conf", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException ex) {
            log.trace("Issue during zk initialization, skipping", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted during zookeeper path initialization", ex);
        }
        this.propStore = ZooPropStore.initialize((InstanceId)this.instanceId, (ZooReaderWriter)this.context.getZooReaderWriter());
    }

    @AfterEach
    public void cleanupZnodes() {
        try {
            ZKUtil.deleteRecursive((ZooKeeper)zooKeeper, (String)"/accumulo");
        }
        catch (InterruptedException | KeeperException ex) {
            throw new IllegalStateException("Failed to clean-up test zooKeeper nodes.", ex);
        }
    }

    @Test
    public void createNoProps() throws InterruptedException, KeeperException {
        TablePropKey propKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdA);
        Assertions.assertNull((Object)zooKeeper.exists(propKey.getPath(), false));
        Assertions.assertThrows(IllegalStateException.class, () -> this.propStore.get((PropStoreKey)propKey));
    }

    @Test
    public void failOnDuplicate() throws InterruptedException, KeeperException {
        TablePropKey propKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdA);
        Assertions.assertNull((Object)zooKeeper.exists(propKey.getPath(), false));
        this.propStore.create((PropStoreKey)propKey, Map.of());
        Thread.sleep(25L);
        Assertions.assertNotNull((Object)zooKeeper.exists(propKey.getPath(), false));
        Assertions.assertThrows(IllegalStateException.class, () -> this.propStore.create((PropStoreKey)propKey, null));
        Assertions.assertNotNull((Object)this.propStore.get((PropStoreKey)propKey));
    }

    @Test
    public void createWithProps() throws InterruptedException, KeeperException, IOException {
        TablePropKey propKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdA);
        HashMap<String, String> initialProps = new HashMap<String, String>();
        initialProps.put(Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.propStore.create((PropStoreKey)propKey, initialProps);
        VersionedProperties vProps = this.propStore.get((PropStoreKey)propKey);
        Assertions.assertNotNull((Object)vProps);
        Assertions.assertEquals((Object)"true", vProps.asMap().get(Property.TABLE_BLOOM_ENABLED.getKey()));
        byte[] bytes = zooKeeper.getData(propKey.getPath(), false, new Stat());
        VersionedProperties readFromZk = propCodec.fromBytes(0, bytes);
        VersionedProperties propsA = this.propStore.get((PropStoreKey)propKey);
        Assertions.assertEquals((Object)readFromZk.asMap(), (Object)propsA.asMap());
    }

    @Test
    public void update() throws InterruptedException {
        TestChangeListener listener = new TestChangeListener();
        TablePropKey propKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdA);
        this.propStore.registerAsListener((PropStoreKey)propKey, (PropChangeListener)listener);
        HashMap<String, String> initialProps = new HashMap<String, String>();
        initialProps.put(Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.propStore.create((PropStoreKey)propKey, initialProps);
        VersionedProperties props1 = this.propStore.get((PropStoreKey)propKey);
        Assertions.assertEquals((Object)"true", props1.asMap().get(Property.TABLE_BLOOM_ENABLED.getKey()));
        long version0 = props1.getDataVersion();
        HashMap<String, String> updateProps = new HashMap<String, String>();
        updateProps.put(Property.TABLE_BLOOM_ENABLED.getKey(), "false");
        updateProps.put(Property.TABLE_MAJC_RATIO.getKey(), "5");
        log.trace("calling update()");
        this.propStore.putAll((PropStoreKey)propKey, updateProps);
        Thread.sleep(150L);
        log.trace("calling get()");
        VersionedProperties props2 = this.propStore.get((PropStoreKey)propKey);
        long version1 = props2.getDataVersion();
        log.trace("V0: {}, V1: {}", (Object)version0, (Object)version1);
        Assertions.assertTrue((version0 < version1 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)this.propStore.get((PropStoreKey)propKey));
        Assertions.assertEquals((int)2, (int)props2.asMap().size());
        Assertions.assertEquals((Object)"false", props2.asMap().get(Property.TABLE_BLOOM_ENABLED.getKey()));
        Assertions.assertEquals((Object)"5", props2.asMap().get(Property.TABLE_MAJC_RATIO.getKey()));
        this.propStore.removeProperties((PropStoreKey)propKey, Collections.singletonList(Property.TABLE_MAJC_RATIO.getKey()));
        Thread.sleep(150L);
        VersionedProperties props3 = this.propStore.get((PropStoreKey)propKey);
        log.trace("current props: {}", (Object)props3.print(true));
        long version2 = props3.getDataVersion();
        log.trace("versions created by test: v0: {}, v1: {}, v2: {}", new Object[]{version0, version1, version2});
        Assertions.assertTrue((version0 < version2 ? 1 : 0) != 0);
        Assertions.assertTrue((version1 < version2 ? 1 : 0) != 0);
        Thread.sleep(150L);
        VersionedProperties props4 = this.propStore.get((PropStoreKey)propKey);
        Assertions.assertEquals((int)1, (int)props4.asMap().size());
        Assertions.assertEquals((Object)"false", props4.asMap().get(Property.TABLE_BLOOM_ENABLED.getKey()));
        Assertions.assertNull(props4.asMap().get(Property.TABLE_MAJC_RATIO.getKey()));
        log.trace("changed count: {}", listener.changeCounts);
        Assertions.assertEquals((int)2, (int)listener.getChangeCounts().get(propKey));
        Assertions.assertNull((Object)listener.getDeleteCounts().get(propKey));
    }

    @Test
    public void deleteTest() {
        TablePropKey tableAPropKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdA);
        TablePropKey tableBPropKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdB);
        HashMap<String, String> initialProps = new HashMap<String, String>();
        initialProps.put(Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.propStore.create((PropStoreKey)tableAPropKey, initialProps);
        this.propStore.create((PropStoreKey)tableBPropKey, initialProps);
        Assertions.assertNotNull((Object)this.propStore.get((PropStoreKey)tableAPropKey));
        Assertions.assertNotNull((Object)this.propStore.get((PropStoreKey)tableBPropKey));
        VersionedProperties props1 = this.propStore.get((PropStoreKey)tableAPropKey);
        Assertions.assertEquals((Object)"true", props1.asMap().get(Property.TABLE_BLOOM_ENABLED.getKey()));
    }

    @Test
    public void deleteThroughWatcher() throws InterruptedException {
        TestChangeListener listener = new TestChangeListener();
        TablePropKey tableAPropKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdA);
        TablePropKey tableBPropKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdB);
        this.propStore.registerAsListener((PropStoreKey)tableAPropKey, (PropChangeListener)listener);
        this.propStore.registerAsListener((PropStoreKey)tableBPropKey, (PropChangeListener)listener);
        HashMap<String, String> initialProps = new HashMap<String, String>();
        initialProps.put(Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.propStore.create((PropStoreKey)tableAPropKey, initialProps);
        this.propStore.create((PropStoreKey)tableBPropKey, initialProps);
        VersionedProperties propsA = this.propStore.get((PropStoreKey)tableAPropKey);
        Assertions.assertEquals((Object)"true", propsA.asMap().get(Property.TABLE_BLOOM_ENABLED.getKey()));
        ZooPropStore propStore2 = ZooPropStore.initialize((InstanceId)this.instanceId, (ZooReaderWriter)this.context.getZooReaderWriter());
        propStore2.delete((PropStoreKey)tableAPropKey);
        log.trace("After delete on 2nd store for table: {}", (Object)tableAPropKey);
        Thread.sleep(150L);
        Assertions.assertThrows(IllegalStateException.class, () -> this.propStore.get((PropStoreKey)tableAPropKey));
        Assertions.assertNotNull((Object)this.propStore.get((PropStoreKey)tableBPropKey));
        Assertions.assertNull((Object)listener.getChangeCounts().get(tableAPropKey));
        Assertions.assertNull((Object)listener.getChangeCounts().get(tableBPropKey));
        Assertions.assertEquals((int)1, (int)listener.getDeleteCounts().get(tableAPropKey));
        Assertions.assertNull((Object)listener.getChangeCounts().get(tableAPropKey));
    }

    @Test
    public void externalChange() throws IOException, InterruptedException, KeeperException {
        TestChangeListener listener = new TestChangeListener();
        TablePropKey tableAPropKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdA);
        TablePropKey tableBPropKey = TablePropKey.of((InstanceId)this.instanceId, (TableId)this.tIdB);
        this.propStore.registerAsListener((PropStoreKey)tableAPropKey, (PropChangeListener)listener);
        this.propStore.registerAsListener((PropStoreKey)tableBPropKey, (PropChangeListener)listener);
        HashMap<String, String> initialProps = new HashMap<String, String>();
        initialProps.put(Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.propStore.create((PropStoreKey)tableAPropKey, initialProps);
        this.propStore.create((PropStoreKey)tableBPropKey, initialProps);
        Assertions.assertNotNull((Object)this.propStore.get((PropStoreKey)tableAPropKey));
        Assertions.assertNotNull((Object)this.propStore.get((PropStoreKey)tableBPropKey));
        VersionedProperties firstRead = this.propStore.get((PropStoreKey)tableAPropKey);
        Assertions.assertEquals((Object)"true", firstRead.asMap().get(Property.TABLE_BLOOM_ENABLED.getKey()));
        Assertions.assertNull(firstRead.asMap().get(Property.TABLE_BLOOM_SIZE.getKey()));
        HashMap<String, String> update = new HashMap<String, String>();
        String bloomSize = "1_000_000";
        update.put(Property.TABLE_BLOOM_SIZE.getKey(), bloomSize);
        VersionedProperties pendingProps = firstRead.addOrUpdate(update);
        log.debug("Writing props to trigger change notification {}", (Object)pendingProps.print(true));
        byte[] updatedBytes = propCodec.toBytes(pendingProps);
        this.context.getZooReaderWriter().overwritePersistentData(tableAPropKey.getPath(), updatedBytes, (int)firstRead.getDataVersion());
        Thread.sleep(150L);
        log.trace("Test - waiting for event");
        VersionedProperties updateRead = this.propStore.get((PropStoreKey)tableAPropKey);
        log.trace("Re-read: {}", (Object)updateRead.print(true));
        Assertions.assertNull(firstRead.asMap().get(Property.TABLE_BLOOM_SIZE.getKey()));
        log.trace("Updated: {}", (Object)updateRead.print(true));
        Assertions.assertNotNull(updateRead.asMap().get(Property.TABLE_BLOOM_SIZE.getKey()));
        Assertions.assertEquals((Object)bloomSize, updateRead.asMap().get(Property.TABLE_BLOOM_SIZE.getKey()));
        log.trace("Prop changes {}", listener.getChangeCounts());
        log.trace("Prop deletes {}", listener.getDeleteCounts());
    }

    private static class TestChangeListener
    implements PropChangeListener {
        private final Map<PropStoreKey<?>, Integer> changeCounts = new ConcurrentHashMap();
        private final Map<PropStoreKey<?>, Integer> deleteCounts = new ConcurrentHashMap();

        private TestChangeListener() {
        }

        public void zkChangeEvent(PropStoreKey<?> propStoreKey) {
            this.changeCounts.merge(propStoreKey, 1, Integer::sum);
        }

        public void cacheChangeEvent(PropStoreKey<?> propStoreKey) {
            this.changeCounts.merge(propStoreKey, 1, Integer::sum);
        }

        public void deleteEvent(PropStoreKey<?> propStoreKey) {
            this.deleteCounts.merge(propStoreKey, 1, Integer::sum);
        }

        public void connectionEvent() {
        }

        public Map<PropStoreKey<?>, Integer> getChangeCounts() {
            return this.changeCounts;
        }

        public Map<PropStoreKey<?>, Integer> getDeleteCounts() {
            return this.deleteCounts;
        }
    }
}

