/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.conf.store;

import com.github.benmanes.caffeine.cache.Ticker;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.SystemConfiguration;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.PropChangeListener;
import org.apache.accumulo.server.conf.store.PropStore;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.conf.store.impl.ZooPropStore;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="ZooKeeperTestingServer")
public class ZooBasedConfigIT {
    private static final Logger log = LoggerFactory.getLogger(ZooBasedConfigIT.class);
    private static final InstanceId INSTANCE_ID = InstanceId.of((UUID)UUID.randomUUID());
    private static ZooKeeperTestingServer testZk = null;
    private static ZooReaderWriter zrw;
    private static ZooKeeper zooKeeper;
    private ServerContext context;
    private final NamespaceId nsId = NamespaceId.of((String)"nsIdForTest");
    private final TableId tidA = TableId.of((String)"A");
    private final TableId tidB = TableId.of((String)"B");
    private TestTicker ticker;
    private PropStore propStore;
    private AccumuloConfiguration parent;
    @TempDir
    private static File tempDir;

    @BeforeAll
    public static void setupZk() {
        testZk = new ZooKeeperTestingServer(tempDir);
        zooKeeper = testZk.getZooKeeper();
        ZooUtil.digestAuth((ZooKeeper)zooKeeper, (String)"secret");
        zrw = testZk.getZooReaderWriter();
    }

    @AfterAll
    public static void shutdownZK() throws Exception {
        testZk.close();
    }

    @BeforeEach
    public void initPaths() {
        this.context = (ServerContext)EasyMock.createMock(ServerContext.class);
        testZk.initPaths(ZooUtil.getRoot((InstanceId)INSTANCE_ID));
        try {
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/tables", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/tables/" + this.tidA.canonical(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/tables/" + this.tidB.canonical(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/namespaces", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/namespaces/" + this.nsId.canonical(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException ex) {
            log.trace("Issue during zk initialization, skipping", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted during zookeeper path initialization", ex);
        }
        this.ticker = new TestTicker();
        EasyMock.reset((Object[])new Object[]{this.context});
        EasyMock.expect((Object)this.context.getInstanceID()).andReturn((Object)INSTANCE_ID).anyTimes();
        EasyMock.expect((Object)this.context.getZooReaderWriter()).andReturn((Object)zrw).anyTimes();
        EasyMock.expect((Object)this.context.getZooKeepersSessionTimeOut()).andReturn((Object)zrw.getSessionTimeout()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.context});
        this.propStore = ZooPropStore.initialize((InstanceId)this.context.getInstanceID(), (ZooReaderWriter)zrw);
        EasyMock.reset((Object[])new Object[]{this.context});
        this.parent = DefaultConfiguration.getInstance();
        EasyMock.expect((Object)this.context.getInstanceID()).andReturn((Object)INSTANCE_ID).anyTimes();
        EasyMock.expect((Object)this.context.getZooReaderWriter()).andReturn((Object)zrw).anyTimes();
        EasyMock.expect((Object)this.context.getZooKeepersSessionTimeOut()).andReturn((Object)zooKeeper.getSessionTimeout()).anyTimes();
        EasyMock.expect((Object)this.context.getPropStore()).andReturn((Object)this.propStore).anyTimes();
        EasyMock.expect((Object)this.context.getSiteConfiguration()).andReturn((Object)SiteConfiguration.empty().build()).anyTimes();
    }

    @AfterEach
    public void cleanupZnodes() {
        try {
            ZKUtil.deleteRecursive((ZooKeeper)zooKeeper, (String)"/accumulo");
        }
        catch (InterruptedException | KeeperException ex) {
            throw new IllegalStateException("Failed to clean-up test zooKeeper nodes.", ex);
        }
        EasyMock.verify((Object[])new Object[]{this.context});
    }

    @Test
    public void upgradeSysTestNoProps() throws Exception {
        EasyMock.replay((Object[])new Object[]{this.context});
        zooKeeper.create(ZooUtil.getRoot((InstanceId)INSTANCE_ID) + "/config", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        SystemPropKey propKey = SystemPropKey.of((InstanceId)INSTANCE_ID);
        SystemConfiguration zbc = new SystemConfiguration(this.context, propKey, this.parent);
        Assertions.assertNotNull((Object)zbc);
    }

    @Test
    public void getPropertiesTest() {
        EasyMock.replay((Object[])new Object[]{this.context});
        this.propStore.create((PropStoreKey)SystemPropKey.of((ServerContext)this.context), Map.of(Property.TABLE_BLOOM_ENABLED.getKey(), "true"));
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)INSTANCE_ID);
        SystemConfiguration zbc = new SystemConfiguration(this.context, sysPropKey, this.parent);
        Assertions.assertNotNull((Object)zbc.getSnapshot());
        Assertions.assertEquals((Object)"true", (Object)zbc.get(Property.TABLE_BLOOM_ENABLED));
    }

    @Test
    public void failOnDuplicateCreate() {
        EasyMock.replay((Object[])new Object[]{this.context});
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)INSTANCE_ID);
        this.propStore.create((PropStoreKey)sysPropKey, Map.of());
        Assertions.assertThrows(IllegalStateException.class, () -> this.propStore.create((PropStoreKey)sysPropKey, Map.of()));
        this.propStore.create((PropStoreKey)NamespacePropKey.of((ServerContext)this.context, (NamespaceId)this.nsId), Map.of());
        Assertions.assertThrows(IllegalStateException.class, () -> this.propStore.create((PropStoreKey)NamespacePropKey.of((ServerContext)this.context, (NamespaceId)this.nsId), Map.of()));
        this.propStore.create((PropStoreKey)TablePropKey.of((ServerContext)this.context, (TableId)this.tidA), Map.of());
        Assertions.assertThrows(IllegalStateException.class, () -> this.propStore.create((PropStoreKey)TablePropKey.of((ServerContext)this.context, (TableId)this.tidA), Map.of()));
    }

    @Test
    public void getPropertiesFromParentTest() {
        EasyMock.replay((Object[])new Object[]{this.context});
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)INSTANCE_ID);
        this.propStore.create((PropStoreKey)sysPropKey, Map.of());
        this.propStore.create((PropStoreKey)NamespacePropKey.of((ServerContext)this.context, (NamespaceId)this.nsId), Map.of());
        NamespaceConfiguration zbc = new NamespaceConfiguration(this.context, this.nsId, this.parent);
        Assertions.assertNotNull((Object)zbc.getSnapshot());
        Assertions.assertEquals((Object)"false", (Object)zbc.get(Property.TABLE_BLOOM_ENABLED));
    }

    @Test
    public void throwOnNoNode() {
        EasyMock.replay((Object[])new Object[]{this.context});
        NamespaceConfiguration nsConf = new NamespaceConfiguration(this.context, this.nsId, this.parent);
        Assertions.assertThrows(IllegalStateException.class, () -> nsConf.getSnapshot());
    }

    @Test
    public void expireTest() throws Exception {
        EasyMock.replay((Object[])new Object[]{this.context});
        this.propStore.create((PropStoreKey)SystemPropKey.of((ServerContext)this.context), Map.of(Property.TABLE_BLOOM_ENABLED.getKey(), "true"));
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)INSTANCE_ID);
        TestListener testListener = new TestListener();
        this.propStore.registerAsListener((PropStoreKey)sysPropKey, (PropChangeListener)testListener);
        SystemConfiguration zbc = new SystemConfiguration(this.context, sysPropKey, this.parent);
        Assertions.assertNotNull((Object)zbc.getSnapshot());
        Assertions.assertEquals((Object)"true", (Object)zbc.get(Property.TABLE_BLOOM_ENABLED));
        long updateCount = zbc.getUpdateCount();
        this.ticker.advance(2L, TimeUnit.HOURS);
        TablePropKey tableBPropKey = TablePropKey.of((InstanceId)INSTANCE_ID, (TableId)this.tidB);
        this.propStore.create((PropStoreKey)tableBPropKey, Map.of());
        Thread.sleep(150L);
        int changeCount = testListener.getZkChangeCount();
        Stat stat = new Stat();
        byte[] bytes = zrw.getData(sysPropKey.getPath(), stat);
        zrw.overwritePersistentData(sysPropKey.getPath(), bytes, stat.getVersion());
        int retries = 5;
        do {
            Thread.sleep(25L);
        } while (changeCount >= testListener.getZkChangeCount() && --retries > 0);
        Assertions.assertTrue((changeCount < testListener.getZkChangeCount() ? 1 : 0) != 0);
        long updateCount2 = zbc.getUpdateCount();
        Assertions.assertNotEquals((long)updateCount, (long)updateCount2);
        Assertions.assertNotNull((Object)zbc.getSnapshot());
        Assertions.assertEquals((Object)"true", (Object)zbc.get(Property.TABLE_BLOOM_ENABLED));
        Assertions.assertNotEquals((long)updateCount, (long)zbc.getUpdateCount());
        Assertions.assertEquals((long)updateCount2, (long)zbc.getUpdateCount());
    }

    private static class TestTicker
    implements Ticker {
        private final long startTime = System.nanoTime();
        private long elapsed = 0L;

        public void advance(long value, TimeUnit units) {
            this.elapsed += TimeUnit.NANOSECONDS.convert(value, units);
        }

        public long read() {
            return this.startTime + this.elapsed;
        }
    }

    private static class TestListener
    implements PropChangeListener {
        private final AtomicInteger zkChangeCount = new AtomicInteger(0);
        private final AtomicInteger cacheChangeCount = new AtomicInteger(0);
        private final AtomicInteger deleteCount = new AtomicInteger(0);
        private final AtomicInteger connectionEventCount = new AtomicInteger(0);

        private TestListener() {
        }

        public int getZkChangeCount() {
            return this.zkChangeCount.get();
        }

        public int getCacheChangeCount() {
            return this.cacheChangeCount.get();
        }

        public int getDeleteCount() {
            return this.deleteCount.get();
        }

        public int getConnectionEventCount() {
            return this.connectionEventCount.get();
        }

        public void zkChangeEvent(PropStoreKey<?> propStoreKey) {
            log.debug("Received zkChangeEvent for {}", propStoreKey);
            this.zkChangeCount.incrementAndGet();
        }

        public void cacheChangeEvent(PropStoreKey<?> propStoreKey) {
            log.debug("Received cacheChangeEvent for {}", propStoreKey);
            this.cacheChangeCount.incrementAndGet();
        }

        public void deleteEvent(PropStoreKey<?> propStoreKey) {
            log.debug("Received deleteEvent for: {}", propStoreKey);
            this.deleteCount.incrementAndGet();
        }

        public void connectionEvent() {
            log.debug("Received connectionEvent");
            this.connectionEventCount.incrementAndGet();
        }

        public String toString() {
            return "TestListener{zkChangeCount=" + this.getZkChangeCount() + ", cacheChangeCount=" + this.getCacheChangeCount() + ", deleteCount=" + this.getDeleteCount() + ", connectionEventCount=" + this.getConnectionEventCount() + "}";
        }
    }
}

