/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.conf.util;

import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.util.Retry;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.codec.VersionedPropCodec;
import org.apache.accumulo.server.conf.codec.VersionedProperties;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.impl.PropStoreWatcher;
import org.apache.accumulo.server.conf.store.impl.ZooPropStore;
import org.apache.accumulo.server.conf.util.ConfigTransformer;
import org.apache.accumulo.test.conf.util.LegacyPropData;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="ZooKeeperTestingServer")
public class ConfigTransformerIT {
    private static final Logger log = LoggerFactory.getLogger(ConfigTransformerIT.class);
    private static final VersionedPropCodec codec = VersionedPropCodec.getDefault();
    @TempDir
    private static File tempDir;
    private static ZooKeeperTestingServer testZk;
    private static ZooKeeper zooKeeper;
    private static ZooReaderWriter zrw;
    private InstanceId instanceId = null;
    private ZooPropStore propStore = null;
    private ServerContext context = null;
    private PropStoreWatcher watcher = null;

    @BeforeAll
    public static void setupZk() {
        testZk = new ZooKeeperTestingServer(tempDir);
        zooKeeper = testZk.getZooKeeper();
        ZooUtil.digestAuth((ZooKeeper)zooKeeper, (String)"secret");
        zrw = testZk.getZooReaderWriter();
    }

    @AfterAll
    public static void shutdownZK() throws Exception {
        testZk.close();
    }

    @BeforeEach
    public void testSetup() throws Exception {
        this.instanceId = InstanceId.of((UUID)UUID.randomUUID());
        List<LegacyPropData.PropNode> nodes = LegacyPropData.getData(this.instanceId);
        for (LegacyPropData.PropNode node : nodes) {
            zrw.putPersistentData(node.getPath(), node.getData(), ZooUtil.NodeExistsPolicy.SKIP);
        }
        this.propStore = ZooPropStore.initialize((InstanceId)this.instanceId, (ZooReaderWriter)zrw);
        this.context = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)this.context.getInstanceID()).andReturn((Object)this.instanceId).anyTimes();
        EasyMock.expect((Object)this.context.getZooReaderWriter()).andReturn((Object)zrw).anyTimes();
        EasyMock.expect((Object)this.context.getPropStore()).andReturn((Object)this.propStore).anyTimes();
        this.watcher = (PropStoreWatcher)EasyMock.createMock(PropStoreWatcher.class);
        this.watcher.process((WatchedEvent)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.context, this.watcher});
    }

    @AfterEach
    public void cleanupZnodes() {
        try {
            ZKUtil.deleteRecursive((ZooKeeper)zooKeeper, (String)"/accumulo");
        }
        catch (InterruptedException | KeeperException ex) {
            throw new IllegalStateException("Failed to clean-up test zooKeeper nodes.", ex);
        }
        EasyMock.verify((Object[])new Object[]{this.context, this.watcher});
    }

    @Test
    public void propStoreConversionTest() throws Exception {
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)this.instanceId);
        List sysLegacy = zrw.getChildren(sysPropKey.getPath());
        log.info("Before: {}", (Object)sysLegacy);
        VersionedProperties vProps = this.propStore.get((PropStoreKey)sysPropKey);
        Assertions.assertNotNull((Object)vProps);
        log.info("Converted: {}", (Object)vProps);
        sysLegacy = zrw.getChildren(sysPropKey.getPath());
        log.info("After: {}", (Object)sysLegacy);
    }

    @Test
    public void transformTest() throws Exception {
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)this.instanceId);
        ConfigTransformer transformer = new ConfigTransformer(zrw, codec, this.watcher);
        List sysLegacy = zrw.getChildren(sysPropKey.getPath());
        log.info("Before: {}", (Object)sysLegacy);
        VersionedProperties converted = transformer.transform((PropStoreKey)sysPropKey, sysPropKey.getPath(), false);
        Assertions.assertEquals((int)sysLegacy.size(), (int)converted.asMap().size());
    }

    @Test
    public void failToGetLock() throws Exception {
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)this.instanceId);
        Retry retry = Retry.builder().maxRetries(3L).retryAfter(250L, TimeUnit.MILLISECONDS).incrementBy(500L, TimeUnit.MILLISECONDS).maxWait(5L, TimeUnit.SECONDS).backOffFactor(1.75).logInterval(3L, TimeUnit.MINUTES).createRetry();
        ConfigTransformer transformer = new ConfigTransformer(zrw, codec, this.watcher, retry);
        zrw.putEphemeralData(sysPropKey.getPath() + "/transform_token", new byte[0]);
        Assertions.assertThrows(IllegalStateException.class, () -> transformer.transform((PropStoreKey)sysPropKey, sysPropKey.getPath(), false));
    }

    @Test
    public void continueOnLockRelease() {
    }

    @Test
    public void createdByAnother() {
    }

    static {
        testZk = null;
    }
}

