/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.conf.util;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.impl.PropStoreWatcher;
import org.apache.accumulo.server.conf.store.impl.ZooPropStore;
import org.apache.accumulo.server.conf.util.TransformToken;
import org.apache.accumulo.test.conf.util.LegacyPropData;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="ZooKeeperTestingServer")
public class TransformTokenIT {
    @TempDir
    private static File tempDir;
    private static ZooKeeperTestingServer testZk;
    private static ZooKeeper zooKeeper;
    private static ZooReaderWriter zrw;
    private InstanceId instanceId = null;
    private ServerContext context = null;
    private PropStoreWatcher watcher = null;

    @BeforeAll
    public static void setupZk() {
        testZk = new ZooKeeperTestingServer(tempDir);
        zooKeeper = testZk.getZooKeeper();
        zrw = testZk.getZooReaderWriter();
    }

    @AfterAll
    public static void shutdownZK() throws Exception {
        testZk.close();
    }

    @BeforeEach
    public void testSetup() throws Exception {
        this.instanceId = InstanceId.of((UUID)UUID.randomUUID());
        List<LegacyPropData.PropNode> nodes = LegacyPropData.getData(this.instanceId);
        for (LegacyPropData.PropNode node : nodes) {
            zrw.putPersistentData(node.getPath(), node.getData(), ZooUtil.NodeExistsPolicy.SKIP);
        }
        ZooPropStore propStore = ZooPropStore.initialize((InstanceId)this.instanceId, (ZooReaderWriter)zrw);
        this.context = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)this.context.getInstanceID()).andReturn((Object)this.instanceId).anyTimes();
        EasyMock.expect((Object)this.context.getZooReaderWriter()).andReturn((Object)zrw).anyTimes();
        EasyMock.expect((Object)this.context.getPropStore()).andReturn((Object)propStore).anyTimes();
        this.watcher = (PropStoreWatcher)EasyMock.createMock(PropStoreWatcher.class);
    }

    @AfterEach
    public void cleanupZnodes() throws Exception {
        ZooUtil.digestAuth((ZooKeeper)zooKeeper, (String)"secret");
        ZKUtil.deleteRecursive((ZooKeeper)zooKeeper, (String)"/accumulo");
        EasyMock.verify((Object[])new Object[]{this.context, this.watcher});
    }

    @Test
    public void tokenGoPathTest() {
        EasyMock.replay((Object[])new Object[]{this.context, this.watcher});
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)this.instanceId);
        TransformToken token = TransformToken.createToken((String)sysPropKey.getPath(), (ZooReaderWriter)zrw);
        Assertions.assertTrue((boolean)token.haveTokenOwnership());
        token.releaseToken();
        Assertions.assertFalse((boolean)token.haveTokenOwnership());
        TransformToken lock2 = TransformToken.createToken((String)sysPropKey.getPath(), (ZooReaderWriter)zrw);
        Assertions.assertTrue((boolean)lock2.haveTokenOwnership());
        TransformToken lock3 = TransformToken.createToken((String)sysPropKey.getPath(), (ZooReaderWriter)zrw);
        Assertions.assertFalse((boolean)lock3.haveTokenOwnership());
        Assertions.assertTrue((boolean)lock2.haveTokenOwnership());
    }

    @Test
    public void failOnInvalidLockTest() throws Exception {
        EasyMock.replay((Object[])new Object[]{this.context, this.watcher});
        SystemPropKey sysPropKey = SystemPropKey.of((InstanceId)this.instanceId);
        String tokenPath = sysPropKey.getPath() + "/transform_token";
        TransformToken lock = TransformToken.createToken((String)sysPropKey.getPath(), (ZooReaderWriter)zrw);
        Assertions.assertTrue((boolean)lock.haveTokenOwnership());
        zrw.mutateExisting(tokenPath, v -> UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(IllegalStateException.class, () -> ((TransformToken)lock).releaseToken(), (String)"Expected unlock to fail on different UUID");
        zrw.delete(tokenPath);
        TransformToken lock3 = TransformToken.createToken((String)sysPropKey.getPath(), (ZooReaderWriter)zrw);
        Assertions.assertTrue((boolean)lock3.haveTokenOwnership());
        zrw.delete(tokenPath);
        Assertions.assertThrows(IllegalStateException.class, () -> ((TransformToken)lock).releaseToken(), (String)"Expected unlock to fail when no lock present");
    }

    static {
        testZk = null;
    }
}

