/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.conf.util;

import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.server.conf.util.ZooPropEditor;
import org.apache.accumulo.test.util.Wait;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={@Tag(value="MiniClusterOnly"), @Tag(value="SunnyDay")})
public class ZooPropEditorIT
extends SharedMiniClusterBase {
    private static final Logger LOG = LoggerFactory.getLogger(ZooPropEditorIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void modifyPropTest() throws Exception {
        String[] names = this.getUniqueNames(2);
        String namespace = names[0];
        String table = namespace + "." + names[1];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ZooPropEditorIT.getClientProps()).build();){
            client.namespaceOperations().create(namespace);
            client.tableOperations().create(table);
            LOG.debug("Tables: {}", (Object)client.tableOperations().list());
            client.instanceOperations().setProperty(Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            client.namespaceOperations().setProperty(namespace, Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            client.tableOperations().setProperty(table, Property.TABLE_BLOOM_ENABLED.getKey(), "false");
            Wait.waitFor(() -> ((String)client.instanceOperations().getSystemConfiguration().get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("true"), 5000L, 500L);
            ZooPropEditor tool = new ZooPropEditor();
            Wait.waitFor(() -> ((String)client.tableOperations().getTableProperties(table).get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("false"), 5000L, 500L);
            String[] setTablePropArgs = new String[]{"-p", ZooPropEditorIT.getCluster().getAccumuloPropertiesPath(), "-t", table, "-s", Property.TABLE_BLOOM_ENABLED.getKey() + "=true"};
            tool.execute(setTablePropArgs);
            Wait.waitFor(() -> ((String)client.tableOperations().getTableProperties(table).get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("true"), 5000L, 500L);
            String[] deleteTablePropArgs = new String[]{"-p", ZooPropEditorIT.getCluster().getAccumuloPropertiesPath(), "-t", table, "-d", Property.TABLE_BLOOM_ENABLED.getKey()};
            tool.execute(deleteTablePropArgs);
            Wait.waitFor(() -> client.tableOperations().getTableProperties(table).get(Property.TABLE_BLOOM_ENABLED.getKey()) == null, 5000L, 500L);
            Wait.waitFor(() -> ((String)client.instanceOperations().getSystemConfiguration().get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("true"), 5000L, 500L);
            String[] setSystemPropArgs = new String[]{"-p", ZooPropEditorIT.getCluster().getAccumuloPropertiesPath(), "-s", Property.TABLE_BLOOM_ENABLED.getKey() + "=false"};
            tool.execute(setSystemPropArgs);
            Wait.waitFor(() -> ((String)client.instanceOperations().getSystemConfiguration().get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("false"), 5000L, 500L);
            Wait.waitFor(() -> ((String)client.namespaceOperations().getNamespaceProperties(namespace).get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("true"), 5000L, 500L);
            String[] setNamespacePropArgs = new String[]{"-p", ZooPropEditorIT.getCluster().getAccumuloPropertiesPath(), "-ns", namespace, "-s", Property.TABLE_BLOOM_ENABLED.getKey() + "=false"};
            tool.execute(setNamespacePropArgs);
            Wait.waitFor(() -> ((String)client.namespaceOperations().getNamespaceProperties(namespace).get(Property.TABLE_BLOOM_ENABLED.getKey())).equals("false"), 5000L, 500L);
            String[] deleteNamespacePropArgs = new String[]{"-p", ZooPropEditorIT.getCluster().getAccumuloPropertiesPath(), "-ns", namespace, "-d", Property.TABLE_BLOOM_ENABLED.getKey()};
            tool.execute(deleteNamespacePropArgs);
            Wait.waitFor(() -> client.namespaceOperations().getNamespaceProperties(namespace).get(Property.TABLE_BLOOM_ENABLED.getKey()) == null, 5000L, 500L);
        }
    }
}

