/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.fate.zookeeper;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.AgeOffStore;
import org.apache.accumulo.core.fate.Fate;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.TStore;
import org.apache.accumulo.core.fate.ZooStore;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.TraceRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.util.Wait;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.apache.zookeeper.KeeperException;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="ZooKeeperTestingServer")
public class FateIT {
    private static final Logger LOG = LoggerFactory.getLogger(FateIT.class);
    @TempDir
    private static File tempDir;
    private static ZooKeeperTestingServer szk;
    private static ZooReaderWriter zk;
    private static final String ZK_ROOT;
    private static final NamespaceId NS;
    private static final TableId TID;
    private static CountDownLatch callStarted;
    private static CountDownLatch finishCall;
    private static CountDownLatch undoLatch;

    @BeforeAll
    public static void setup() throws Exception {
        szk = new ZooKeeperTestingServer(tempDir);
        zk = szk.getZooReaderWriter();
        zk.mkdirs(ZK_ROOT + "/fate");
        zk.mkdirs(ZK_ROOT + "/table_locks");
        zk.mkdirs(ZK_ROOT + "/namespaces/" + NS.canonical());
        zk.mkdirs(ZK_ROOT + "/state/" + TID.canonical());
        zk.mkdirs(ZK_ROOT + "/tables/" + TID.canonical());
    }

    @AfterAll
    public static void teardown() throws Exception {
        szk.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testTransactionStatus() throws Exception {
        ZooStore zooStore = new ZooStore(ZK_ROOT + "/fate", zk);
        AgeOffStore store = new AgeOffStore(zooStore, 3000L, System::currentTimeMillis);
        Manager manager = (Manager)EasyMock.createMock(Manager.class);
        ServerContext sctx = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)manager.getContext()).andReturn((Object)sctx).anyTimes();
        EasyMock.expect((Object)sctx.getZooKeeperRoot()).andReturn((Object)ZK_ROOT).anyTimes();
        EasyMock.expect((Object)sctx.getZooReaderWriter()).andReturn((Object)zk).anyTimes();
        EasyMock.replay((Object[])new Object[]{manager, sctx});
        Fate fate = new Fate((Object)manager, (TStore)store, TraceRepo::toLogString);
        try {
            ConfigurationCopy config = new ConfigurationCopy();
            config.set(Property.GENERAL_THREADPOOL_SIZE, "2");
            config.set(Property.MANAGER_FATE_THREADPOOL_SIZE, "1");
            callStarted = new CountDownLatch(1);
            finishCall = new CountDownLatch(1);
            long txid = fate.startTransaction();
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.NEW, (Object)FateIT.getTxStatus(zk, txid));
            fate.seedTransaction("TestOperation", txid, (Repo)new TestOperation(NS, TID), true, "Test Op");
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.SUBMITTED, (Object)FateIT.getTxStatus(zk, txid));
            fate.startTransactionRunners((AccumuloConfiguration)config);
            UtilWaitThread.sleep((long)3000L);
            callStarted.await();
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.IN_PROGRESS, (Object)FateIT.getTxStatus(zk, txid));
            finishCall.countDown();
            ReadOnlyTStore.TStatus s = FateIT.getTxStatus(zk, txid);
            while (s != ReadOnlyTStore.TStatus.SUCCESSFUL) {
                s = FateIT.getTxStatus(zk, txid);
                Thread.sleep(10L);
            }
            boolean errorSeen = false;
            while (!errorSeen) {
                try {
                    s = FateIT.getTxStatus(zk, txid);
                    Thread.sleep(10L);
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NONODE) {
                        errorSeen = true;
                        continue;
                    }
                    Assertions.fail((String)("Unexpected error thrown: " + e.getMessage()));
                }
            }
        }
        finally {
            fate.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelWhileNew() throws Exception {
        ZooStore zooStore = new ZooStore(ZK_ROOT + "/fate", zk);
        AgeOffStore store = new AgeOffStore(zooStore, 3000L, System::currentTimeMillis);
        Manager manager = (Manager)EasyMock.createMock(Manager.class);
        ServerContext sctx = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)manager.getContext()).andReturn((Object)sctx).anyTimes();
        EasyMock.expect((Object)sctx.getZooKeeperRoot()).andReturn((Object)ZK_ROOT).anyTimes();
        EasyMock.expect((Object)sctx.getZooReaderWriter()).andReturn((Object)zk).anyTimes();
        EasyMock.replay((Object[])new Object[]{manager, sctx});
        Fate fate = new Fate((Object)manager, (TStore)store, TraceRepo::toLogString);
        try {
            ConfigurationCopy config = new ConfigurationCopy();
            config.set(Property.GENERAL_THREADPOOL_SIZE, "2");
            config.set(Property.MANAGER_FATE_THREADPOOL_SIZE, "1");
            fate.startTransactionRunners((AccumuloConfiguration)config);
            UtilWaitThread.sleep((long)3000L);
            callStarted = new CountDownLatch(1);
            finishCall = new CountDownLatch(1);
            long txid = fate.startTransaction();
            LOG.debug("Starting test testCancelWhileNew with {}", (Object)FateTxId.formatTid((long)txid));
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.NEW, (Object)FateIT.getTxStatus(zk, txid));
            Assertions.assertTrue((boolean)fate.cancel(txid));
            Assertions.assertTrue((ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS == FateIT.getTxStatus(zk, txid) || ReadOnlyTStore.TStatus.FAILED == FateIT.getTxStatus(zk, txid) ? 1 : 0) != 0);
            fate.seedTransaction("TestOperation", txid, (Repo)new TestOperation(NS, TID), true, "Test Op");
            Wait.waitFor(() -> ReadOnlyTStore.TStatus.FAILED == FateIT.getTxStatus(zk, txid));
            Assertions.assertEquals((long)1L, (long)callStarted.getCount());
            fate.delete(txid);
            Assertions.assertThrows(KeeperException.NoNodeException.class, () -> FateIT.getTxStatus(zk, txid));
        }
        finally {
            fate.shutdown();
        }
    }

    @Test
    public void testCancelWhileSubmittedNotRunning() throws Exception {
        ZooStore zooStore = new ZooStore(ZK_ROOT + "/fate", zk);
        AgeOffStore store = new AgeOffStore(zooStore, 3000L, System::currentTimeMillis);
        Manager manager = (Manager)EasyMock.createMock(Manager.class);
        ServerContext sctx = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)manager.getContext()).andReturn((Object)sctx).anyTimes();
        EasyMock.expect((Object)sctx.getZooKeeperRoot()).andReturn((Object)ZK_ROOT).anyTimes();
        EasyMock.expect((Object)sctx.getZooReaderWriter()).andReturn((Object)zk).anyTimes();
        EasyMock.replay((Object[])new Object[]{manager, sctx});
        Fate fate = new Fate((Object)manager, (TStore)store, TraceRepo::toLogString);
        ConfigurationCopy config = new ConfigurationCopy();
        config.set(Property.GENERAL_THREADPOOL_SIZE, "2");
        UtilWaitThread.sleep((long)3000L);
        callStarted = new CountDownLatch(1);
        finishCall = new CountDownLatch(1);
        long txid = fate.startTransaction();
        LOG.debug("Starting test testCancelWhileSubmitted with {}", (Object)FateTxId.formatTid((long)txid));
        Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.NEW, (Object)FateIT.getTxStatus(zk, txid));
        fate.seedTransaction("TestOperation", txid, (Repo)new TestOperation(NS, TID), true, "Test Op");
        Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.SUBMITTED, (Object)FateIT.getTxStatus(zk, txid));
        Assertions.assertTrue((boolean)fate.cancel(txid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelWhileSubmittedAndRunning() throws Exception {
        ZooStore zooStore = new ZooStore(ZK_ROOT + "/fate", zk);
        AgeOffStore store = new AgeOffStore(zooStore, 3000L, System::currentTimeMillis);
        Manager manager = (Manager)EasyMock.createMock(Manager.class);
        ServerContext sctx = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)manager.getContext()).andReturn((Object)sctx).anyTimes();
        EasyMock.expect((Object)sctx.getZooKeeperRoot()).andReturn((Object)ZK_ROOT).anyTimes();
        EasyMock.expect((Object)sctx.getZooReaderWriter()).andReturn((Object)zk).anyTimes();
        EasyMock.replay((Object[])new Object[]{manager, sctx});
        Fate fate = new Fate((Object)manager, (TStore)store, TraceRepo::toLogString);
        try {
            ConfigurationCopy config = new ConfigurationCopy();
            config.set(Property.GENERAL_THREADPOOL_SIZE, "2");
            config.set(Property.MANAGER_FATE_THREADPOOL_SIZE, "1");
            fate.startTransactionRunners((AccumuloConfiguration)config);
            UtilWaitThread.sleep((long)3000L);
            callStarted = new CountDownLatch(1);
            finishCall = new CountDownLatch(1);
            long txid = fate.startTransaction();
            LOG.debug("Starting test testCancelWhileSubmitted with {}", (Object)FateTxId.formatTid((long)txid));
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.NEW, (Object)FateIT.getTxStatus(zk, txid));
            fate.seedTransaction("TestOperation", txid, (Repo)new TestOperation(NS, TID), false, "Test Op");
            Wait.waitFor(() -> ReadOnlyTStore.TStatus.IN_PROGRESS == FateIT.getTxStatus(zk, txid));
            Assertions.assertFalse((boolean)fate.cancel(txid));
            callStarted.await();
            finishCall.countDown();
            Wait.waitFor(() -> ReadOnlyTStore.TStatus.IN_PROGRESS != FateIT.getTxStatus(zk, txid));
            fate.delete(txid);
            Assertions.assertThrows(KeeperException.NoNodeException.class, () -> FateIT.getTxStatus(zk, txid));
        }
        finally {
            fate.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelWhileInCall() throws Exception {
        ZooStore zooStore = new ZooStore(ZK_ROOT + "/fate", zk);
        AgeOffStore store = new AgeOffStore(zooStore, 3000L, System::currentTimeMillis);
        Manager manager = (Manager)EasyMock.createMock(Manager.class);
        ServerContext sctx = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)manager.getContext()).andReturn((Object)sctx).anyTimes();
        EasyMock.expect((Object)sctx.getZooKeeperRoot()).andReturn((Object)ZK_ROOT).anyTimes();
        EasyMock.expect((Object)sctx.getZooReaderWriter()).andReturn((Object)zk).anyTimes();
        EasyMock.replay((Object[])new Object[]{manager, sctx});
        Fate fate = new Fate((Object)manager, (TStore)store, TraceRepo::toLogString);
        try {
            ConfigurationCopy config = new ConfigurationCopy();
            config.set(Property.GENERAL_THREADPOOL_SIZE, "2");
            config.set(Property.MANAGER_FATE_THREADPOOL_SIZE, "1");
            callStarted = new CountDownLatch(1);
            finishCall = new CountDownLatch(1);
            long txid = fate.startTransaction();
            LOG.debug("Starting test testCancelWhileInCall with {}", (Object)FateTxId.formatTid((long)txid));
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.NEW, (Object)FateIT.getTxStatus(zk, txid));
            fate.seedTransaction("TestOperation", txid, (Repo)new TestOperation(NS, TID), true, "Test Op");
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.SUBMITTED, (Object)FateIT.getTxStatus(zk, txid));
            fate.startTransactionRunners((AccumuloConfiguration)config);
            UtilWaitThread.sleep((long)3000L);
            callStarted.await();
            Assertions.assertFalse((boolean)fate.cancel(txid));
        }
        finally {
            fate.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRepoFails() throws Exception {
        ZooStore zooStore = new ZooStore(ZK_ROOT + "/fate", zk);
        AgeOffStore store = new AgeOffStore(zooStore, 3000L, System::currentTimeMillis);
        Manager manager = (Manager)EasyMock.createMock(Manager.class);
        ServerContext sctx = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)manager.getContext()).andReturn((Object)sctx).anyTimes();
        EasyMock.expect((Object)sctx.getZooKeeperRoot()).andReturn((Object)ZK_ROOT).anyTimes();
        EasyMock.expect((Object)sctx.getZooReaderWriter()).andReturn((Object)zk).anyTimes();
        EasyMock.replay((Object[])new Object[]{manager, sctx});
        Fate fate = new Fate((Object)manager, (TStore)store, TraceRepo::toLogString);
        try {
            ConfigurationCopy config = new ConfigurationCopy();
            config.set(Property.GENERAL_THREADPOOL_SIZE, "2");
            config.set(Property.MANAGER_FATE_THREADPOOL_SIZE, "1");
            fate.startTransactionRunners((AccumuloConfiguration)config);
            UtilWaitThread.sleep((long)3000L);
            List<String> expectedUndoOrder = List.of("OP3", "OP2", "OP1");
            undoLatch = new CountDownLatch(3);
            long txid = fate.startTransaction();
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.NEW, (Object)FateIT.getTxStatus(zk, txid));
            fate.seedTransaction("TestOperationFails", txid, (Repo)new TestOperationFails(1, ExceptionLocation.CALL), false, "Test Op Fails");
            undoLatch.await();
            Assertions.assertEquals(expectedUndoOrder, TestOperationFails.undoOrder);
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.FAILED, (Object)fate.waitForCompletion(txid));
            Assertions.assertTrue((boolean)fate.getException(txid).getMessage().contains("call() failed"));
            TestOperationFails.undoOrder = new ArrayList<String>();
            undoLatch = new CountDownLatch(3);
            txid = fate.startTransaction();
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.NEW, (Object)FateIT.getTxStatus(zk, txid));
            fate.seedTransaction("TestOperationFails", txid, (Repo)new TestOperationFails(1, ExceptionLocation.IS_READY), false, "Test Op Fails");
            undoLatch.await();
            Assertions.assertEquals(expectedUndoOrder, TestOperationFails.undoOrder);
            Assertions.assertEquals((Object)ReadOnlyTStore.TStatus.FAILED, (Object)fate.waitForCompletion(txid));
            Assertions.assertTrue((boolean)fate.getException(txid).getMessage().contains("isReady() failed"));
        }
        finally {
            fate.shutdown();
        }
    }

    private static void inCall() throws InterruptedException {
        callStarted.countDown();
        finishCall.await();
    }

    private static ReadOnlyTStore.TStatus getTxStatus(ZooReaderWriter zrw, long txid) throws KeeperException, InterruptedException {
        zrw.sync(ZK_ROOT);
        String txdir = String.format("%s%s/tx_%016x", ZK_ROOT, "/fate", txid);
        return ReadOnlyTStore.TStatus.valueOf((String)new String(zrw.getData(txdir), StandardCharsets.UTF_8));
    }

    static {
        szk = null;
        zk = null;
        ZK_ROOT = "/accumulo/" + UUID.randomUUID().toString();
        NS = NamespaceId.of((String)"testNameSpace");
        TID = TableId.of((String)"testTable");
    }

    public static class TestOperation
    extends ManagerRepo {
        private static final Logger LOG = LoggerFactory.getLogger(TestOperation.class);
        private static final long serialVersionUID = 1L;
        private final TableId tableId;
        private final NamespaceId namespaceId;

        public TestOperation(NamespaceId namespaceId, TableId tableId) {
            this.namespaceId = namespaceId;
            this.tableId = tableId;
        }

        public long isReady(long tid, Manager manager) throws Exception {
            return Utils.reserveNamespace((Manager)manager, (NamespaceId)this.namespaceId, (long)tid, (boolean)false, (boolean)true, (TableOperation)TableOperation.RENAME) + Utils.reserveTable((Manager)manager, (TableId)this.tableId, (long)tid, (boolean)true, (boolean)true, (TableOperation)TableOperation.RENAME);
        }

        public void undo(long tid, Manager manager) throws Exception {
            Utils.unreserveNamespace((Manager)manager, (NamespaceId)this.namespaceId, (long)tid, (boolean)false);
            Utils.unreserveTable((Manager)manager, (TableId)this.tableId, (long)tid, (boolean)true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Repo<Manager> call(long tid, Manager manager) throws Exception {
            LOG.debug("Entering call {}", (Object)FateTxId.formatTid((long)tid));
            try {
                FateIT.inCall();
                Repo<Manager> repo = null;
                return repo;
            }
            finally {
                Utils.unreserveNamespace((Manager)manager, (NamespaceId)this.namespaceId, (long)tid, (boolean)false);
                Utils.unreserveTable((Manager)manager, (TableId)this.tableId, (long)tid, (boolean)true);
                LOG.debug("Leaving call {}", (Object)FateTxId.formatTid((long)tid));
            }
        }
    }

    public static class TestOperationFails
    extends ManagerRepo {
        private static final long serialVersionUID = 1L;
        private static final Logger LOG = LoggerFactory.getLogger(TestOperationFails.class);
        private static List<String> undoOrder = new ArrayList<String>();
        private static final int TOTAL_NUM_OPS = 3;
        private int opNum;
        private final String opName;
        private final ExceptionLocation location;

        public TestOperationFails(int opNum, ExceptionLocation location) {
            this.opNum = opNum;
            this.opName = "OP" + opNum;
            this.location = location;
        }

        public long isReady(long tid, Manager environment) throws Exception {
            LOG.debug("{} {} Entered isReady()", (Object)this.opName, (Object)FateTxId.formatTid((long)tid));
            if (this.location == ExceptionLocation.IS_READY) {
                if (this.opNum < 3) {
                    return 0L;
                }
                throw new Exception(this.opName + " " + FateTxId.formatTid((long)tid) + " isReady() failed - this is expected");
            }
            return 0L;
        }

        public void undo(long tid, Manager environment) throws Exception {
            LOG.debug("{} {} Entered undo()", (Object)this.opName, (Object)FateTxId.formatTid((long)tid));
            undoOrder.add(this.opName);
            undoLatch.countDown();
        }

        public Repo<Manager> call(long tid, Manager environment) throws Exception {
            LOG.debug("{} {} Entered call()", (Object)this.opName, (Object)FateTxId.formatTid((long)tid));
            if (this.location == ExceptionLocation.CALL) {
                if (this.opNum < 3) {
                    return new TestOperationFails(++this.opNum, this.location);
                }
                throw new Exception(this.opName + " " + FateTxId.formatTid((long)tid) + " call() failed - this is expected");
            }
            return new TestOperationFails(++this.opNum, this.location);
        }
    }

    private static enum ExceptionLocation {
        CALL,
        IS_READY;

    }
}

