/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.fate.zookeeper;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooSession;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.test.util.Wait;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="ZooKeeperTestingServer")
public class ServiceLockIT {
    @TempDir
    private static File tempDir;
    private static ZooKeeperTestingServer szk;
    private static final AtomicInteger pdCount;

    @BeforeAll
    public static void setup() throws Exception {
        szk = new ZooKeeperTestingServer(tempDir);
        szk.initPaths("/accumulo/" + InstanceId.of((UUID)UUID.randomUUID()));
    }

    @AfterAll
    public static void teardown() throws Exception {
        szk.close();
    }

    private static ServiceLock getZooLock(ServiceLock.ServiceLockPath parent, UUID uuid) {
        ZooKeeper zooKeeper = ZooSession.getAuthenticatedSession((String)szk.getConn(), (int)30000, (String)"digest", (byte[])"accumulo:secret".getBytes(StandardCharsets.UTF_8));
        return new ServiceLock(zooKeeper, parent, uuid);
    }

    private static ServiceLock getZooLock(ZooKeeperWrapper zkw, ServiceLock.ServiceLockPath parent, UUID uuid) {
        return new ServiceLockWrapper(zkw, parent, uuid);
    }

    @Test
    @Timeout(value=10L)
    public void testDeleteParent() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)("/zltestDeleteParent-" + this.hashCode() + "-l" + pdCount.incrementAndGet()));
        ServiceLock zl = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
        Assertions.assertFalse((boolean)zl.isLocked());
        ZooReaderWriter zk = szk.getZooReaderWriter();
        zk.mkdirs(parent.toString());
        zk.delete(parent.toString());
        zk.mkdirs(parent.toString());
        TestALW lw = new TestALW();
        zl.lock((ServiceLock.AccumuloLockWatcher)lw, "test1".getBytes(StandardCharsets.UTF_8));
        lw.waitForChanges(1);
        Assertions.assertTrue((boolean)lw.locked);
        Assertions.assertTrue((boolean)zl.isLocked());
        Assertions.assertNull((Object)lw.exception);
        Assertions.assertNull((Object)lw.reason);
        zl.unlock();
    }

    @Test
    @Timeout(value=10L)
    public void testNoParent() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)("/zltestNoParent-" + this.hashCode() + "-l" + pdCount.incrementAndGet()));
        ServiceLock zl = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
        Assertions.assertFalse((boolean)zl.isLocked());
        TestALW lw = new TestALW();
        zl.lock((ServiceLock.AccumuloLockWatcher)lw, "test1".getBytes(StandardCharsets.UTF_8));
        lw.waitForChanges(1);
        Assertions.assertFalse((boolean)lw.locked);
        Assertions.assertFalse((boolean)zl.isLocked());
        Assertions.assertNotNull((Object)lw.exception);
        Assertions.assertNull((Object)lw.reason);
    }

    @Test
    @Timeout(value=10L)
    public void testDeleteLock() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)("/zltestDeleteLock-" + this.hashCode() + "-l" + pdCount.incrementAndGet()));
        ZooReaderWriter zk = szk.getZooReaderWriter();
        zk.mkdirs(parent.toString());
        ServiceLock zl = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
        Assertions.assertFalse((boolean)zl.isLocked());
        TestALW lw = new TestALW();
        zl.lock((ServiceLock.AccumuloLockWatcher)lw, "test1".getBytes(StandardCharsets.UTF_8));
        lw.waitForChanges(1);
        Assertions.assertTrue((boolean)lw.locked);
        Assertions.assertTrue((boolean)zl.isLocked());
        Assertions.assertNull((Object)lw.exception);
        Assertions.assertNull((Object)lw.reason);
        zk.delete(zl.getLockPath());
        lw.waitForChanges(2);
        Assertions.assertEquals((Object)ServiceLock.LockLossReason.LOCK_DELETED, (Object)lw.reason);
        Assertions.assertNull((Object)lw.exception);
    }

    @Test
    @Timeout(value=15L)
    public void testDeleteWaiting() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)("/zltestDeleteWaiting-" + this.hashCode() + "-l" + pdCount.incrementAndGet()));
        ZooReaderWriter zk = szk.getZooReaderWriter();
        zk.mkdirs(parent.toString());
        ServiceLock zl = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
        Assertions.assertFalse((boolean)zl.isLocked());
        TestALW lw = new TestALW();
        zl.lock((ServiceLock.AccumuloLockWatcher)lw, "test1".getBytes(StandardCharsets.UTF_8));
        lw.waitForChanges(1);
        Assertions.assertTrue((boolean)lw.locked);
        Assertions.assertTrue((boolean)zl.isLocked());
        Assertions.assertNull((Object)lw.exception);
        Assertions.assertNull((Object)lw.reason);
        ServiceLock zl2 = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
        TestALW lw2 = new TestALW();
        zl2.lock((ServiceLock.AccumuloLockWatcher)lw2, "test2".getBytes(StandardCharsets.UTF_8));
        Assertions.assertFalse((boolean)lw2.locked);
        Assertions.assertFalse((boolean)zl2.isLocked());
        ServiceLock zl3 = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
        TestALW lw3 = new TestALW();
        zl3.lock((ServiceLock.AccumuloLockWatcher)lw3, "test3".getBytes(StandardCharsets.UTF_8));
        List children = ServiceLock.validateAndSort((ServiceLock.ServiceLockPath)parent, (List)zk.getChildren(parent.toString()));
        zk.delete(parent + "/" + (String)children.get(1));
        lw2.waitForChanges(1);
        Assertions.assertFalse((boolean)lw2.locked);
        Assertions.assertNotNull((Object)lw2.exception);
        Assertions.assertNull((Object)lw2.reason);
        zk.delete(parent + "/" + (String)children.get(0));
        lw.waitForChanges(2);
        Assertions.assertEquals((Object)ServiceLock.LockLossReason.LOCK_DELETED, (Object)lw.reason);
        Assertions.assertNull((Object)lw.exception);
        lw3.waitForChanges(1);
        Assertions.assertTrue((boolean)lw3.locked);
        Assertions.assertTrue((boolean)zl3.isLocked());
        Assertions.assertNull((Object)lw3.exception);
        Assertions.assertNull((Object)lw3.reason);
        zl3.unlock();
    }

    @Test
    @Timeout(value=10L)
    public void testUnexpectedEvent() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)("/zltestUnexpectedEvent-" + this.hashCode() + "-l" + pdCount.incrementAndGet()));
        ConnectedWatcher watcher = new ConnectedWatcher();
        try (ZooKeeper zk = new ZooKeeper(szk.getConn(), 30000, (Watcher)watcher);){
            ZooUtil.digestAuth((ZooKeeper)zk, (String)"secret");
            Wait.waitFor(() -> !watcher.isConnected(), 30000L, 200L);
            zk.create(parent.toString(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ServiceLock zl = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
            Assertions.assertFalse((boolean)zl.isLocked());
            zk.setData(parent.toString(), "foo".getBytes(StandardCharsets.UTF_8), -1);
            TestALW lw = new TestALW();
            zl.lock((ServiceLock.AccumuloLockWatcher)lw, "test1".getBytes(StandardCharsets.UTF_8));
            lw.waitForChanges(1);
            Assertions.assertTrue((boolean)lw.locked);
            Assertions.assertTrue((boolean)zl.isLocked());
            Assertions.assertNull((Object)lw.exception);
            Assertions.assertNull((Object)lw.reason);
            zk.setData(zl.getLockPath(), "bar".getBytes(StandardCharsets.UTF_8), -1);
            zk.delete(zl.getLockPath(), -1);
            lw.waitForChanges(2);
            Assertions.assertEquals((Object)ServiceLock.LockLossReason.LOCK_DELETED, (Object)lw.reason);
            Assertions.assertNull((Object)lw.exception);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testLockSerial() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)"/zlretryLockSerial");
        ConnectedWatcher watcher1 = new ConnectedWatcher();
        ConnectedWatcher watcher2 = new ConnectedWatcher();
        try (ZooKeeperWrapper zk1 = new ZooKeeperWrapper(szk.getConn(), 30000, watcher1);
             ZooKeeperWrapper zk2 = new ZooKeeperWrapper(szk.getConn(), 30000, watcher2);){
            ZooUtil.digestAuth((ZooKeeper)zk1, (String)"secret");
            ZooUtil.digestAuth((ZooKeeper)zk2, (String)"secret");
            Wait.waitFor(() -> !watcher1.isConnected(), 30000L, 200L);
            Wait.waitFor(() -> !watcher2.isConnected(), 30000L, 200L);
            zk1.createOnce(parent.toString(), new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            RetryLockWatcher zlw1 = new RetryLockWatcher();
            ServiceLock zl1 = ServiceLockIT.getZooLock(zk1, parent, UUID.fromString("00000000-0000-0000-0000-aaaaaaaaaaaa"));
            zl1.lock((ServiceLock.AccumuloLockWatcher)zlw1, "test1".getBytes(StandardCharsets.UTF_8));
            RetryLockWatcher zlw2 = new RetryLockWatcher();
            ServiceLock zl2 = ServiceLockIT.getZooLock(zk2, parent, UUID.fromString("00000000-0000-0000-0000-bbbbbbbbbbbb"));
            zl2.lock((ServiceLock.AccumuloLockWatcher)zlw2, "test1".getBytes(StandardCharsets.UTF_8));
            Assertions.assertTrue((boolean)zlw1.isLockHeld());
            Assertions.assertFalse((boolean)zlw2.isLockHeld());
            List children = zk1.getChildren(parent.toString(), false);
            Assertions.assertTrue((boolean)children.contains("zlock#00000000-0000-0000-0000-aaaaaaaaaaaa#0000000000"));
            Assertions.assertFalse((boolean)children.contains("zlock#00000000-0000-0000-0000-aaaaaaaaaaaa#0000000001"), (String)"this node should have been deleted");
            Assertions.assertTrue((boolean)children.contains("zlock#00000000-0000-0000-0000-bbbbbbbbbbbb#0000000002"));
            Assertions.assertFalse((boolean)children.contains("zlock#00000000-0000-0000-0000-bbbbbbbbbbbb#0000000003"), (String)"this node should have been deleted");
            Assertions.assertNull((Object)zl1.getWatching());
            Assertions.assertEquals((Object)"/zlretryLockSerial/zlock#00000000-0000-0000-0000-aaaaaaaaaaaa#0000000000", (Object)zl2.getWatching());
            zl1.unlock();
            Assertions.assertFalse((boolean)zlw1.isLockHeld());
            zk1.close();
            while (!zlw2.isLockHeld()) {
                LockSupport.parkNanos(50L);
            }
            Assertions.assertTrue((boolean)zlw2.isLockHeld());
            zl2.unlock();
        }
    }

    private int parseLockWorkerName(String child) {
        if (child.startsWith("zlock#00000000-0000-0000-0000-000000000000#")) {
            return 0;
        }
        if (child.startsWith("zlock#00000000-0000-0000-0000-111111111111#")) {
            return 1;
        }
        if (child.startsWith("zlock#00000000-0000-0000-0000-222222222222#")) {
            return 2;
        }
        if (child.startsWith("zlock#00000000-0000-0000-0000-333333333333#")) {
            return 3;
        }
        return -1;
    }

    @Test
    @Timeout(value=60L)
    public void testLockParallel() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)"/zlParallel");
        ConnectedWatcher watcher = new ConnectedWatcher();
        try (ZooKeeperWrapper zk = new ZooKeeperWrapper(szk.getConn(), 30000, watcher);){
            int i;
            ZooUtil.digestAuth((ZooKeeper)zk, (String)"secret");
            Wait.waitFor(() -> !watcher.isConnected(), 30000L, 50L);
            zk.createOnce(parent.toString(), new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            int numWorkers = 4;
            CountDownLatch getLockLatch = new CountDownLatch(numWorkers);
            CountDownLatch lockFinishedLatch = new CountDownLatch(numWorkers);
            ArrayList<LockWorker> workers = new ArrayList<LockWorker>(numWorkers);
            ArrayList<Thread> threads = new ArrayList<Thread>(numWorkers);
            for (i = 0; i < numWorkers; ++i) {
                UUID uuid = UUID.fromString("00000000-0000-0000-0000-aaaaaaaaaaaa".replaceAll("a", Integer.toString(i)));
                LockWorker w2 = new LockWorker(parent, uuid, getLockLatch, lockFinishedLatch);
                Thread t = new Thread(w2);
                workers.add(w2);
                threads.add(t);
                t.start();
            }
            workers.forEach(w -> Assertions.assertNull((Object)w.getException()));
            getLockLatch.await();
            workers.forEach(w -> Assertions.assertNull((Object)w.getException()));
            lockFinishedLatch.await();
            workers.forEach(w -> Assertions.assertNull((Object)w.getException()));
            for (i = 4; i > 0; --i) {
                List children = ServiceLock.validateAndSort((ServiceLock.ServiceLockPath)parent, (List)zk.getChildren(parent.toString(), null));
                while (children.size() != i) {
                    Thread.sleep(100L);
                    children = zk.getChildren(parent.toString(), false);
                }
                Assertions.assertEquals((int)i, (int)children.size());
                String first = (String)children.get(0);
                int workerWithLock = this.parseLockWorkerName(first);
                LockWorker worker = (LockWorker)workers.get(workerWithLock);
                Assertions.assertTrue((boolean)worker.holdsLock());
                workers.forEach(w -> {
                    if (w != worker) {
                        Assertions.assertFalse((boolean)w.holdsLock());
                    }
                });
                worker.unlock();
                Thread.sleep(100L);
            }
            workers.forEach(w -> Assertions.assertFalse((boolean)w.holdsLock()));
            workers.forEach(w -> Assertions.assertNull((Object)w.getException()));
            Assertions.assertEquals((int)0, (int)zk.getChildren(parent.toString(), false).size());
            threads.forEach(Uninterruptibles::joinUninterruptibly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testTryLock() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)("/zltestTryLock-" + this.hashCode() + "-l" + pdCount.incrementAndGet()));
        ServiceLock zl = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
        ConnectedWatcher watcher = new ConnectedWatcher();
        try (ZooKeeper zk = new ZooKeeper(szk.getConn(), 30000, (Watcher)watcher);){
            ZooUtil.digestAuth((ZooKeeper)zk, (String)"secret");
            Wait.waitFor(() -> !watcher.isConnected(), 30000L, 200L);
            for (int i = 0; i < 10; ++i) {
                zk.create(parent.toString(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.delete(parent.toString(), -1);
            }
            zk.create(parent.toString(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            TestALW lw = new TestALW();
            boolean ret = zl.tryLock((ServiceLock.LockWatcher)lw, "test1".getBytes(StandardCharsets.UTF_8));
            Assertions.assertTrue((boolean)ret);
            ServiceLock serviceLock = zl;
            synchronized (serviceLock) {
                Field field = zl.getClass().getDeclaredField("watchingParent");
                field.setAccessible(true);
                Assertions.assertTrue((boolean)((Boolean)field.get(zl)));
            }
            zl.unlock();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testChangeData() throws Exception {
        ServiceLock.ServiceLockPath parent = ServiceLock.path((String)("/zltestChangeData-" + this.hashCode() + "-l" + pdCount.incrementAndGet()));
        ConnectedWatcher watcher = new ConnectedWatcher();
        try (ZooKeeper zk = new ZooKeeper(szk.getConn(), 30000, (Watcher)watcher);){
            ZooUtil.digestAuth((ZooKeeper)zk, (String)"secret");
            Wait.waitFor(() -> !watcher.isConnected(), 30000L, 200L);
            zk.create(parent.toString(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ServiceLock zl = ServiceLockIT.getZooLock(parent, UUID.randomUUID());
            TestALW lw = new TestALW();
            zl.lock((ServiceLock.AccumuloLockWatcher)lw, "test1".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"test1", (Object)new String(zk.getData(zl.getLockPath(), null, null)));
            zl.replaceLockData("test2".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"test2", (Object)new String(zk.getData(zl.getLockPath(), null, null)));
        }
    }

    static {
        szk = null;
        pdCount = new AtomicInteger(0);
    }

    private static class ServiceLockWrapper
    extends ServiceLock {
        protected ServiceLockWrapper(ZooKeeper zookeeper, ServiceLock.ServiceLockPath path, UUID uuid) {
            super(zookeeper, path, uuid);
        }
    }

    static class TestALW
    implements ServiceLock.AccumuloLockWatcher {
        ServiceLock.LockLossReason reason = null;
        boolean locked = false;
        Exception exception = null;
        int changes = 0;

        TestALW() {
        }

        public synchronized void lostLock(ServiceLock.LockLossReason reason) {
            this.reason = reason;
            ++this.changes;
            this.notifyAll();
        }

        public synchronized void acquiredLock() {
            this.locked = true;
            ++this.changes;
            this.notifyAll();
        }

        public synchronized void failedToAcquireLock(Exception e) {
            this.exception = e;
            ++this.changes;
            this.notifyAll();
        }

        public synchronized void waitForChanges(int numExpected) throws InterruptedException {
            while (this.changes < numExpected) {
                this.wait();
            }
        }

        public synchronized void unableToMonitorLockNode(Exception e) {
            ++this.changes;
            this.notifyAll();
        }
    }

    static class ConnectedWatcher
    implements Watcher {
        volatile boolean connected = false;

        ConnectedWatcher() {
        }

        public synchronized void process(WatchedEvent event) {
            this.connected = event.getState() == Watcher.Event.KeeperState.SyncConnected;
        }

        public synchronized boolean isConnected() {
            return this.connected;
        }
    }

    static class ZooKeeperWrapper
    extends ZooKeeper {
        public ZooKeeperWrapper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
            super(connectString, sessionTimeout, watcher);
        }

        public void createOnce(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
            super.create(path, data, acl, createMode);
        }

        public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
            super.create(path, data, acl, createMode);
            return super.create(path, data, acl, createMode);
        }
    }

    static class RetryLockWatcher
    implements ServiceLock.AccumuloLockWatcher {
        private boolean lockHeld = false;

        RetryLockWatcher() {
        }

        public void lostLock(ServiceLock.LockLossReason reason) {
            this.lockHeld = false;
        }

        public void unableToMonitorLockNode(Exception e) {
        }

        public void acquiredLock() {
            this.lockHeld = true;
        }

        public void failedToAcquireLock(Exception e) {
            this.lockHeld = false;
        }

        public boolean isLockHeld() {
            return this.lockHeld;
        }
    }

    static class LockWorker
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(LockWorker.class);
        private final ServiceLock.ServiceLockPath parent;
        private final UUID uuid;
        private final CountDownLatch getLockLatch;
        private final CountDownLatch lockCompletedLatch;
        private final CountDownLatch unlockLatch = new CountDownLatch(1);
        private final RetryLockWatcher lockWatcher = new RetryLockWatcher();
        private volatile Exception ex = null;

        public LockWorker(ServiceLock.ServiceLockPath parent, UUID uuid, CountDownLatch lockLatch, CountDownLatch lockCompletedLatch) {
            this.parent = parent;
            this.uuid = uuid;
            this.getLockLatch = lockLatch;
            this.lockCompletedLatch = lockCompletedLatch;
        }

        public void unlock() {
            this.unlockLatch.countDown();
        }

        public boolean holdsLock() {
            return this.lockWatcher.isLockHeld();
        }

        @Override
        public void run() {
            try {
                ConnectedWatcher watcher = new ConnectedWatcher();
                try (ZooKeeperWrapper zk = new ZooKeeperWrapper(szk.getConn(), 30000, watcher);){
                    ZooUtil.digestAuth((ZooKeeper)zk, (String)"secret");
                    Wait.waitFor(() -> !watcher.isConnected(), 30000L, 50L);
                    ServiceLock zl = ServiceLockIT.getZooLock(zk, this.parent, this.uuid);
                    this.getLockLatch.countDown();
                    this.getLockLatch.await();
                    zl.lock((ServiceLock.AccumuloLockWatcher)this.lockWatcher, "test1".getBytes(StandardCharsets.UTF_8));
                    this.lockCompletedLatch.countDown();
                    this.unlockLatch.await();
                    zl.unlock();
                }
            }
            catch (Exception e) {
                LOG.error("Error in LockWorker.run() for {}", (Object)this.uuid, (Object)e);
                this.ex = e;
            }
        }

        public Throwable getException() {
            return this.ex;
        }

        public String toString() {
            return "LockWorker [name=" + this.uuid + ", holdsLock()=" + this.holdsLock() + "]";
        }
    }
}

