/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.fate.zookeeper;

import com.google.common.hash.Hashing;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.harness.WithTestNames;
import org.apache.accumulo.test.zookeeper.ZooKeeperTestingServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="ZooKeeperTestingServer")
public class ZooMutatorIT
extends WithTestNames {
    @TempDir
    private static File tempDir;

    @Test
    public void concurrentMutatorTest() throws Exception {
        File newFolder = new File(tempDir, this.testName() + "/");
        Assertions.assertTrue((newFolder.isDirectory() || newFolder.mkdir() ? 1 : 0) != 0, (String)("failed to create dir: " + newFolder));
        try (ZooKeeperTestingServer szk = new ZooKeeperTestingServer(newFolder);){
            szk.initPaths("/accumulo/" + InstanceId.of((UUID)UUID.randomUUID()));
            ZooReaderWriter zk = szk.getZooReaderWriter();
            ExecutorService executor = Executors.newFixedThreadPool(16);
            String initialData = this.hash("Accumulo Zookeeper Mutator test data") + " 0";
            ArrayList futures = new ArrayList();
            ConcurrentHashMap countCounts = new ConcurrentHashMap();
            for (int i = 0; i < 16; ++i) {
                futures.add(executor.submit(() -> {
                    try {
                        int count = -1;
                        while (count < 200) {
                            byte[] val = zk.mutateOrCreate("/test-zm", initialData.getBytes(StandardCharsets.UTF_8), this::nextValue);
                            int nextCount = this.getCount(val);
                            Assertions.assertTrue((nextCount > count ? 1 : 0) != 0, (String)("nextCount <= count " + nextCount + " " + count));
                            count = nextCount;
                            countCounts.merge(count, 1, Integer::sum);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            executor.shutdown();
            byte[] actual = zk.getData("/test-zm");
            int n = this.getCount(actual);
            Assertions.assertTrue((n >= 200 ? 1 : 0) != 0);
            Object expected = initialData;
            Assertions.assertEquals((int)1, (int)((Integer)countCounts.get(0)));
            for (int i = 1; i <= n; ++i) {
                Assertions.assertEquals((int)1, (int)((Integer)countCounts.get(i)));
                expected = this.nextValue((String)expected);
            }
            Assertions.assertEquals((int)(n + 1), (int)countCounts.size());
            Assertions.assertEquals((Object)expected, (Object)new String(actual, StandardCharsets.UTF_8));
        }
    }

    private String hash(String data) {
        return Hashing.sha256().hashString((CharSequence)data, StandardCharsets.UTF_8).toString();
    }

    private String nextValue(String currString) {
        String[] tokens = currString.split(" ");
        String currHash = tokens[0];
        int count = Integer.parseInt(tokens[1]);
        return this.hash(currHash) + " " + (count + 1);
    }

    private byte[] nextValue(byte[] curr) {
        return this.nextValue(new String(curr, StandardCharsets.UTF_8)).getBytes(StandardCharsets.UTF_8);
    }

    private int getCount(byte[] val) {
        return Integer.parseInt(new String(val, StandardCharsets.UTF_8).split(" ")[1]);
    }
}

