/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AccumuloClientIT
extends AccumuloClusterHarness {
    @AfterEach
    public void deleteUsers() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloClientIT.getClientProps()).build();){
            Set users = client.securityOperations().listLocalUsers();
            ClusterUser user1 = this.getUser(0);
            ClusterUser user2 = this.getUser(1);
            if (users.contains(user1.getPrincipal())) {
                client.securityOperations().dropLocalUser(user1.getPrincipal());
            }
            if (users.contains(user2.getPrincipal())) {
                client.securityOperations().dropLocalUser(user2.getPrincipal());
            }
        }
    }

    private static void expectClosed(CloseCheck cc) {
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, cc::check);
        Assertions.assertTrue((boolean)e.getMessage().toLowerCase().contains("closed"));
    }

    @Test
    public void testGetConnectorFromAccumuloClient() throws Exception {
        AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(AccumuloClientIT.getClientProps()).build();
        Connector c = Connector.from((AccumuloClient)client);
        Assertions.assertEquals((Object)client.whoami(), (Object)c.whoami());
        client.close();
        AccumuloClientIT.expectClosed(() -> ((Connector)c).tableOperations());
    }

    @Test
    public void testGetAccumuloClientFromConnector() throws Exception {
        try (AccumuloClient client1 = (AccumuloClient)Accumulo.newClient().from(AccumuloClientIT.getClientProps()).build();){
            Connector c = Connector.from((AccumuloClient)client1);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (AccumuloClient client2 = Connector.newClient((Connector)c);){
                Assertions.assertTrue((boolean)client2.tableOperations().list().contains(tableName));
            }
            Assertions.assertTrue((boolean)client1.tableOperations().list().contains(tableName));
            Assertions.assertTrue((boolean)c.tableOperations().list().contains(tableName));
        }
    }

    @Test
    public void testAccumuloClientBuilder() throws Exception {
        AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloClientIT.getClientProps()).build();
        String instanceName = AccumuloClientIT.getClientInfo().getInstanceName();
        String zookeepers = AccumuloClientIT.getClientInfo().getZooKeepers();
        ClusterUser testuser1 = this.getUser(0);
        String user1 = testuser1.getPrincipal();
        String password1 = testuser1.getPassword();
        c.securityOperations().createLocalUser(user1, new PasswordToken((CharSequence)password1));
        AccumuloClient client = (AccumuloClient)Accumulo.newClient().to((CharSequence)instanceName, (CharSequence)zookeepers).as((CharSequence)user1, (CharSequence)password1).zkTimeout(1234).build();
        Properties props = client.properties();
        Assertions.assertFalse((boolean)props.containsKey(ClientProperty.AUTH_TOKEN.getKey()));
        ClientInfo info = ClientInfo.from((Properties)client.properties());
        Assertions.assertEquals((Object)instanceName, (Object)info.getInstanceName());
        Assertions.assertEquals((Object)zookeepers, (Object)info.getZooKeepers());
        Assertions.assertEquals((Object)user1, (Object)client.whoami());
        Assertions.assertEquals((int)1234, (int)info.getZooKeepersSessionTimeOut());
        props = (Properties)Accumulo.newClientProperties().to((CharSequence)instanceName, (CharSequence)zookeepers).as((CharSequence)user1, (CharSequence)password1).build();
        Assertions.assertTrue((boolean)props.containsKey(ClientProperty.AUTH_TOKEN.getKey()));
        Assertions.assertEquals((Object)password1, (Object)props.get(ClientProperty.AUTH_TOKEN.getKey()));
        Assertions.assertEquals((Object)"password", (Object)props.get(ClientProperty.AUTH_TYPE.getKey()));
        Assertions.assertEquals((Object)instanceName, (Object)props.getProperty(ClientProperty.INSTANCE_NAME.getKey()));
        info = ClientInfo.from((Properties)props);
        Assertions.assertEquals((Object)instanceName, (Object)info.getInstanceName());
        Assertions.assertEquals((Object)zookeepers, (Object)info.getZooKeepers());
        Assertions.assertEquals((Object)user1, (Object)info.getPrincipal());
        Assertions.assertTrue((boolean)(info.getAuthenticationToken() instanceof PasswordToken));
        props = new Properties();
        props.put(ClientProperty.INSTANCE_NAME.getKey(), instanceName);
        props.put(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), zookeepers);
        props.put(ClientProperty.AUTH_PRINCIPAL.getKey(), user1);
        props.put(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.getKey(), "22s");
        ClientProperty.setPassword((Properties)props, (CharSequence)password1);
        client.close();
        client = (AccumuloClient)Accumulo.newClient().from(props).build();
        info = ClientInfo.from((Properties)client.properties());
        Assertions.assertEquals((Object)instanceName, (Object)info.getInstanceName());
        Assertions.assertEquals((Object)zookeepers, (Object)info.getZooKeepers());
        Assertions.assertEquals((Object)user1, (Object)client.whoami());
        Assertions.assertEquals((int)22000, (int)info.getZooKeepersSessionTimeOut());
        ClusterUser testuser2 = this.getUser(1);
        String user2 = testuser2.getPrincipal();
        String password2 = testuser2.getPassword();
        c.securityOperations().createLocalUser(user2, new PasswordToken((CharSequence)password2));
        AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(client.properties()).as((CharSequence)user2, (AuthenticationToken)new PasswordToken((CharSequence)password2)).build();
        info = ClientInfo.from((Properties)client2.properties());
        Assertions.assertEquals((Object)instanceName, (Object)info.getInstanceName());
        Assertions.assertEquals((Object)zookeepers, (Object)info.getZooKeepers());
        Assertions.assertEquals((Object)user2, (Object)client2.whoami());
        Assertions.assertEquals((Object)user2, (Object)info.getPrincipal());
        c.close();
        client.close();
        client2.close();
    }

    @Test
    public void testClose() throws Exception {
        Scanner scanner;
        String tableName = this.getUniqueNames(1)[0];
        Assertions.assertEquals((long)0L, (long)SingletonManager.getReservationCount());
        Assertions.assertEquals((Object)SingletonManager.Mode.CLIENT, (Object)SingletonManager.getMode());
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(AccumuloClientIT.getClientProps()).build();){
            Assertions.assertEquals((long)1L, (long)SingletonManager.getReservationCount());
            c.tableOperations().create(tableName);
            try (BatchWriter writer = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"0001");
                m.at().family((CharSequence)"f007").qualifier((CharSequence)"q4").put((CharSequence)"j");
                writer.addMutation(m);
            }
            scanner = c.createScanner(tableName, Authorizations.EMPTY);
        }
        AccumuloClientIT.expectClosed(() -> scanner.iterator().next());
        Assertions.assertEquals((long)0L, (long)SingletonManager.getReservationCount());
        c = (AccumuloClient)Accumulo.newClient().from(AccumuloClientIT.getClientProps()).build();
        Assertions.assertEquals((long)1L, (long)SingletonManager.getReservationCount());
        Scanner scanner2 = c.createScanner(tableName, Authorizations.EMPTY);
        Map.Entry<Key, Value> e = this.getOnlyElement(scanner2);
        Assertions.assertEquals((Object)"0001", (Object)e.getKey().getRowData().toString());
        Assertions.assertEquals((Object)"f007", (Object)e.getKey().getColumnFamilyData().toString());
        Assertions.assertEquals((Object)"q4", (Object)e.getKey().getColumnQualifierData().toString());
        Assertions.assertEquals((Object)"j", (Object)e.getValue().toString());
        TableOperations tops = c.tableOperations();
        c.close();
        Assertions.assertEquals((long)0L, (long)SingletonManager.getReservationCount());
        AccumuloClientIT.expectClosed(() -> c.createScanner(tableName, Authorizations.EMPTY));
        AccumuloClientIT.expectClosed(() -> c.createConditionalWriter(tableName));
        AccumuloClientIT.expectClosed(() -> c.createBatchWriter(tableName));
        AccumuloClientIT.expectClosed(() -> ((AccumuloClient)c).tableOperations());
        AccumuloClientIT.expectClosed(() -> ((AccumuloClient)c).instanceOperations());
        AccumuloClientIT.expectClosed(() -> ((AccumuloClient)c).securityOperations());
        AccumuloClientIT.expectClosed(() -> ((AccumuloClient)c).namespaceOperations());
        AccumuloClientIT.expectClosed(() -> ((AccumuloClient)c).properties());
        AccumuloClientIT.expectClosed(() -> c.instanceOperations().getInstanceId());
        AccumuloClientIT.expectClosed(() -> tops.create("expectFail"));
        AccumuloClientIT.expectClosed(() -> tops.cancelCompaction(tableName));
        AccumuloClientIT.expectClosed(() -> tops.listSplits(tableName));
    }

    private static interface CloseCheck {
        public void check() throws Exception;
    }
}

