/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.List;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.junit.jupiter.api.Test;

public class BackupManagerIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        UtilWaitThread.sleep((long)1000L);
        Process backup = this.exec(Manager.class, new String[0]);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ServiceLock.ServiceLockPath path;
            List children;
            ZooReaderWriter writer = this.getCluster().getServerContext().getZooReaderWriter();
            String root = "/accumulo/" + client.instanceOperations().getInstanceId();
            do {
                UtilWaitThread.sleep((long)100L);
            } while ((children = ServiceLock.validateAndSort((ServiceLock.ServiceLockPath)(path = ServiceLock.path((String)(root + "/managers/lock"))), (List)writer.getChildren(path.toString()))).size() != 2);
            UtilWaitThread.sleep((long)1000L);
            String lockPath = root + "/managers/lock/" + (String)children.get(0);
            byte[] data = writer.getData(lockPath);
            writer.getZooKeeper().setData(lockPath, data, -1);
            UtilWaitThread.sleep((long)500L);
            writer.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.FAIL);
            client.tableOperations().create(this.getUniqueNames(1)[0]);
        }
        finally {
            backup.destroy();
        }
    }
}

