/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.BadIterator;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BadIteratorMincIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BadIteratorMincIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            IteratorSetting is = new IteratorSetting(30, BadIterator.class);
            c.tableOperations().attachIterator(tableName, is, EnumSet.of(IteratorUtil.IteratorScope.minc));
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation(new Text("r1"));
                m.put((CharSequence)"acf", (CharSequence)tableName, (CharSequence)"1");
                bw.addMutation(m);
            }
            c.tableOperations().flush(tableName, null, null, false);
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 0, 0);
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                int count = Iterators.size((Iterator)scanner.iterator());
                Assertions.assertEquals((int)1, (int)count, (String)("Did not see expected # entries " + count));
                c.tableOperations().removeIterator(tableName, BadIterator.class.getSimpleName(), EnumSet.of(IteratorUtil.IteratorScope.minc));
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
                FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 1, 1);
                count = Iterators.size((Iterator)scanner.iterator());
                if (count != 1) {
                    throw new Exception("Did not see expected # entries " + count);
                }
                c.tableOperations().attachIterator(tableName, is, EnumSet.of(IteratorUtil.IteratorScope.minc));
                try (BatchWriter bw = c.createBatchWriter(tableName);){
                    Mutation m = new Mutation(new Text("r2"));
                    m.put((CharSequence)"acf", (CharSequence)tableName, (CharSequence)"1");
                    bw.addMutation(m);
                }
                UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                c.tableOperations().flush(tableName, null, null, false);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                c.tableOperations().delete(tableName);
            }
        }
    }
}

