/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BadLocalityGroupMincIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BadLocalityGroupMincIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "g1", "fam1,fam2");
            c.tableOperations().setProperty(tableName, Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "g2", "fam2,fam3");
            c.tableOperations().setProperty(tableName, Property.TABLE_LOCALITY_GROUPS.getKey(), "g1,g2");
            c.tableOperations().offline(tableName, true);
            c.tableOperations().online(tableName, true);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation(new Text("r1"));
                m.put((CharSequence)"acf", (CharSequence)tableName, (CharSequence)"1");
                bw.addMutation(m);
            }
            FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 0, 0);
            c.tableOperations().flush(tableName, null, null, true);
            FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 1, 1);
            Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);
            Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
            Assertions.assertEquals((Object)"r1", (Object)entry.getKey().getRowData().toString());
            Assertions.assertEquals((Object)"acf", (Object)entry.getKey().getColumnFamilyData().toString());
            Assertions.assertEquals((Object)tableName, (Object)entry.getKey().getColumnQualifierData().toString());
            Assertions.assertEquals((Object)"1", (Object)entry.getValue().toString());
            c.tableOperations().delete(tableName);
        }
    }
}

