/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BalanceAfterCommsFailureIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.GENERAL_RPC_TIMEOUT, "2s");
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.tableOperations().create("test");
            Collection tservers = (Collection)this.getCluster().getProcesses().get(ServerType.TABLET_SERVER);
            ArrayList<Integer> tserverPids = new ArrayList<Integer>(tservers.size());
            for (ProcessReference tserver : tservers) {
                Process p = tserver.getProcess();
                if (!p.getClass().getName().equals("java.lang.UNIXProcess")) {
                    log.info("Found process that was not UNIXProcess, exiting test");
                    return;
                }
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                tserverPids.add(f.getInt(p));
            }
            Iterator iterator = tserverPids.iterator();
            while (iterator.hasNext()) {
                int pid = (Integer)iterator.next();
                Assertions.assertEquals((int)0, (int)Runtime.getRuntime().exec(new String[]{"kill", "-SIGSTOP", Integer.toString(pid)}).waitFor());
            }
            UtilWaitThread.sleep((long)20000L);
            iterator = tserverPids.iterator();
            while (iterator.hasNext()) {
                int pid = (Integer)iterator.next();
                Assertions.assertEquals((int)0, (int)Runtime.getRuntime().exec(new String[]{"kill", "-SIGCONT", Integer.toString(pid)}).waitFor());
            }
            TreeSet<Text> splits = new TreeSet<Text>();
            for (String split : "a b c d e f g h i j k l m n o p q r s t u v w x y z".split(" ")) {
                splits.add(new Text(split));
            }
            c.tableOperations().addSplits("test", splits);
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)c.createScanner("test", Authorizations.EMPTY)));
            UtilWaitThread.sleep((long)30000L);
            this.checkBalance(c);
        }
    }

    private void checkBalance(AccumuloClient c) throws Exception {
        ClientContext context = (ClientContext)c;
        ManagerMonitorInfo stats = null;
        int unassignedTablets = 1;
        for (int i = 0; unassignedTablets > 0 && i < 10; ++i) {
            stats = (ManagerMonitorInfo)ThriftClientTypes.MANAGER.execute(context, client -> client.getManagerStats(TraceUtil.traceInfo(), context.rpcCreds()));
            unassignedTablets = stats.getUnassignedTablets();
            if (unassignedTablets <= 0) continue;
            log.info("Found {} unassigned tablets, sleeping 3 seconds for tablet assignment", (Object)unassignedTablets);
            Thread.sleep(3000L);
        }
        Assertions.assertEquals((int)0, (int)unassignedTablets, (String)"Unassigned tablets were not assigned within 30 seconds");
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (TabletServerStatus server : stats.tServerInfo) {
            int count = 0;
            for (TableInfo table : server.tableMap.values()) {
                count += table.onlineTablets;
            }
            counts.add(count);
        }
        Assertions.assertTrue((counts.size() > 1 ? 1 : 0) != 0, (String)"Expected to have at least two TabletServers");
        for (int i = 1; i < counts.size(); ++i) {
            int diff = Math.abs((Integer)counts.get(0) - (Integer)counts.get(i));
            Assertions.assertTrue((diff <= counts.size() ? 1 : 0) != 0, (String)("Expected difference in tablets to be less than or equal to " + counts.size() + " but was " + diff + ". Counts " + counts));
        }
    }
}

