/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceInPresenceOfOfflineTableIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(BalanceInPresenceOfOfflineTableIT.class);
    private static final int NUM_SPLITS = 200;
    private String UNUSED_TABLE;
    private String TEST_TABLE;
    private AccumuloClient accumuloClient;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAXMEM.getKey(), "10K");
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
        siteConfig.put(Property.GENERAL_MICROMETER_ENABLED.getKey(), "true");
        siteConfig.put("general.custom.metrics.opts.logging.step", "0.5s");
        cfg.setSiteConfig(siteConfig);
        if (cfg.getNumTservers() < 2) {
            cfg.setNumTservers(2);
        }
    }

    @BeforeEach
    public void setupTables() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException {
        this.accumuloClient = (AccumuloClient)Accumulo.newClient().from(BalanceInPresenceOfOfflineTableIT.getClientProps()).build();
        for (int retries = 0; retries < 5 && this.accumuloClient.instanceOperations().getTabletServers().size() < 2; ++retries) {
            UtilWaitThread.sleep((long)TimeUnit.SECONDS.toMillis(2L));
        }
        Assumptions.assumeTrue((this.accumuloClient.instanceOperations().getTabletServers().size() >= 2 ? 1 : 0) != 0, (String)"Not enough tservers to run test");
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < 200; ++i) {
            splits.add(new Text(String.format("%08x", i * 1000)));
        }
        String[] names = this.getUniqueNames(2);
        this.UNUSED_TABLE = names[0];
        this.TEST_TABLE = names[1];
        this.accumuloClient.tableOperations().create(this.UNUSED_TABLE);
        this.accumuloClient.tableOperations().addSplits(this.UNUSED_TABLE, splits);
        this.accumuloClient.tableOperations().offline(this.UNUSED_TABLE);
        this.accumuloClient.tableOperations().create(this.TEST_TABLE);
        this.accumuloClient.tableOperations().setProperty(this.TEST_TABLE, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
    }

    @AfterEach
    public void closeClient() {
        this.accumuloClient.close();
    }

    @Test
    public void test() throws Exception {
        log.info("Test that balancing is not stopped by an offline table with outstanding migrations.");
        log.debug("starting test ingestion");
        VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(BalanceInPresenceOfOfflineTableIT.getClientProps(), this.TEST_TABLE, 200000);
        TestIngest.ingest(this.accumuloClient, params);
        this.accumuloClient.tableOperations().flush(this.TEST_TABLE, null, null, true);
        VerifyIngest.verifyIngest(this.accumuloClient, params);
        log.debug("waiting for balancing, up to ~5 minutes to allow for migration cleanup.");
        long startTime = System.currentTimeMillis();
        long currentWait = 10000L;
        boolean balancingWorked = false;
        Credentials creds = new Credentials(BalanceInPresenceOfOfflineTableIT.getAdminPrincipal(), BalanceInPresenceOfOfflineTableIT.getAdminToken());
        while (!balancingWorked && System.currentTimeMillis() - startTime < 315000L) {
            Thread.sleep(currentWait);
            currentWait *= 2L;
            log.debug("fetch the list of tablets assigned to each tserver.");
            ManagerMonitorInfo stats = (ManagerMonitorInfo)ThriftClientTypes.MANAGER.execute((ClientContext)this.accumuloClient, client -> client.getManagerStats(TraceUtil.traceInfo(), creds.toThrift(this.accumuloClient.instanceOperations().getInstanceId())));
            if (stats.getTServerInfoSize() < 2) {
                log.debug("we need >= 2 servers. sleeping for {}ms", (Object)currentWait);
                continue;
            }
            if (stats.getUnassignedTablets() != 0) {
                log.debug("We shouldn't have unassigned tablets. sleeping for {}ms", (Object)currentWait);
                continue;
            }
            long[] tabletsPerServer = new long[stats.getTServerInfoSize()];
            Arrays.fill(tabletsPerServer, 0L);
            for (int i = 0; i < stats.getTServerInfoSize(); ++i) {
                for (Map.Entry entry : ((TabletServerStatus)stats.getTServerInfo().get(i)).getTableMap().entrySet()) {
                    int n = i;
                    tabletsPerServer[n] = tabletsPerServer[n] + (long)((TableInfo)entry.getValue()).getTablets();
                }
            }
            if (tabletsPerServer[0] <= 10L) {
                log.debug("We should have > 10 tablets. sleeping for {}ms", (Object)currentWait);
                continue;
            }
            long min = NumberUtils.min((long[])tabletsPerServer);
            long max = NumberUtils.max((long[])tabletsPerServer);
            log.debug("Min={}, Max={}", (Object)min, (Object)max);
            if ((double)min / (double)max < 0.5) {
                log.debug("ratio of min to max tablets per server should be roughly even. sleeping for {}ms", (Object)currentWait);
                continue;
            }
            balancingWorked = true;
        }
        Assertions.assertTrue((boolean)balancingWorked, (String)"did not properly balance");
    }
}

