/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BigRootTabletIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TABLE_SCAN_MAXMEM.getKey(), "1024");
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "60m");
        cfg.setSiteConfig(siteConfig);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BigRootTabletIT.getClientProps()).build();){
            String[] names;
            c.tableOperations().addSplits(MetadataTable.NAME, FunctionalTestUtils.splits("0 1 2 3 4 5 6 7 8 9 a".split(" ")));
            for (String name : names = this.getUniqueNames(10)) {
                c.tableOperations().create(name);
                c.tableOperations().flush(MetadataTable.NAME, null, null, true);
                c.tableOperations().flush(RootTable.NAME, null, null, true);
            }
            cluster.stop();
            cluster.start();
            Assertions.assertTrue((boolean)c.createScanner(RootTable.NAME, Authorizations.EMPTY).stream().findAny().isPresent());
        }
    }
}

