/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestBinaryRows;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Test;

public class BinaryIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(90L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BinaryIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            BinaryIT.runTest(c, tableName);
        }
    }

    @Test
    public void testPreSplit() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BinaryIT.getClientProps()).build();){
            TreeSet<Text> splits = new TreeSet<Text>();
            splits.add(new Text("8"));
            splits.add(new Text("256"));
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(splits);
            c.tableOperations().create(tableName, ntc);
            BinaryIT.runTest(c, tableName);
        }
    }

    public static void runTest(AccumuloClient c, String tableName) throws Exception {
        TestBinaryRows.Opts opts = new TestBinaryRows.Opts();
        opts.tableName = tableName;
        opts.start = 0L;
        opts.num = 100000L;
        opts.mode = "ingest";
        TestBinaryRows.runTest(c, opts);
        opts.mode = "verify";
        TestBinaryRows.runTest(c, opts);
        opts.start = 25000L;
        opts.num = 50000L;
        opts.mode = "delete";
        TestBinaryRows.runTest(c, opts);
        opts.start = 0L;
        opts.num = 25000L;
        opts.mode = "verify";
        TestBinaryRows.runTest(c, opts);
        opts.start = 75000L;
        opts.num = 25000L;
        opts.mode = "randomLookups";
        TestBinaryRows.runTest(c, opts);
        opts.start = 25000L;
        opts.num = 50000L;
        opts.mode = "verifyDeleted";
        TestBinaryRows.runTest(c, opts);
    }
}

