/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.BinaryIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BinaryStressIT
extends AccumuloClusterHarness {
    private String majcDelay;
    private String maxMem;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_MAXMEM, "50K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "50ms");
    }

    @BeforeEach
    public void alterConfig() throws Exception {
        if (BinaryStressIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI) {
            return;
        }
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BinaryStressIT.getClientProps()).build();){
            InstanceOperations iops = client.instanceOperations();
            Map conf = iops.getSystemConfiguration();
            this.majcDelay = (String)conf.get(Property.TSERV_MAJC_DELAY.getKey());
            this.maxMem = (String)conf.get(Property.TSERV_MAXMEM.getKey());
            iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
            iops.setProperty(Property.TSERV_MAXMEM.getKey(), "50K");
            BinaryStressIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            BinaryStressIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    @AfterEach
    public void resetConfig() throws Exception {
        if (this.majcDelay != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BinaryStressIT.getClientProps()).build();){
                InstanceOperations iops = client.instanceOperations();
                iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
                iops.setProperty(Property.TSERV_MAXMEM.getKey(), this.maxMem);
            }
            BinaryStressIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            BinaryStressIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    @Test
    public void binaryStressTest() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BinaryStressIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
            BinaryIT.runTest(c, tableName);
            String id = (String)c.tableOperations().tableIdMap().get(tableName);
            HashSet<Text> tablets = new HashSet<Text>();
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(Range.prefix((CharSequence)id));
                for (Map.Entry entry : s) {
                    tablets.add(((Key)entry.getKey()).getRow());
                }
            }
            Assertions.assertTrue((tablets.size() > 7 ? 1 : 0) != 0, (String)("Expected at least 8 tablets, saw " + tablets.size()));
        }
    }
}

