/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.MapFileInfo;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.manager.tableOps.bulkVer1.BulkImport;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BulkFailureIT
extends AccumuloClusterHarness {
    @Test
    public void testImportCompactionImport() throws Exception {
        String[] tables = this.getUniqueNames(2);
        this.runTest(tables[0], 99999999L, BulkFailureIT::oldLoad);
        this.runTest(tables[1], 22222222L, BulkFailureIT::newLoad);
    }

    protected void runTest(String table, long fateTxid, Loader loader) throws IOException, AccumuloException, AccumuloSecurityException, TableExistsException, KeeperException, InterruptedException, Exception, FileNotFoundException, TableNotFoundException {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkFailureIT.getClientProps()).build();){
            SortedMap<Key, Value> testData = this.createTestData();
            FileSystem fs = BulkFailureIT.getCluster().getFileSystem();
            String testFile = this.createTestFile(fateTxid, testData, fs);
            c.tableOperations().create(table);
            String tableId = (String)c.tableOperations().tableIdMap().get(table);
            KeyExtent extent = new KeyExtent(TableId.of((String)tableId), null, null);
            ServerContext asCtx = BulkFailureIT.getServerContext();
            TransactionWatcher.ZooArbitrator.start((ServerContext)asCtx, (String)"bulkTx", (long)fateTxid);
            VolumeManager vm = asCtx.getVolumeManager();
            String bulkDir = BulkImport.prepareBulkImport((ServerContext)asCtx, (VolumeManager)vm, (String)testFile, (TableId)TableId.of((String)tableId), (long)fateTxid);
            FileStatus status = fs.listStatus(new Path(bulkDir))[0];
            Path bulkLoadPath = fs.makeQualified(status.getPath());
            loader.load(fateTxid, (ClientContext)asCtx, extent, bulkLoadPath, status.getLen(), false);
            Assertions.assertEquals(Set.of(bulkLoadPath), BulkFailureIT.getFiles(c, extent));
            Assertions.assertEquals(Set.of(bulkLoadPath), BulkFailureIT.getLoaded(c, extent));
            Assertions.assertEquals(testData, this.readTable(table, c));
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            Set<Path> tabletFiles = BulkFailureIT.getFiles(c, extent);
            Assertions.assertFalse((boolean)tabletFiles.contains(bulkLoadPath));
            Assertions.assertEquals((int)1, (int)tabletFiles.size());
            Assertions.assertEquals(Set.of(bulkLoadPath), BulkFailureIT.getLoaded(c, extent));
            Assertions.assertEquals(testData, this.readTable(table, c));
            loader.load(fateTxid, (ClientContext)asCtx, extent, bulkLoadPath, status.getLen(), false);
            Assertions.assertEquals(tabletFiles, BulkFailureIT.getFiles(c, extent));
            Assertions.assertEquals(Set.of(bulkLoadPath), BulkFailureIT.getLoaded(c, extent));
            Assertions.assertEquals(testData, this.readTable(table, c));
            c.tableOperations().offline(table, true);
            c.tableOperations().online(table, true);
            loader.load(fateTxid, (ClientContext)asCtx, extent, bulkLoadPath, status.getLen(), false);
            Assertions.assertEquals(tabletFiles, BulkFailureIT.getFiles(c, extent));
            Assertions.assertEquals(Set.of(bulkLoadPath), BulkFailureIT.getLoaded(c, extent));
            Assertions.assertEquals(testData, this.readTable(table, c));
            TransactionWatcher.ZooArbitrator.stop((ServerContext)asCtx, (String)"bulkTx", (long)fateTxid);
            c.securityOperations().grantTablePermission(c.whoami(), MetadataTable.NAME, TablePermission.WRITE);
            BatchDeleter bd = c.createBatchDeleter(MetadataTable.NAME, Authorizations.EMPTY, 1);
            bd.setRanges(Collections.singleton(extent.toMetaRange()));
            bd.fetchColumnFamily(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            bd.delete();
            loader.load(fateTxid, (ClientContext)asCtx, extent, bulkLoadPath, status.getLen(), true);
            Assertions.assertEquals(tabletFiles, BulkFailureIT.getFiles(c, extent));
            Assertions.assertEquals(Set.of(), BulkFailureIT.getLoaded(c, extent));
            Assertions.assertEquals(testData, this.readTable(table, c));
        }
    }

    private SortedMap<Key, Value> createTestData() {
        TreeMap<Key, Value> testData = new TreeMap<Key, Value>();
        testData.put(new Key((CharSequence)"r001", (CharSequence)"f002", (CharSequence)"q009", 56L), new Value((CharSequence)"v001"));
        testData.put(new Key((CharSequence)"r001", (CharSequence)"f002", (CharSequence)"q019", 56L), new Value((CharSequence)"v002"));
        testData.put(new Key((CharSequence)"r002", (CharSequence)"f002", (CharSequence)"q009", 57L), new Value((CharSequence)"v003"));
        testData.put(new Key((CharSequence)"r002", (CharSequence)"f002", (CharSequence)"q019", 57L), new Value((CharSequence)"v004"));
        return testData;
    }

    private String createTestFile(long txid, SortedMap<Key, Value> testData, FileSystem fs) throws IOException {
        Path base = new Path(BulkFailureIT.getCluster().getTemporaryPath(), "testBulk_ICI_" + txid);
        fs.delete(base, true);
        fs.mkdirs(base);
        Path files = new Path(base, "files");
        try (RFileWriter writer = RFile.newWriter().to(new Path(files, "ici_01.rf").toString()).withFileSystem(fs).build();){
            writer.append(testData.entrySet());
        }
        String filesStr = fs.makeQualified(files).toString();
        return filesStr;
    }

    private SortedMap<Key, Value> readTable(String table, AccumuloClient connector) throws TableNotFoundException {
        Scanner scanner = connector.createScanner(table, Authorizations.EMPTY);
        TreeMap<Key, Value> actual = new TreeMap<Key, Value>();
        for (Map.Entry entry : scanner) {
            actual.put((Key)entry.getKey(), (Value)entry.getValue());
        }
        return actual;
    }

    public static Set<Path> getLoaded(AccumuloClient connector, KeyExtent extent) throws TableNotFoundException {
        return BulkFailureIT.getPaths(connector, extent, MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
    }

    public static Set<Path> getFiles(AccumuloClient connector, KeyExtent extent) throws TableNotFoundException {
        return BulkFailureIT.getPaths(connector, extent, MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
    }

    private static Set<Path> getPaths(AccumuloClient connector, KeyExtent extent, Text fam) throws TableNotFoundException {
        HashSet<Path> files = new HashSet<Path>();
        Scanner scanner = connector.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
        scanner.setRange(extent.toMetaRange());
        scanner.fetchColumnFamily(fam);
        for (Map.Entry entry : scanner) {
            files.add(new Path(((Key)entry.getKey()).getColumnQualifierData().toString()));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void oldLoad(long txid, ClientContext context, KeyExtent extent, Path path, long size, boolean expectFailure) throws Exception {
        TabletClientService.Iface client = BulkFailureIT.getClient(context, extent);
        try {
            Map<String, MapFileInfo> val = Map.of(path.toString(), new MapFileInfo(size));
            Map<KeyExtent, Map<String, MapFileInfo>> files = Map.of(extent, val);
            client.bulkImport(TraceUtil.traceInfo(), context.rpcCreds(), txid, files.entrySet().stream().collect(Collectors.toMap(entry -> ((KeyExtent)entry.getKey()).toThrift(), Map.Entry::getValue)), false);
            if (expectFailure) {
                Assertions.fail((String)"Expected RPC to fail");
            }
        }
        catch (TApplicationException tae) {
            if (!expectFailure) {
                throw tae;
            }
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)((TServiceClient)client), (ClientContext)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void newLoad(long txid, ClientContext context, KeyExtent extent, Path path, long size, boolean expectFailure) throws Exception {
        TabletClientService.Iface client = BulkFailureIT.getClient(context, extent);
        try {
            Map<String, MapFileInfo> val = Map.of(path.getName(), new MapFileInfo(size));
            Map<KeyExtent, Map<String, MapFileInfo>> files = Map.of(extent, val);
            client.loadFiles(TraceUtil.traceInfo(), context.rpcCreds(), txid, path.getParent().toString(), files.entrySet().stream().collect(Collectors.toMap(entry -> ((KeyExtent)entry.getKey()).toThrift(), Map.Entry::getValue)), false);
            if (!expectFailure) {
                while (!BulkFailureIT.getLoaded((AccumuloClient)context, extent).contains(path)) {
                    Thread.sleep(100L);
                }
            }
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)((TServiceClient)client), (ClientContext)context);
        }
    }

    protected static TabletClientService.Iface getClient(ClientContext context, KeyExtent extent) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TTransportException {
        TabletLocator locator = TabletLocator.getLocator((ClientContext)context, (TableId)extent.tableId());
        locator.invalidateCache(extent);
        HostAndPort location = HostAndPort.fromString((String)locator.locateTablet((ClientContext)context, (Text)new Text((String)""), (boolean)false, (boolean)true).tablet_location);
        long timeInMillis = context.getConfiguration().getTimeInMillis(Property.TSERV_BULK_TIMEOUT);
        TabletClientService.Iface client = (TabletClientService.Iface)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)location, (ClientContext)context, (long)timeInMillis);
        return client;
    }

    static interface Loader {
        public void load(long var1, ClientContext var3, KeyExtent var4, Path var5, long var6, boolean var8) throws Exception;
    }
}

