/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.LoadPlan;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.constraints.Constraint;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.constraints.MetadataConstraints;
import org.apache.accumulo.server.constraints.SystemEnvironment;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BulkNewIT
extends SharedMiniClusterBase {
    private String tableName;
    private AccumuloConfiguration aconf;
    private FileSystem fs;
    private String rootPath;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new Callback());
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @BeforeEach
    public void setupBulkTest() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(this.tableName);
            this.aconf = BulkNewIT.getCluster().getServerContext().getConfiguration();
            this.fs = BulkNewIT.getCluster().getFileSystem();
            this.rootPath = BulkNewIT.getCluster().getTemporaryPath().toString();
        }
    }

    private String getDir(String testName) throws Exception {
        String dir = this.rootPath + testName + this.getUniqueNames(1)[0];
        this.fs.delete(new Path(dir), true);
        return dir;
    }

    private void testSingleTabletSingleFile(AccumuloClient c, boolean offline, boolean setTime) throws Exception {
        this.addSplits(c, this.tableName, "0333");
        if (offline) {
            c.tableOperations().offline(this.tableName);
        }
        String dir = this.getDir("/testSingleTabletSingleFileNoSplits-");
        String h1 = this.writeData(dir + "/f1.", this.aconf, 0, 332);
        c.tableOperations().importDirectory(dir).to(this.tableName).tableTime(setTime).load();
        c.tableOperations().importDirectory(dir).to(this.tableName).tableTime(setTime).ignoreEmptyDir(true).load();
        try {
            c.tableOperations().importDirectory(dir).to(this.tableName).tableTime(setTime).ignoreEmptyDir(false).load();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            c.tableOperations().importDirectory(dir).to(this.tableName).tableTime(setTime).load();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (offline) {
            c.tableOperations().online(this.tableName);
        }
        this.verifyData(c, this.tableName, 0, 332, setTime);
        this.verifyMetadata(c, this.tableName, Map.of("0333", Set.of(h1), "null", Set.of()));
    }

    @Test
    public void testSingleTabletSingleFile() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.testSingleTabletSingleFile(client, false, false);
        }
    }

    @Test
    public void testSetTime() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.tableName = "testSetTime_table1";
            NewTableConfiguration newTableConf = new NewTableConfiguration();
            newTableConf.setTimeType(TimeType.LOGICAL);
            client.tableOperations().create(this.tableName, newTableConf);
            this.testSingleTabletSingleFile(client, false, true);
        }
    }

    @Test
    public void testSingleTabletSingleFileOffline() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.testSingleTabletSingleFile(client, true, false);
        }
    }

    @Test
    public void testMaxTablets() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.tableName = "testMaxTablets_table1";
            NewTableConfiguration newTableConf = new NewTableConfiguration();
            Map<String, String> props = Map.of(Property.TABLE_BULK_MAX_TABLETS.getKey(), "2");
            newTableConf.setProperties(props);
            client.tableOperations().create(this.tableName, newTableConf);
            RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.testBulkFileMax(false));
            Throwable c = thrown.getCause();
            Assertions.assertTrue((boolean)(c instanceof ExecutionException), (String)("Wrong exception: " + c));
            Assertions.assertTrue((boolean)(c.getCause() instanceof IllegalArgumentException), (String)("Wrong exception: " + c.getCause()));
            String msg = c.getCause().getMessage();
            Assertions.assertTrue((boolean)msg.contains("bad-file.rf"), (String)("Bad File not in exception: " + msg));
            c = Assertions.assertThrows(AccumuloException.class, () -> this.testBulkFileMax(true));
            msg = c.getMessage();
            Assertions.assertTrue((boolean)msg.contains("bad-file.rf"), (String)("Bad File not in exception: " + msg));
        }
    }

    private void testSingleTabletSingleFileNoSplits(AccumuloClient c, boolean offline) throws Exception {
        if (offline) {
            c.tableOperations().offline(this.tableName);
        }
        String dir = this.getDir("/testSingleTabletSingleFileNoSplits-");
        String h1 = this.writeData(dir + "/f1.", this.aconf, 0, 333);
        c.tableOperations().importDirectory(dir).to(this.tableName).load();
        if (offline) {
            c.tableOperations().online(this.tableName);
        }
        this.verifyData(c, this.tableName, 0, 333, false);
        this.verifyMetadata(c, this.tableName, Map.of("null", Set.of(h1)));
    }

    @Test
    public void testSingleTabletSingleFileNoSplits() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.testSingleTabletSingleFileNoSplits(client, false);
        }
    }

    @Test
    public void testSingleTabletSingleFileNoSplitsOffline() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.testSingleTabletSingleFileNoSplits(client, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadPermissions() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            TableOperations.ImportMappingOptions importMappingOptions;
            this.addSplits(c, this.tableName, "0333");
            String dir = this.getDir("/testBadPermissions-");
            this.writeData(dir + "/f1.", this.aconf, 0, 333);
            Path rFilePath = new Path(dir, "f1.rf");
            FsPermission originalPerms = this.fs.getFileStatus(rFilePath).getPermission();
            this.fs.setPermission(rFilePath, FsPermission.valueOf((String)"----------"));
            try {
                importMappingOptions = c.tableOperations().importDirectory(dir).to(this.tableName);
                Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> ((TableOperations.ImportMappingOptions)importMappingOptions).load());
                Throwable cause = e.getCause();
                Assertions.assertTrue((cause instanceof FileNotFoundException || cause.getCause() instanceof FileNotFoundException ? 1 : 0) != 0);
            }
            finally {
                this.fs.setPermission(rFilePath, originalPerms);
            }
            originalPerms = this.fs.getFileStatus(new Path(dir)).getPermission();
            this.fs.setPermission(new Path(dir), FsPermission.valueOf((String)"dr--r--r--"));
            try {
                importMappingOptions = c.tableOperations().importDirectory(dir).to(this.tableName);
                AccumuloException ae = (AccumuloException)Assertions.assertThrows(AccumuloException.class, () -> ((TableOperations.ImportMappingOptions)importMappingOptions).load());
                Assertions.assertTrue((boolean)(ae.getCause() instanceof FileNotFoundException));
            }
            finally {
                this.fs.setPermission(new Path(dir), originalPerms);
            }
        }
    }

    private void testBulkFile(boolean offline, boolean usePlan) throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.addSplits(c, this.tableName, "0333 0666 0999 1333 1666");
            if (offline) {
                c.tableOperations().offline(this.tableName);
            }
            String dir = this.getDir("/testBulkFile-");
            HashMap<String, Set<String>> hashes = new HashMap<String, Set<String>>();
            for (String endRow : Arrays.asList("0333 0666 0999 1333 1666 null".split(" "))) {
                hashes.put(endRow, new HashSet());
            }
            FSDataOutputStream out = this.fs.create(new Path(dir, "junk"));
            out.writeChars("ABCDEFG\n");
            out.close();
            String h1 = this.writeData(dir + "/f1.", this.aconf, 0, 333);
            ((Set)hashes.get("0333")).add(h1);
            String h2 = this.writeData(dir + "/f2.", this.aconf, 334, 999);
            ((Set)hashes.get("0666")).add(h2);
            ((Set)hashes.get("0999")).add(h2);
            String h3 = this.writeData(dir + "/f3.", this.aconf, 1000, 1499);
            ((Set)hashes.get("1333")).add(h3);
            ((Set)hashes.get("1666")).add(h3);
            String h4 = this.writeData(dir + "/f4.", this.aconf, 1500, 1999);
            ((Set)hashes.get("1666")).add(h4);
            ((Set)hashes.get("null")).add(h4);
            if (usePlan) {
                LoadPlan loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(333)).loadFileTo("f2.rf", LoadPlan.RangeType.TABLE, (CharSequence)BulkNewIT.row(333), (CharSequence)BulkNewIT.row(999)).loadFileTo("f3.rf", LoadPlan.RangeType.FILE, (CharSequence)BulkNewIT.row(1000), (CharSequence)BulkNewIT.row(1499)).loadFileTo("f4.rf", LoadPlan.RangeType.FILE, (CharSequence)BulkNewIT.row(1500), (CharSequence)BulkNewIT.row(1999)).build();
                c.tableOperations().importDirectory(dir).to(this.tableName).plan(loadPlan).load();
            } else {
                c.tableOperations().importDirectory(dir).to(this.tableName).load();
            }
            if (offline) {
                c.tableOperations().online(this.tableName);
            }
            this.verifyData(c, this.tableName, 0, 1999, false);
            this.verifyMetadata(c, this.tableName, hashes);
        }
    }

    private void testBulkFileMax(boolean usePlan) throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.addSplits(c, this.tableName, "0333 0666 0999 1333 1666");
            String dir = this.getDir("/testBulkFileMax-");
            HashMap<String, Set<String>> hashes = new HashMap<String, Set<String>>();
            for (String endRow : Arrays.asList("0333 0666 0999 1333 1666 null".split(" "))) {
                hashes.put(endRow, new HashSet());
            }
            FSDataOutputStream out = this.fs.create(new Path(dir, "junk"));
            out.writeChars("ABCDEFG\n");
            out.close();
            String h1 = this.writeData(dir + "/f1.", this.aconf, 0, 333);
            ((Set)hashes.get("0333")).add(h1);
            String h2 = this.writeData(dir + "/bad-file.", this.aconf, 334, 1333);
            ((Set)hashes.get("0666")).add(h2);
            ((Set)hashes.get("0999")).add(h2);
            ((Set)hashes.get("1333")).add(h2);
            String h3 = this.writeData(dir + "/f3.", this.aconf, 1334, 1499);
            ((Set)hashes.get("1666")).add(h3);
            String h4 = this.writeData(dir + "/f4.", this.aconf, 1500, 1999);
            ((Set)hashes.get("1666")).add(h4);
            ((Set)hashes.get("null")).add(h4);
            if (usePlan) {
                LoadPlan loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(333)).loadFileTo("bad-file.rf", LoadPlan.RangeType.TABLE, (CharSequence)BulkNewIT.row(333), (CharSequence)BulkNewIT.row(1333)).loadFileTo("f3.rf", LoadPlan.RangeType.FILE, (CharSequence)BulkNewIT.row(1334), (CharSequence)BulkNewIT.row(1499)).loadFileTo("f4.rf", LoadPlan.RangeType.FILE, (CharSequence)BulkNewIT.row(1500), (CharSequence)BulkNewIT.row(1999)).build();
                c.tableOperations().importDirectory(dir).to(this.tableName).plan(loadPlan).load();
            } else {
                c.tableOperations().importDirectory(dir).to(this.tableName).load();
            }
            this.verifyData(c, this.tableName, 0, 1999, false);
            this.verifyMetadata(c, this.tableName, hashes);
        }
    }

    @Test
    public void testBulkFile() throws Exception {
        this.testBulkFile(false, false);
    }

    @Test
    public void testBulkFileOffline() throws Exception {
        this.testBulkFile(true, false);
    }

    @Test
    public void testLoadPlan() throws Exception {
        this.testBulkFile(false, true);
    }

    @Test
    public void testLoadPlanOffline() throws Exception {
        this.testBulkFile(true, true);
    }

    @Test
    public void testBadLoadPlans() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            this.addSplits(c, this.tableName, "0333 0666 0999 1333 1666");
            String dir = this.getDir("/testBulkFile-");
            this.writeData(dir + "/f1.", this.aconf, 0, 333);
            this.writeData(dir + "/f2.", this.aconf, 0, 666);
            TableOperations.ImportMappingOptions importMappingOptions = c.tableOperations().importDirectory(dir).to(this.tableName);
            LoadPlan loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(333)).loadFileTo("f2.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(666)).loadFileTo("f3.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(666)).build();
            TableOperations.ImportOptions tooManyFiles = importMappingOptions.plan(loadPlan);
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((TableOperations.ImportOptions)tooManyFiles).load());
            loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(333)).build();
            TableOperations.ImportOptions tooFewFiles = importMappingOptions.plan(loadPlan);
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((TableOperations.ImportOptions)tooFewFiles).load());
            loadPlan = LoadPlan.builder().loadFileTo("f1.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(555)).loadFileTo("f2.rf", LoadPlan.RangeType.TABLE, null, (CharSequence)BulkNewIT.row(555)).build();
            TableOperations.ImportOptions nonExistentBoundary = importMappingOptions.plan(loadPlan);
            Assertions.assertThrows(AccumuloException.class, () -> ((TableOperations.ImportOptions)nonExistentBoundary).load());
        }
    }

    @Test
    public void testEmptyDir() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            String dir = this.getDir("/testBulkFile-");
            FileSystem fs = BulkNewIT.getCluster().getFileSystem();
            fs.mkdirs(new Path(dir));
            Assertions.assertThrows(IllegalArgumentException.class, () -> c.tableOperations().importDirectory(dir).to(this.tableName).load());
        }
    }

    @Test
    public void testEmptyDirWithIgnoreOption() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            String dir = this.getDir("/testBulkFile-");
            FileSystem fs = BulkNewIT.getCluster().getFileSystem();
            fs.mkdirs(new Path(dir));
            c.tableOperations().importDirectory(dir).to(this.tableName).ignoreEmptyDir(true).load();
        }
    }

    @Test
    public void testEndOfFirstTablet() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            String dir = this.getDir("/testBulkFile-");
            FileSystem fs = BulkNewIT.getCluster().getFileSystem();
            fs.mkdirs(new Path(dir));
            this.addSplits(c, this.tableName, "0333");
            String h1 = this.writeData(dir + "/f1.", this.aconf, 333, 333);
            c.tableOperations().importDirectory(dir).to(this.tableName).load();
            this.verifyData(c, this.tableName, 333, 333, false);
            HashMap<String, Set<String>> hashes = new HashMap<String, Set<String>>();
            hashes.put("0333", Set.of(h1));
            hashes.put("null", Set.of());
            this.verifyMetadata(c, this.tableName, hashes);
        }
    }

    @Test
    public void testExceptionInMetadataUpdate() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkNewIT.getClientProps()).build();){
            BulkNewIT.setupBulkConstraint(BulkNewIT.getPrincipal(), c);
            String dir = this.getDir("/testExceptionInMetadataUpdate-");
            String h1 = this.writeData(dir + "/f1.", this.aconf, 0, 333);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Object> future = executor.submit(() -> {
                c.tableOperations().importDirectory(dir).to(this.tableName).load();
                return null;
            });
            Thread.sleep(10000L);
            Assertions.assertFalse((boolean)future.isDone());
            BulkNewIT.removeBulkConstraint(BulkNewIT.getPrincipal(), c);
            future.get();
            this.verifyData(c, this.tableName, 0, 333, false);
            this.verifyMetadata(c, this.tableName, Map.of("null", Set.of(h1)));
        }
    }

    private void addSplits(AccumuloClient client, String tableName, String splitString) throws Exception {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (String split : splitString.split(" ")) {
            splits.add(new Text(split));
        }
        client.tableOperations().addSplits(tableName, splits);
    }

    private void verifyData(AccumuloClient client, String table, int start, int end, boolean setTime) throws Exception {
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            Iterator iter = scanner.iterator();
            for (int i = start; i <= end; ++i) {
                if (!iter.hasNext()) {
                    throw new Exception("row " + i + " not found");
                }
                Map.Entry entry = (Map.Entry)iter.next();
                String row = String.format("%04d", i);
                if (!((Key)entry.getKey()).getRow().equals((Object)new Text(row))) {
                    throw new Exception("unexpected row " + entry.getKey() + " " + i);
                }
                if (Integer.parseInt(((Value)entry.getValue()).toString()) != i) {
                    throw new Exception("unexpected value " + entry + " " + i);
                }
                if (!setTime) continue;
                Assertions.assertEquals((long)1L, (long)((Key)entry.getKey()).getTimestamp());
            }
            if (iter.hasNext()) {
                throw new Exception("found more than expected " + iter.next());
            }
        }
    }

    private void verifyMetadata(AccumuloClient client, String tableName, Map<String, Set<String>> expectedHashes) {
        HashSet<String> endRowsSeen = new HashSet<String>();
        String id = (String)client.tableOperations().tableIdMap().get(tableName);
        try (TabletsMetadata tablets = TabletsMetadata.builder((AccumuloClient)client).forTable(TableId.of((String)id)).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.LOADED, TabletMetadata.ColumnType.PREV_ROW}).build();){
            for (TabletMetadata tablet : tablets) {
                Assertions.assertTrue((boolean)tablet.getLoaded().isEmpty());
                Set fileHashes = tablet.getFiles().stream().map(f -> this.hash(f.getMetaUpdateDelete())).collect(Collectors.toSet());
                String endRow = tablet.getEndRow() == null ? "null" : tablet.getEndRow().toString();
                Assertions.assertEquals(expectedHashes.get(endRow), fileHashes);
                endRowsSeen.add(endRow);
            }
            Assertions.assertEquals(expectedHashes.keySet(), endRowsSeen);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "WEAK_MESSAGE_DIGEST_SHA1"}, justification="path provided by test; sha-1 is okay for test")
    private String hash(String filename) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(filename.replaceFirst("^file:", ""), new String[0]));
            byte[] hash = MessageDigest.getInstance("SHA1").digest(data);
            return new BigInteger(1, hash).toString(16);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String row(int r) {
        return String.format("%04d", r);
    }

    private String writeData(String file, AccumuloConfiguration aconf, int s, int e) throws Exception {
        FileSystem fs = BulkNewIT.getCluster().getFileSystem();
        String filename = file + "rf";
        try (FileSKVWriter writer = FileOperations.getInstance().newWriterBuilder().forFile(filename, fs, fs.getConf(), NoCryptoServiceFactory.NONE).withTableConfiguration(aconf).build();){
            writer.startDefaultLocalityGroup();
            for (int i = s; i <= e; ++i) {
                writer.append(new Key(new Text(BulkNewIT.row(i))), new Value((CharSequence)Integer.toString(i)));
            }
        }
        return this.hash(filename);
    }

    static void setupBulkConstraint(String principal, AccumuloClient c) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        c.securityOperations().grantTablePermission(principal, MetadataTable.NAME, TablePermission.WRITE);
        c.securityOperations().grantTablePermission(principal, MetadataTable.NAME, TablePermission.ALTER_TABLE);
        c.tableOperations().addConstraint(MetadataTable.NAME, NoBulkConstratint.class.getName());
        MetadataConstraints metaConstraints = new MetadataConstraints();
        SystemEnvironment env = (SystemEnvironment)EasyMock.createMock(SystemEnvironment.class);
        ServerContext context = (ServerContext)EasyMock.createMock(ServerContext.class);
        EasyMock.expect((Object)env.getServerContext()).andReturn((Object)context);
        EasyMock.replay((Object[])new Object[]{env});
        Wait.waitFor(() -> {
            boolean bl;
            block8: {
                BatchWriter bw = c.createBatchWriter(MetadataTable.NAME);
                try {
                    Mutation m = new Mutation((CharSequence)"~garbage");
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)"a!p@a#c$h%e^&*()");
                    Assertions.assertNull((Object)metaConstraints.check((Constraint.Environment)env, m));
                    bw.addMutation(m);
                    bl = false;
                    if (bw == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (bw != null) {
                            try {
                                bw.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (MutationsRejectedException e) {
                        return e.getConstraintViolationSummaries().stream().anyMatch(cvs -> cvs.violationCode == 31234);
                    }
                }
                bw.close();
            }
            return bl;
        });
        try (BatchWriter bw = c.createBatchWriter(MetadataTable.NAME);){
            Mutation m = new Mutation((CharSequence)"~garbage");
            m.putDelete((CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
        }
    }

    static void removeBulkConstraint(String principal, AccumuloClient c) throws AccumuloException, TableNotFoundException, AccumuloSecurityException {
        int constraintNum = (Integer)c.tableOperations().listConstraints(MetadataTable.NAME).get(NoBulkConstratint.class.getName());
        c.tableOperations().removeConstraint(MetadataTable.NAME, constraintNum);
        c.securityOperations().revokeTablePermission(principal, MetadataTable.NAME, TablePermission.WRITE);
        c.securityOperations().revokeTablePermission(principal, MetadataTable.NAME, TablePermission.ALTER_TABLE);
    }

    private static class Callback
    implements MiniClusterConfigurationCallback {
        private Callback() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration conf) {
            cfg.setMemory(ServerType.TABLET_SERVER, 512L, MemoryUnit.MEGABYTE);
            conf.set("fs.file.impl", RawLocalFileSystem.class.getName());
        }
    }

    public static class NoBulkConstratint
    implements Constraint {
        public static final String CANARY_VALUE = "a!p@a#c$h%e^&*()";
        public static final short CANARY_CODE = 31234;

        public String getViolationDescription(short violationCode) {
            if (violationCode == 1) {
                return "Bulk import files are not allowed in this test";
            }
            if (violationCode == 31234) {
                return "Check used to see if constraint is active";
            }
            return null;
        }

        public List<Short> check(Constraint.Environment env, Mutation mutation) {
            for (ColumnUpdate colUpdate : mutation.getUpdates()) {
                StoredTabletFile stf;
                Text fam = new Text(colUpdate.getColumnFamily());
                if (fam.equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) && (stf = new StoredTabletFile(new String(colUpdate.getColumnQualifier(), StandardCharsets.UTF_8))).getFileName().startsWith("I")) {
                    return List.of(Short.valueOf((short)1));
                }
                if (!new String(colUpdate.getValue(), StandardCharsets.UTF_8).equals(CANARY_VALUE)) continue;
                return List.of(Short.valueOf((short)31234));
            }
            return null;
        }
    }
}

