/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.BulkNewIT;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BulkOldIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration conf) {
        cfg.setMemory(ServerType.TABLET_SERVER, 512L, MemoryUnit.MEGABYTE);
        cfg.setProperty(Property.TSERV_BULK_RETRY, "2");
    }

    @Test
    public void testBulkFile() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkOldIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            TreeSet<Text> splits = new TreeSet<Text>();
            for (String split : "0333 0666 0999 1333 1666".split(" ")) {
                splits.add(new Text(split));
            }
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(splits);
            c.tableOperations().create(tableName, ntc);
            Configuration conf = new Configuration();
            AccumuloConfiguration aconf = BulkOldIT.getCluster().getServerContext().getConfiguration();
            FileSystem fs = BulkOldIT.getCluster().getFileSystem();
            String rootPath = cluster.getTemporaryPath().toString();
            String dir = rootPath + "/bulk_test_diff_files_89723987592_" + this.getUniqueNames(1)[0];
            fs.delete(new Path(dir), true);
            this.writeData(conf, aconf, fs, dir, "f1", 0, 333);
            this.writeData(conf, aconf, fs, dir, "f2", 334, 999);
            this.writeData(conf, aconf, fs, dir, "f3", 1000, 1999);
            String failDir = dir + "_failures";
            Path failPath = new Path(failDir);
            fs.delete(failPath, true);
            fs.mkdirs(failPath);
            fs.deleteOnExit(failPath);
            c.tableOperations().importDirectory(tableName, dir, failDir, false);
            if (fs.listStatus(failPath).length > 0) {
                throw new Exception("Some files failed to bulk import");
            }
            FunctionalTestUtils.checkRFiles(c, tableName, 6, 6, 1, 1);
            this.verifyData(c, tableName, 0, 1999);
        }
    }

    @Test
    public void testExceptionInMetadataUpdate() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkOldIT.getClientProps()).build();){
            BulkNewIT.setupBulkConstraint(BulkOldIT.getAdminPrincipal(), c);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            Configuration conf = new Configuration();
            AccumuloConfiguration aconf = BulkOldIT.getCluster().getServerContext().getConfiguration();
            FileSystem fs = BulkOldIT.getCluster().getFileSystem();
            String rootPath = cluster.getTemporaryPath().toString();
            String dir = rootPath + "/bulk_test_diff_files_89723987592_" + this.getUniqueNames(1)[0];
            fs.delete(new Path(dir), true);
            this.writeData(conf, aconf, fs, dir, "f1", 0, 333);
            String failDir = dir + "_failures";
            Path failPath = new Path(failDir);
            fs.delete(failPath, true);
            fs.mkdirs(failPath);
            fs.deleteOnExit(failPath);
            c.tableOperations().importDirectory(tableName, dir, failDir, false);
            if (fs.listStatus(failPath).length < 1) {
                throw new Exception("Expected files in failure directory");
            }
            try (Scanner scanner = c.createScanner(tableName);){
                Assertions.assertEquals((long)0L, (long)scanner.stream().count());
            }
            BulkNewIT.removeBulkConstraint(BulkOldIT.getAdminPrincipal(), c);
        }
    }

    private void writeData(Configuration conf, AccumuloConfiguration aconf, FileSystem fs, String dir, String file, int start, int end) throws IOException, Exception {
        FileSKVWriter writer1 = FileOperations.getInstance().newWriterBuilder().forFile(dir + "/" + file + ".rf", fs, conf, NoCryptoServiceFactory.NONE).withTableConfiguration(aconf).build();
        writer1.startDefaultLocalityGroup();
        for (int i = start; i <= end; ++i) {
            writer1.append(new Key(new Text(String.format("%04d", i))), new Value((CharSequence)Integer.toString(i)));
        }
        writer1.close();
    }

    private void verifyData(AccumuloClient client, String table, int s, int e) throws Exception {
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            Iterator iter = scanner.iterator();
            for (int i = s; i <= e; ++i) {
                if (!iter.hasNext()) {
                    throw new Exception("row " + i + " not found");
                }
                Map.Entry entry = (Map.Entry)iter.next();
                String row = String.format("%04d", i);
                if (!((Key)entry.getKey()).getRow().equals((Object)new Text(row))) {
                    throw new Exception("unexpected row " + entry.getKey() + " " + i);
                }
                if (Integer.parseInt(((Value)entry.getValue()).toString()) == i) continue;
                throw new Exception("unexpected value " + entry + " " + i);
            }
            if (iter.hasNext()) {
                throw new Exception("found more than expected " + iter.next());
            }
        }
    }
}

