/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BulkSplitOptimizationIT
extends AccumuloClusterHarness {
    private String majcDelay;
    private static final int ROWS = 100000;
    private static final int SPLITS = 99;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1s");
    }

    @BeforeEach
    public void alterConfig() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkSplitOptimizationIT.getClientProps()).build();){
            this.majcDelay = (String)client.instanceOperations().getSystemConfiguration().get(Property.TSERV_MAJC_DELAY.getKey());
            if (!"1s".equals(this.majcDelay)) {
                client.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), "1s");
                BulkSplitOptimizationIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                BulkSplitOptimizationIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            }
        }
    }

    @AfterEach
    public void resetConfig() throws Exception {
        if (this.majcDelay != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(BulkSplitOptimizationIT.getClientProps()).build();){
                client.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
                BulkSplitOptimizationIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                BulkSplitOptimizationIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            }
        }
    }

    @Test
    public void testBulkSplitOptimization() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(BulkSplitOptimizationIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "1000");
            c.tableOperations().setProperty(tableName, Property.TABLE_FILE_MAX.getKey(), "1000");
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "1G");
            FileSystem fs = cluster.getFileSystem();
            Path testDir = new Path(cluster.getTemporaryPath(), "testmf");
            fs.deleteOnExit(testDir);
            FunctionalTestUtils.createRFiles(c, fs, testDir.toString(), 100000, 99, 8);
            FileStatus[] stats = fs.listStatus(testDir);
            System.out.println("Number of generated files: " + stats.length);
            c.tableOperations().importDirectory(testDir.toString()).to(tableName).load();
            FunctionalTestUtils.checkSplits(c, tableName, 0, 0);
            FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 100, 100);
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "100K");
            UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
            while (c.tableOperations().listSplits(tableName).size() < 75) {
                UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            FunctionalTestUtils.checkSplits(c, tableName, 50, 100);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(BulkSplitOptimizationIT.getClientProps(), tableName, 100000);
            params.timestamp = 1L;
            params.dataSize = 50;
            params.random = 56;
            params.startRow = 0;
            params.cols = 1;
            VerifyIngest.verifyIngest(c, params);
            FunctionalTestUtils.checkRFiles(c, tableName, 50, 100, 1, 4);
        }
    }
}

