/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.ChaoticLoadBalancer;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Test;

public class ChaoticBalancerIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAXMEM.getKey(), "10K");
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
        siteConfig.put(Property.TABLE_LOAD_BALANCER.getKey(), ChaoticLoadBalancer.class.getName());
        cfg.setSiteConfig(siteConfig);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ChaoticBalancerIT.getClientProps()).build();){
            String[] names = this.getUniqueNames(1);
            String tableName = names[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            ntc.setProperties(Stream.of(new Pair((Object)Property.TABLE_SPLIT_THRESHOLD.getKey(), (Object)"10K"), new Pair((Object)Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), (Object)"1K")).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
            c.tableOperations().create(tableName, ntc);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(ChaoticBalancerIT.getClientProps(), tableName, 20000);
            TestIngest.ingest(c, params);
            c.tableOperations().flush(tableName, null, null, true);
            VerifyIngest.verifyIngest(c, params);
        }
    }
}

