/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanTmpIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(CleanTmpIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Path file;
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"row");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
                bw.flush();
                c.tableOperations().compact(tableName, null, null, true, true);
                m = new Mutation((CharSequence)"row2");
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
            String id = (String)c.tableOperations().tableIdMap().get(tableName);
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(Range.prefix((CharSequence)id));
                s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                Map.Entry<Key, Value> entry = this.getOnlyElement(s);
                file = new Path(entry.getKey().getColumnQualifier().toString());
            }
            FileSystem fs = this.getCluster().getFileSystem();
            Assertions.assertTrue((boolean)fs.exists(file), (String)("Could not find file: " + file));
            Path tabletDir = file.getParent();
            Assertions.assertNotNull((Object)tabletDir, (String)"Tablet dir should not be null");
            Path tmp = new Path(tabletDir, "junk.rf_tmp");
            fs.create(tmp).close();
            log.info("Created tmp file {}", (Object)tmp);
            this.getCluster().stop();
            this.getCluster().start();
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                Assertions.assertEquals((int)2, (int)Iterators.size((Iterator)scanner.iterator()));
                Assertions.assertFalse((boolean)fs.exists(tmp), (String)("File still exists: " + tmp));
            }
        }
    }
}

