/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.util.CleanUp;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(CleanUpIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(30L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void run() throws Exception {
        Assertions.assertEquals((long)0L, (long)SingletonManager.getReservationCount());
        Connector conn = new ZooKeeperInstance(CleanUpIT.getCluster().getInstanceName(), CleanUpIT.getCluster().getZooKeepers()).getConnector(CleanUpIT.getPrincipal(), CleanUpIT.getToken());
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m1 = new Mutation((CharSequence)"r1");
        m1.put((CharSequence)"cf1", (CharSequence)"cq1", 1L, (CharSequence)"5");
        bw.addMutation(m1);
        bw.flush();
        try (Scanner scanner = conn.createScanner(tableName, new Authorizations());){
            int count = 0;
            for (Map.Entry entry : scanner) {
                ++count;
                if (((Value)entry.getValue()).toString().equals("5")) continue;
                Assertions.fail((String)("Unexpected value " + entry.getValue()));
            }
            Assertions.assertEquals((int)1, (int)count, (String)"Unexpected count");
            int threadCount = this.countThreads();
            if (threadCount < 2) {
                this.printThreadNames();
                Assertions.fail((String)("Not seeing expected threads. Saw " + threadCount));
            }
            scanner.close();
            Assertions.assertThrows(IllegalStateException.class, () -> Iterables.size((Iterable)scanner));
        }
        CleanUp.shutdownNow((Connector)conn);
        Mutation m2 = new Mutation((CharSequence)"r2");
        m2.put((CharSequence)"cf1", (CharSequence)"cq1", 1L, (CharSequence)"6");
        bw.addMutation(m1);
        Assertions.assertThrows(MutationsRejectedException.class, () -> ((BatchWriter)bw).flush());
        Assertions.assertThrows(MutationsRejectedException.class, () -> ((BatchWriter)bw).close());
        int threadCount = this.countThreads();
        if (threadCount > 0) {
            this.printThreadNames();
            Assertions.fail((String)("Threads did not go away. Saw " + threadCount));
        }
    }

    private void printThreadNames() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        Exception e = new Exception();
        for (Thread thread : threads) {
            e.setStackTrace(thread.getStackTrace());
            log.info("thread name: " + thread.getName(), (Throwable)e);
        }
    }

    private int countThreads() {
        int count = 0;
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            if (thread.getName().toLowerCase().contains("sendthread") || thread.getName().toLowerCase().contains("eventthread")) {
                ++count;
            }
            if (!thread.getName().toLowerCase().contains("thrift") || !thread.getName().toLowerCase().contains("pool")) continue;
            ++count;
        }
        return count;
    }
}

