/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Collections;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CombinerIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    private void checkSum(String tableName, AccumuloClient c) throws Exception {
        try (Scanner s = c.createScanner(tableName, Authorizations.EMPTY);){
            String actual = this.getOnlyElement(s).getValue().toString();
            Assertions.assertEquals((Object)"45", (Object)actual);
        }
    }

    @Test
    public void aggregationTest() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(CombinerIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            IteratorSetting setting = new IteratorSetting(10, SummingCombiner.class);
            SummingCombiner.setEncodingType((IteratorSetting)setting, (LongCombiner.Type)LongCombiner.Type.STRING);
            SummingCombiner.setColumns((IteratorSetting)setting, Collections.singletonList(new IteratorSetting.Column("cf")));
            c.tableOperations().attachIterator(tableName, setting);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < 10; ++i) {
                    Mutation m = new Mutation((CharSequence)"row1");
                    m.put("cf".getBytes(), "col1".getBytes(), ("" + i).getBytes());
                    bw.addMutation(m);
                }
            }
            this.checkSum(tableName, c);
        }
    }
}

