/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompactLocationModeIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration fsConf) {
        cfg.setProperty(Property.TSERV_LAST_LOCATION_MODE, "compaction");
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = this.getCluster().createAccumuloClient("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));){
            TabletLocationState newTablet;
            String tableName = super.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
            do {
                UtilWaitThread.sleep((long)250L);
                newTablet = this.getTabletLocationState(c, tableId);
            } while (newTablet.current == null);
            Assertions.assertNull((Object)newTablet.last);
            Assertions.assertNull((Object)newTablet.future);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"a");
                m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
                bw.addMutation(m);
            }
            Assertions.assertEquals((Object)"compaction", c.instanceOperations().getSystemConfiguration().get(Property.TSERV_LAST_LOCATION_MODE.getKey()));
            TabletLocationState unflushed = this.getTabletLocationState(c, tableId);
            Assertions.assertEquals((Object)newTablet.current, (Object)unflushed.current);
            Assertions.assertNull((Object)unflushed.last);
            Assertions.assertNull((Object)newTablet.future);
            c.tableOperations().flush(tableName, null, null, true);
            TabletLocationState flushed = this.getTabletLocationState(c, tableId);
            Assertions.assertEquals((Object)newTablet.current, (Object)flushed.current);
            Assertions.assertEquals((Object)flushed.getCurrentServer(), (Object)flushed.getLastServer());
            Assertions.assertNull((Object)newTablet.future);
            c.tableOperations().offline(tableName, true);
            TabletLocationState offline = this.getTabletLocationState(c, tableId);
            Assertions.assertNull((Object)offline.future);
            Assertions.assertNull((Object)offline.current);
            Assertions.assertEquals((Object)flushed.getCurrentServer(), (Object)offline.getLastServer());
            c.tableOperations().online(tableName, true);
            TabletLocationState online = this.getTabletLocationState(c, tableId);
            Assertions.assertNull((Object)online.future);
            Assertions.assertNotNull((Object)online.current);
            Assertions.assertEquals((Object)offline.last, (Object)online.last);
        }
    }

    private TabletLocationState getTabletLocationState(AccumuloClient c, String tableId) {
        try (MetaDataTableScanner s = new MetaDataTableScanner((ClientContext)c, new Range(MetadataSchema.TabletsSection.encodeRow((TableId)TableId.of((String)tableId), null)), MetadataTable.NAME);){
            TabletLocationState tabletLocationState = s.next();
            return tabletLocationState;
        }
    }
}

