/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConcurrentDeleteTableIT
extends AccumuloClusterHarness {
    private final NewTableConfiguration ntc = new NewTableConfiguration().withSplits(this.createSplits());
    private final int NUM_TABLES = 2;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(7L);
    }

    @Test
    public void testConcurrentDeleteTablesOps() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ConcurrentDeleteTableIT.getClientProps()).build();){
            String[] tables = this.getUniqueNames(2);
            int numDeleteOps = 20;
            ExecutorService es = Executors.newFixedThreadPool(numDeleteOps);
            int count = 0;
            for (String table : tables) {
                c.tableOperations().create(table, this.ntc);
                this.writeData(c, table);
                if (count == tables.length - 1) {
                    c.tableOperations().flush(table, null, null, true);
                }
                ++count;
                CountDownLatch cdl = new CountDownLatch(numDeleteOps);
                ArrayList futures = new ArrayList();
                for (int i = 0; i < numDeleteOps; ++i) {
                    futures.add(es.submit(() -> {
                        try {
                            cdl.countDown();
                            cdl.await();
                            c.tableOperations().delete(table);
                        }
                        catch (TableNotFoundException tableNotFoundException) {
                        }
                        catch (InterruptedException | AccumuloException | AccumuloSecurityException e) {
                            throw new RuntimeException(e);
                        }
                    }));
                }
                Assertions.assertEquals((int)numDeleteOps, (int)futures.size());
                for (Future future : futures) {
                    future.get();
                }
                Assertions.assertThrows(TableNotFoundException.class, () -> c.createScanner(table, Authorizations.EMPTY), (String)("Expected table " + table + " to be gone."));
                FunctionalTestUtils.assertNoDanglingFateLocks(ConcurrentDeleteTableIT.getCluster());
            }
            es.shutdown();
        }
    }

    @Test
    public void testConcurrentFateOpsWithDelete() throws Exception {
        try (final AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ConcurrentDeleteTableIT.getClientProps()).build();){
            String[] tables = this.getUniqueNames(2);
            int numOperations = 8;
            ExecutorService es = Executors.newFixedThreadPool(numOperations);
            int count = 0;
            for (final String table : tables) {
                c.tableOperations().create(table, this.ntc);
                this.writeData(c, table);
                if (count == tables.length - 1) {
                    c.tableOperations().flush(table, null, null, true);
                }
                ++count;
                CountDownLatch cdl = new CountDownLatch(numOperations);
                ArrayList futures = new ArrayList();
                futures.add(es.submit(() -> {
                    try {
                        cdl.countDown();
                        cdl.await();
                        c.tableOperations().delete(table);
                    }
                    catch (TableNotFoundException | TableOfflineException throwable) {
                    }
                    catch (InterruptedException | AccumuloException | AccumuloSecurityException e) {
                        throw new RuntimeException(e);
                    }
                }));
                futures.add(es.submit(new DelayedTableOp(cdl){

                    @Override
                    protected void doTableOp() throws Exception {
                        c.tableOperations().compact(table, new CompactionConfig());
                    }
                }));
                futures.add(es.submit(new DelayedTableOp(cdl){

                    @Override
                    protected void doTableOp() throws Exception {
                        c.tableOperations().merge(table, null, null);
                    }
                }));
                futures.add(es.submit(new DelayedTableOp(cdl){

                    @Override
                    protected void doTableOp() throws Exception {
                        Map m = Collections.emptyMap();
                        Set s = Collections.emptySet();
                        c.tableOperations().clone(table, table + "_clone", true, m, s);
                    }
                }));
                futures.add(es.submit(new DelayedTableOp(cdl){

                    @Override
                    protected void doTableOp() throws Exception {
                        c.tableOperations().deleteRows(table, null, null);
                    }
                }));
                futures.add(es.submit(new DelayedTableOp(cdl){

                    @Override
                    protected void doTableOp() throws Exception {
                        c.tableOperations().cancelCompaction(table);
                    }
                }));
                futures.add(es.submit(new DelayedTableOp(cdl){

                    @Override
                    protected void doTableOp() throws Exception {
                        c.tableOperations().rename(table, table + "_renamed");
                    }
                }));
                futures.add(es.submit(new DelayedTableOp(cdl){

                    @Override
                    protected void doTableOp() throws Exception {
                        c.tableOperations().offline(table);
                    }
                }));
                Assertions.assertEquals((int)numOperations, (int)futures.size());
                for (Future future : futures) {
                    future.get();
                }
                Assertions.assertThrows(TableNotFoundException.class, () -> c.createScanner(table, Authorizations.EMPTY), (String)("Expected table " + table + " to be gone."));
                FunctionalTestUtils.assertNoDanglingFateLocks(ConcurrentDeleteTableIT.getCluster());
            }
            es.shutdown();
        }
    }

    private TreeSet<Text> createSplits() {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < 1000; ++i) {
            Text split = new Text(String.format("%09x", i * 100000));
            splits.add(split);
        }
        return splits;
    }

    private void writeData(AccumuloClient c, String table) throws TableNotFoundException, MutationsRejectedException {
        try (BatchWriter bw = c.createBatchWriter(table);){
            for (int i = 0; i < 1000; ++i) {
                Mutation m = new Mutation((CharSequence)String.format("%09x", random.nextInt(100000000)));
                m.put((CharSequence)"m", (CharSequence)"order", (CharSequence)("" + i));
                bw.addMutation(m);
            }
        }
    }

    private static abstract class DelayedTableOp
    implements Runnable {
        private final CountDownLatch cdl;

        DelayedTableOp(CountDownLatch cdl) {
            this.cdl = cdl;
        }

        @Override
        public void run() {
            block4: {
                try {
                    this.cdl.countDown();
                    this.cdl.await();
                    Thread.sleep(10L);
                    this.doTableOp();
                }
                catch (TableNotFoundException | TableOfflineException throwable) {
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (e.getCause().getClass().equals(ThriftTableOperationException.class) && (e.getMessage().equals("Compaction canceled") || e.getMessage().equals("Table is being deleted"))) break block4;
                    throw new RuntimeException(e);
                }
            }
        }

        protected abstract void doTableOp() throws Exception;
    }
}

